/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.LambdaCheckerFactory;
import automata.LambdaTransitionChecker;
import automata.Transition;
import gui.action.AutomatonAction;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.Environment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LambdaHighlightAction
extends AutomatonAction {
    private Automaton automaton;
    private Environment environment;

    public LambdaHighlightAction(Automaton automaton, Environment environment) {
        super("Highlight " + Universe.curProfile.getEmptyString() + "-Transitions", null);
        this.automaton = automaton;
        this.environment = environment;
    }

    public void actionPerformed(ActionEvent event) {
        Transition[] t = this.automaton.getTransitions();
        HashSet<Transition> lambdas = new HashSet<Transition>();
        LambdaTransitionChecker checker = LambdaCheckerFactory.getLambdaChecker(this.automaton);
        int i = 0;
        while (i < t.length) {
            if (checker.isLambdaTransition(t[i])) {
                lambdas.add(t[i]);
            }
            ++i;
        }
        SelectionDrawer as = new SelectionDrawer(this.automaton);
        Iterator it = lambdas.iterator();
        while (it.hasNext()) {
            Transition lt = (Transition)it.next();
            as.addSelected(lt);
        }
        LambdaPane pane = new LambdaPane(new AutomatonPane(as));
        this.environment.add((Component)pane, String.valueOf(Universe.curProfile.getEmptyString()) + "-Transitions", new CriticalTag(){});
        this.environment.setActive(pane);
    }

    private class LambdaPane
    extends JPanel {
        public LambdaPane(AutomatonPane ap) {
            super(new BorderLayout());
            this.add((Component)ap, "Center");
            this.add((Component)new JLabel(String.valueOf(Universe.curProfile.getEmptyString()) + "-transitions are highlighted."), "North");
            ArrowDisplayOnlyTool tool = new ArrowDisplayOnlyTool(ap, ap.getDrawer());
            ap.addMouseListener(tool);
        }
    }
}

