/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.turing.TuringMachine;
import gui.JTableExtender;
import gui.action.MultipleSimulateAction;
import gui.environment.Environment;
import gui.sim.multiple.InputTableModel;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class MultipleOutputSimulateAction
extends MultipleSimulateAction {
    public MultipleOutputSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Multiple Run (Transducer)");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, MAIN_MENU_MASK));
    }

    public String getComponentTitle() {
        return "Multiple Runs";
    }

    protected JTableExtender initializeTable(Object obj) {
        boolean multiple = false;
        if (this.getEnvironment().myObjects != null) {
            multiple = true;
        }
        InputTableModel model = InputTableModel.getModel((Automaton)this.getObject(), multiple);
        JTableExtender table = new JTableExtender((TableModel)model, this);
        table.setShowGrid(true);
        table.setGridColor(Color.lightGray);
        if (multiple) {
            ArrayList autos = this.getEnvironment().myObjects;
            ArrayList strings = this.getEnvironment().myTestStrings;
            ArrayList outs = this.getEnvironment().myTransducerStrings;
            int offset = strings.size();
            int tapeNum = 1;
            if (autos.get(0) instanceof TuringMachine) {
                tapeNum = ((TuringMachine)autos.get((int)0)).tapes;
                offset /= tapeNum;
            }
            int row = 0;
            int m = 0;
            while (m < autos.size()) {
                int k = 0;
                while (k < strings.size()) {
                    row = k / tapeNum + offset * m;
                    model.setValueAt(((Automaton)autos.get(m)).getFileName(), row, 0);
                    model.setValueAt((String)strings.get(k), row, k % tapeNum + 1);
                    ++k;
                }
                ++m;
            }
        }
        return table;
    }

    public static boolean isApplicable(Object object) {
        return object instanceof TuringMachine;
    }
}

