/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.turing.TuringMachine;
import file.Codec;
import file.DataException;
import file.ParseException;
import gui.action.RestrictedAction;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class OpenAction
extends RestrictedAction {
    private static boolean openOrRead = false;
    private JFileChooser fileChooser;
    private static Serializable lastObject = null;
    private static File lastFile = null;
    private static boolean lastFileOpened = false;

    public OpenAction() {
        super("Open...", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, MAIN_MENU_MASK));
        this.fileChooser = Universe.CHOOSER;
    }

    public void actionPerformed(ActionEvent event) {
        Component source = null;
        lastFileOpened = false;
        try {
            source = (Component)event.getSource();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File tempFile = this.fileChooser.getCurrentDirectory();
        this.fileChooser.setCurrentDirectory(tempFile.getParentFile());
        this.fileChooser.setCurrentDirectory(tempFile);
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setMultiSelectionEnabled(true);
        Codec[] codecs = null;
        codecs = OpenAction.makeFilters();
        int result = this.fileChooser.showOpenDialog(source);
        if (result != 0) {
            return;
        }
        File[] files = this.fileChooser.getSelectedFiles();
        int k = 0;
        while (k < files.length) {
            File file = files[k];
            if (!openOrRead && Universe.frameForFile(file) != null) {
                Universe.frameForFile(file).toFront();
                return;
            }
            try {
                OpenAction.openFile(file, codecs);
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(source, e.getMessage(), "Read Error", 0);
            }
            catch (DataException e) {
                JOptionPane.showMessageDialog(source, e.getMessage(), "Data Error", 0);
            }
            ++k;
        }
        lastFileOpened = true;
    }

    public static Serializable readFileAndCodecs(File file) {
        OpenAction.setOpenOrRead(true);
        Codec[] codecs = null;
        codecs = OpenAction.makeFilters();
        OpenAction.openFile(file, codecs);
        OpenAction.setOpenOrRead(false);
        return OpenAction.getLastObjectOpened();
    }

    public static Codec[] makeFilters() {
        Universe.CHOOSER.resetChoosableFileFilters();
        List decoders = Universe.CODEC_REGISTRY.getDecoders();
        Iterator it = decoders.iterator();
        while (it.hasNext()) {
            Universe.CHOOSER.addChoosableFileFilter((FileFilter)it.next());
        }
        Universe.CHOOSER.setFileFilter(Universe.CHOOSER.getAcceptAllFileFilter());
        Codec[] codecs = null;
        FileFilter filter = Universe.CHOOSER.getFileFilter();
        codecs = filter == Universe.CHOOSER.getAcceptAllFileFilter() ? decoders.toArray(new Codec[0]) : new Codec[]{(Codec)filter};
        Universe.CHOOSER.resetChoosableFileFilters();
        return codecs;
    }

    public static void openFile(File file, Codec[] codecs) {
        ParseException p = null;
        int i = 0;
        while (i < codecs.length) {
            try {
                Serializable object = codecs[i].decode(file, null);
                if (openOrRead && !(object instanceof TuringMachine)) {
                    JOptionPane.showMessageDialog(null, "Only Turing Machine files can be added as building blocks.", "Wrong File Type", 0);
                    return;
                }
                lastObject = object;
                lastFile = file;
                if (!openOrRead) {
                    EnvironmentFrame ef = FrameFactory.createFrame(object);
                    if (ef == null) {
                        return;
                    }
                    ef.getEnvironment().setFile(file);
                    ef.getEnvironment().setEncoder(codecs[i].correspondingEncoder());
                }
                return;
            }
            catch (ParseException e) {
                p = e;
                ++i;
            }
        }
        if (codecs.length != 1) {
            p = new ParseException("No format could read the file!");
        }
        throw p;
    }

    public static boolean isApplicable(Object object) {
        return true;
    }

    public static Serializable getLastObjectOpened() {
        return lastObject;
    }

    public static File getLastFileOpened() {
        return lastFile;
    }

    public static boolean isOpened() {
        return lastFileOpened;
    }

    public static void setOpenOrRead(boolean b) {
        openOrRead = b;
    }

    protected static class FileReadException
    extends RuntimeException {
        public FileReadException(String message) {
            super(message);
        }
    }
}

