/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.SimulatorFactory;
import automata.State;
import automata.mealy.MealyMachine;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.action.AutomatonAction;
import gui.action.SimulateNoClosureAction;
import gui.editor.EditBlockPane;
import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.sim.SimulatorPane;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SimulateAction
extends AutomatonAction {
    private Grammar gram;
    private Automaton automaton;
    private Environment environment;

    public SimulateAction(Automaton automaton, Environment environment) {
        super("Step...", null);
        if (SimulateNoClosureAction.isApplicable(automaton)) {
            this.putValue("Name", "Step with Closure...");
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, MAIN_MENU_MASK));
        this.automaton = automaton;
        this.environment = environment;
    }

    public SimulateAction(Grammar gram, Environment environment) {
        super("Step...", null);
        if (SimulateNoClosureAction.isApplicable(this.automaton)) {
            this.putValue("Name", "Step with Closure...");
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, MAIN_MENU_MASK));
        this.gram = gram;
        this.environment = environment;
    }

    protected AutomatonSimulator getSimulator(Automaton automaton) {
        return SimulatorFactory.getSimulator(automaton);
    }

    protected void handleInteraction(Automaton automaton, AutomatonSimulator simulator, Configuration[] configurations, Object initialInput) {
        SimulatorPane simpane = new SimulatorPane(automaton, simulator, configurations, this.environment, false);
        if (initialInput instanceof String[]) {
            initialInput = Arrays.asList((String[])initialInput);
        }
        this.environment.add((Component)simpane, "Simulate: " + initialInput, new CriticalTag(){});
        this.environment.setActive(simpane);
    }

    protected Object initialInput(Component component, String title) {
        if (title.equals("")) {
            title = "Input";
        }
        if (this.getObject() instanceof TuringMachine) {
            TuringMachine tm = (TuringMachine)this.getObject();
            int tapes = tm.tapes();
            if (title.equals("Expected Result? (Accept or Reject)")) {
                title = "Result";
                tapes = 1;
            }
            if (title.equals("Expected Output?")) {
                title = "Output";
            }
            JPanel panel = new JPanel(new GridLayout(tapes, 2));
            JTextField[] fields = new JTextField[tapes];
            int i = 0;
            while (i < tapes) {
                panel.add(new JLabel(String.valueOf(title) + " " + (i + 1)));
                fields[i] = new JTextField();
                panel.add(fields[i]);
                ++i;
            }
            int result = JOptionPane.showOptionDialog(component, panel, title, 2, 3, null, null, null);
            if (result != 0 && result != 0) {
                return null;
            }
            String[] input = new String[tapes];
            int i2 = 0;
            while (i2 < tapes) {
                input[i2] = fields[i2].getText();
                ++i2;
            }
            return input;
        }
        if (title.equals("")) {
            return JOptionPane.showInputDialog(component, (Object)"Input?");
        }
        return JOptionPane.showInputDialog(component, (Object)(String.valueOf(title) + "?"));
    }

    public void actionPerformed(ActionEvent e) {
        NondeterminismDetector d;
        State[] nd;
        boolean blockEdit = false;
        if (this.environment.getActive() instanceof EditBlockPane) {
            EditBlockPane newPane = (EditBlockPane)this.environment.getActive();
            this.automaton = newPane.getAutomaton();
            blockEdit = true;
        }
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog((Component)e.getSource(), "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return;
        }
        if (this.automaton instanceof MealyMachine && (nd = (d = NondeterminismDetectorFactory.getDetector(this.automaton)).getNondeterministicStates(this.automaton)).length > 0) {
            JOptionPane.showMessageDialog((Component)e.getSource(), "Please remove nondeterminism for simulation.\nSelect menu item Test : Highlight Nondeterminism\nto see nondeterministic states.", "Nondeterministic states detected", 0);
            return;
        }
        Object input = this.initialInput((Component)e.getSource(), "");
        if (input == null) {
            return;
        }
        Configuration[] configs = null;
        AutomatonSimulator simulator = this.getSimulator(this.automaton);
        if (this.getObject() instanceof TuringMachine) {
            String[] s = (String[])input;
            configs = ((TMSimulator)simulator).getInitialConfigurations(s);
        } else {
            String s = (String)input;
            configs = simulator.getInitialConfigurations(s);
        }
        this.handleInteraction(this.automaton, simulator, configs, input);
    }

    public static boolean isApplicable(Object object) {
        return object instanceof Automaton;
    }

    protected Object getObject() {
        if (this.automaton != null) {
            return this.automaton;
        }
        return this.gram;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(Environment newEnv) {
        this.environment = newEnv;
    }
}

