/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.fsa.FiniteStateAutomaton;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import file.Codec;
import file.DataException;
import file.ParseException;
import grammar.Grammar;
import gui.action.MultipleOutputSimulateAction;
import gui.action.MultipleSimulateAction;
import gui.action.OpenAction;
import gui.action.RestrictedAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class TestAction
extends RestrictedAction {
    private JFileChooser fileChooser;
    public static ArrayList myObjects = new ArrayList();
    public static EnvironmentFrame myEnvFrame;

    public TestAction() {
        super("Batch Test", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, MAIN_MENU_MASK));
        this.fileChooser = Universe.CHOOSER;
    }

    public TestAction(String name, int key) {
        super(name, null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key, MAIN_MENU_MASK));
        this.fileChooser = Universe.CHOOSER;
    }

    public ArrayList chooseFile(Component source, boolean fromPerformAction) {
        File tempFile = this.fileChooser.getCurrentDirectory();
        this.fileChooser.setCurrentDirectory(tempFile.getParentFile());
        this.fileChooser.setCurrentDirectory(tempFile);
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setDialogTitle("Choose Files Of The Same Type To Test");
        Codec[] codecs = null;
        codecs = OpenAction.makeFilters();
        int result = this.fileChooser.showOpenDialog(source);
        if (result != 0) {
            return null;
        }
        File[] files = this.fileChooser.getSelectedFiles();
        int k = 0;
        while (k < files.length) {
            File file = files[k];
            if (!file.getAbsolutePath().endsWith(".jff")) {
                JOptionPane.showMessageDialog(source, "One of the files does not end in .jff", "Read Error", 0);
                return null;
            }
            try {
                if (k == 0) {
                    TestAction.openFile(file, codecs, fromPerformAction);
                } else {
                    TestAction.openFile(file, codecs, false);
                }
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(source, e.getMessage(), "Read Error", 0);
            }
            catch (DataException e) {
                JOptionPane.showMessageDialog(source, e.getMessage(), "Data Error", 0);
            }
            ++k;
        }
        if (files == null) {
            return null;
        }
        myEnvFrame.getEnvironment().setMultipleObjects(myObjects);
        return myObjects;
    }

    public boolean checkRightType(Environment env, Component source) {
        if (env.myObjects.size() == 0) {
            return false;
        }
        Object first = env.myObjects.get(0);
        int firstType = this.findType(first);
        int i = 0;
        while (i < env.myObjects.size()) {
            int curType = this.findType(env.myObjects.get(i));
            if (curType == 0) {
                JOptionPane.showMessageDialog(source, "This feature only works with Finite Automata, Pushdown Automata, and Turing Machines", "Error", 0);
                return false;
            }
            if (firstType != curType) {
                JOptionPane.showMessageDialog(source, "Files Must Be The Same Type", "Error", 0);
                return false;
            }
            ++i;
        }
        return true;
    }

    public void performAction(Component source) {
        ArrayList files = null;
        boolean sameType = false;
        while (files == null || !sameType) {
            if (myEnvFrame != null) {
                TestAction.myEnvFrame.getEnvironment().myObjects.clear();
            }
            files = this.chooseFile(source, true);
            try {
                sameType = this.checkRightType(myEnvFrame.getEnvironment(), source);
            }
            catch (NullPointerException e) {
                return;
            }
            if (files != null) continue;
            return;
        }
        this.fileChooser.setDialogTitle("Choose file of strings to test on machines");
        this.fileChooser.setFileFilter(new inputFilter());
        int result = this.fileChooser.showOpenDialog(source);
        ArrayList<String> testStrings = new ArrayList<String>();
        ArrayList<String> transStrings = new ArrayList<String>();
        if (result == 0) {
            File textFile = this.fileChooser.getSelectedFile();
            try {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(textFile));
                Object first = TestAction.myEnvFrame.getEnvironment().myObjects.get(0);
                int numberInputs = 1;
                if (first instanceof TuringMachine) {
                    TuringMachine firstTM = (TuringMachine)first;
                    numberInputs = firstTM.tapes;
                }
                boolean reject = false;
                while ((str = in.readLine()) != null) {
                    reject = false;
                    if (str.equals("")) continue;
                    String[] strings = str.split(" ");
                    int k = 0;
                    while (k < numberInputs) {
                        testStrings.add(strings[k]);
                        if (strings[strings.length - 1].toLowerCase().equals("reject")) {
                            reject = true;
                            transStrings.add("~");
                        } else if (strings.length > k + 1 + numberInputs) {
                            transStrings.add(strings[k + numberInputs]);
                        } else {
                            transStrings.add("~");
                        }
                        ++k;
                    }
                    if (reject && transStrings.size() > 0) {
                        transStrings.add("reject");
                        continue;
                    }
                    transStrings.add("accept");
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        TestAction.myEnvFrame.getEnvironment().myTestStrings = testStrings;
        TestAction.myEnvFrame.getEnvironment().myTransducerStrings = transStrings;
        this.displayMultipleRunPane(myEnvFrame.getEnvironment(), myObjects.get(0));
    }

    public void actionPerformed(ActionEvent event) {
        Component source = null;
        try {
            source = (Component)event.getSource();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.performAction(source);
    }

    private int findType(Object auto) {
        int type = 0;
        if (auto instanceof TuringMachine) {
            type = 1;
        } else if (auto instanceof PushdownAutomaton) {
            type = 2;
        } else if (auto instanceof FiniteStateAutomaton) {
            type = 3;
        } else if (auto instanceof Grammar) {
            type = 4;
        }
        return type;
    }

    protected void displayMultipleRunPane(Environment env, Object obj) {
        if (obj instanceof FiniteStateAutomaton) {
            MultipleSimulateAction act = new MultipleSimulateAction((Automaton)obj, env);
            act.performAction(env);
        } else if (obj instanceof TuringMachine) {
            MultipleOutputSimulateAction act = new MultipleOutputSimulateAction((Automaton)obj, env);
            act.performAction(env);
        } else if (obj instanceof PushdownAutomaton) {
            MultipleSimulateAction act = new MultipleSimulateAction((Automaton)obj, env);
            act.performAction(env);
        } else if (obj instanceof Grammar) {
            MultipleSimulateAction act = new MultipleSimulateAction((Grammar)obj, env);
            act.performAction(env);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Environment openFile(File file, Codec[] codecs, boolean makeFrame) {
        ParseException p = null;
        int i = 0;
        if (i < codecs.length) {
            try {
                Serializable object = codecs[i].decode(file, null);
                if (object instanceof Automaton) {
                    Automaton auto = (Automaton)object;
                    try {
                        auto.setFilePath(file.getCanonicalPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (object instanceof Grammar) {
                    try {
                        Grammar gram = (Grammar)object;
                        gram.setFilePath(file.getCanonicalPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                myObjects.add(object);
                if (makeFrame) {
                    myEnvFrame = FrameFactory.createFrame(object);
                    if (myEnvFrame == null) {
                        return null;
                    }
                    myEnvFrame.getEnvironment().setFile(file);
                    myEnvFrame.getEnvironment().setEncoder(codecs[i].correspondingEncoder());
                    return myEnvFrame.getEnvironment();
                }
                if (object instanceof Automaton) {
                    ((Automaton)object).setEnvironmentFrame(myEnvFrame);
                    return null;
                }
                if (!(object instanceof Grammar)) return null;
                ((Grammar)object).setEnvironmentFrame(myEnvFrame);
                return null;
            }
            catch (ParseException e) {
                p = e;
            }
            return null;
        }
        if (codecs.length == 1) throw p;
        p = new ParseException("No format could read the file!");
        throw p;
    }

    class inputFilter
    extends FileFilter {
        inputFilter() {
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".txt");
        }

        public String getDescription() {
            return "*.txt";
        }
    }
}

