/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.NFAToDFA;
import automata.graph.GEMLayoutAlgorithm;
import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import gui.deterministic.ConversionPane;
import gui.environment.FrameFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class ConversionController {
    private FiniteStateAutomaton nfa;
    private FiniteStateAutomaton dfa;
    private FiniteStateAutomaton answer;
    private ConversionPane view;
    private NFAToDFA converter = new NFAToDFA();
    private Graph graph = new Graph();
    private boolean validLayout = false;
    private LayoutAlgorithm layout = new GEMLayoutAlgorithm();
    private Map setToState = new HashMap();
    private Map stateToSet = new HashMap();

    public ConversionController(FiniteStateAutomaton nfa, FiniteStateAutomaton dfa, ConversionPane view) {
        this.nfa = nfa;
        this.dfa = dfa;
        this.view = view;
        this.converter.createInitialState(nfa, dfa).setPoint(new Point(50, 50));
        this.registerState(dfa.getInitialState());
        this.answer = this.converter.convertToDFA(nfa);
        this.initializeGraph();
    }

    private void initializeGraph() {
        HashMap<State, HashSet<State>> stateToSet = new HashMap<State, HashSet<State>>();
        State[] s = this.answer.getStates();
        Transition[] t = this.answer.getTransitions();
        int i = 0;
        while (i < s.length) {
            HashSet<State> fromNfa = new HashSet<State>(Arrays.asList(this.getStatesForString(s[i].getLabel(), this.nfa)));
            stateToSet.put(s[i], fromNfa);
            this.graph.addVertex(fromNfa, s[i].getPoint());
            ++i;
        }
        i = 0;
        while (i < t.length) {
            this.graph.addEdge(stateToSet.get(t[i].getFromState()), stateToSet.get(t[i].getToState()));
            ++i;
        }
    }

    public void performFirstLayout() {
        this.view.validate();
        HashSet<Set> isonodes = new HashSet<Set>();
        Set initialSet = (Set)this.stateToSet.get(this.dfa.getInitialState());
        isonodes.add(initialSet);
        this.graph.addVertex(initialSet, new Point(0, 0));
        this.layout.layout(this.graph, isonodes);
        Rectangle r = this.view.editor.getBounds(null);
        r.grow(-50, -50);
        this.graph.moveWithinFrame(r);
        Point p = new Point();
        p.setLocation(this.graph.pointForVertex(initialSet));
        this.dfa.getInitialState().setPoint(p);
    }

    private State[] getStatesForString(String label, Automaton automaton) {
        StringTokenizer tokenizer = new StringTokenizer(label, " \t\n\r\f,q");
        ArrayList<State> states = new ArrayList<State>();
        while (tokenizer.hasMoreTokens()) {
            states.add(automaton.getStateWithID(Integer.parseInt(tokenizer.nextToken())));
        }
        states.remove(null);
        return states.toArray(new State[0]);
    }

    private void registerState(State state) {
        HashSet<State> set = new HashSet<State>(Arrays.asList(this.getStatesForString(state.getLabel(), this.nfa)));
        State inMap = (State)this.setToState.get(set);
        if (inMap != null && inMap != state) {
            throw new IllegalArgumentException("This set is in the DFA!");
        }
        this.setToState.put(set, state);
        this.stateToSet.put(state, set);
    }

    public void expandState(State state) {
        State dfaState;
        ArrayList createdStates = this.converter.expandState(state, this.nfa, this.dfa);
        HashSet iso = new HashSet(this.setToState.keySet());
        HashSet added = new HashSet();
        Iterator it = createdStates.iterator();
        while (it.hasNext()) {
            dfaState = (State)it.next();
            this.registerState(dfaState);
            iso.remove(this.stateToSet.get(dfaState));
        }
        this.layout.layout(this.graph, iso);
        it = createdStates.iterator();
        while (it.hasNext()) {
            dfaState = (State)it.next();
            Object o = this.stateToSet.get(dfaState);
            dfaState.getPoint().setLocation(this.graph.pointForVertex(o));
            dfaState.setPoint(dfaState.getPoint());
        }
    }

    public void expandState(State start, Point point, State end) {
        String terminal = JOptionPane.showInputDialog(this.view, (Object)"Expand on what terminal?");
        if (terminal == null) {
            return;
        }
        if (terminal.equals("")) {
            JOptionPane.showMessageDialog(this.view, "One can't have lambda in the DFA!", "Improper terminal", 0);
            return;
        }
        State[] states = this.getStatesForString(start.getLabel(), this.nfa);
        State[] endStates = this.converter.getStatesOnTerminal(terminal, states, this.nfa);
        if (endStates.length == 0) {
            JOptionPane.showMessageDialog(this.view, "The group {" + start.getLabel() + "} does not expand on the terminal " + terminal + "!", "Improper expansion", 0);
            return;
        }
        String userEnd = "";
        if (end == null) {
            userEnd = JOptionPane.showInputDialog(this.view, (Object)("Which group of NFA states will that go to on " + terminal + "?"));
        }
        if (userEnd == null) {
            return;
        }
        State[] userEndStates = endStates;
        try {
            if (end == null) {
                userEndStates = this.getStatesForString(userEnd, this.nfa);
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.view, "The list of states is not formatted correctly!", "Format error", 0);
            return;
        }
        if (!this.converter.containSameStates(userEndStates, endStates)) {
            JOptionPane.showMessageDialog(this.view, "That list of states is incorrect!", "Wrong set", 0);
            return;
        }
        State end2 = this.converter.getStateForStates(userEndStates, this.dfa, this.nfa);
        if (end == null) {
            end = end2;
        }
        if (end != end2) {
            JOptionPane.showMessageDialog(this.view, "The group {" + start.getLabel() + "} does not go to\n" + "group {" + end.getLabel() + "} on terminal " + terminal + "!", "Improper transition", 0);
            return;
        }
        if (end == null) {
            end = this.converter.createStateWithStates(this.dfa, userEndStates, this.nfa);
            this.registerState(end);
            end.setPoint(point);
        }
        FSATransition t = new FSATransition(start, end, terminal);
        this.dfa.addTransition(t);
    }

    public void complete() {
        final LinkedList<State> stateQueue = new LinkedList<State>();
        stateQueue.addAll(Arrays.asList(this.dfa.getStates()));
        AutomataStateListener listener = new AutomataStateListener(){

            public void automataStateChange(AutomataStateEvent e) {
                if (!e.isAdd()) {
                    return;
                }
                stateQueue.addLast(e.getState());
            }
        };
        this.dfa.addStateListener(listener);
        while (stateQueue.size() != 0) {
            this.expandState((State)stateQueue.removeFirst());
        }
        this.dfa.removeStateListener(listener);
    }

    public void done() {
        int transitionsRemaining;
        int statesRemaining = this.answer.getStates().length - this.dfa.getStates().length;
        if (statesRemaining + (transitionsRemaining = this.answer.getTransitions().length - this.dfa.getTransitions().length) != 0) {
            String states;
            String string = statesRemaining == 0 ? "All the states are there.\n" : (states = String.valueOf(statesRemaining) + " more state" + (statesRemaining == 1 ? "" : "s") + " must be placed.\n");
            String trans = transitionsRemaining == 0 ? "All the transitions are there.\n" : String.valueOf(transitionsRemaining) + " more transition" + (transitionsRemaining == 1 ? "" : "s") + " must be placed.\n";
            String message = "The DFA has not been completed.\n" + states + trans;
            JOptionPane.showMessageDialog(this.view, message);
            return;
        }
        JOptionPane.showMessageDialog(this.view, "The DFA is fully built!\nIt will now be placed in a new window.");
        FrameFactory.createFrame((FiniteStateAutomaton)this.dfa.clone());
    }
}

