/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.State;
import gui.deterministic.ConversionController;
import gui.editor.Tool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class StateExpanderTool
extends Tool {
    private ConversionController controller;

    public StateExpanderTool(AutomatonPane view, AutomatonDrawer drawer, ConversionController controller) {
        super(view, drawer);
        this.controller = controller;
    }

    public String getToolTip() {
        return "State Expander";
    }

    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/state_expander.gif");
        return new ImageIcon(url);
    }

    public void mousePressed(MouseEvent event) {
        State state = this.getDrawer().stateAtPoint(event.getPoint());
        if (state == null) {
            return;
        }
        this.controller.expandState(state);
    }

    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('s');
    }
}

