/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.StateRenamer;
import automata.Transition;
import automata.graph.AutomatonGraph;
import automata.graph.GEMLayoutAlgorithm;
import automata.turing.TMTransition;
import gui.editor.ArrowDisplayOnlyTool;
import gui.editor.EditBlockPane;
import gui.editor.Tool;
import gui.editor.TransitionCreator;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.tag.CriticalTag;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ArrowTool
extends Tool {
    private TransitionCreator creator;
    private State lastClickedState = null;
    private Transition lastClickedTransition = null;
    private Note lastClickedNote = null;
    private Point initialPointState = new Point();
    private Point initialPointClick = new Point();
    protected StateMenu stateMenu = new StateMenu();
    private TransitionMenu transitionMenu = new TransitionMenu();
    private EmptyMenu emptyMenu = new EmptyMenu();

    public ArrowTool(AutomatonPane view, AutomatonDrawer drawer, TransitionCreator creator) {
        super(view, drawer);
        this.creator = creator;
    }

    public ArrowTool(AutomatonPane view, AutomatonDrawer drawer) {
        super(view, drawer);
        this.creator = TransitionCreator.creatorForAutomaton(this.getAutomaton(), this.getView());
    }

    public String getToolTip() {
        return "Attribute Editor";
    }

    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/arrow.gif");
        return new ImageIcon(url);
    }

    public void mouseClicked(MouseEvent event) {
        Transition trans = this.getDrawer().transitionAtPoint(event.getPoint());
        if (trans == null) {
            Rectangle bounds = new Rectangle(0, 0, -1, -1);
            this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
            this.getView().repaint();
            return;
        }
        this.creator.editTransition(trans, event.getPoint());
    }

    protected void showPopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point p = this.getView().transformFromAutomatonToView(event.getPoint());
            if (this.lastClickedState != null && this.shouldShowStatePopup()) {
                this.stateMenu.show(this.lastClickedState, this.getView(), p);
            } else {
                this.emptyMenu.show(this.getView(), p);
            }
        }
        this.lastClickedState = null;
        this.lastClickedTransition = null;
    }

    public void mousePressed(MouseEvent event) {
        this.initialPointClick.setLocation(event.getPoint());
        this.lastClickedState = this.getDrawer().stateAtPoint(event.getPoint());
        if (this.lastClickedState == null) {
            this.lastClickedTransition = this.getDrawer().transitionAtPoint(event.getPoint());
        }
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
        if (this.lastClickedState != null) {
            this.initialPointState.setLocation(this.lastClickedState.getPoint());
            if (!this.lastClickedState.isSelected()) {
                Rectangle bounds = new Rectangle(0, 0, -1, -1);
                this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
                this.getView().getDrawer().setSelectionBounds(bounds);
                this.lastClickedState.setSelect(true);
            }
            this.getView().repaint();
        } else if (this.lastClickedTransition != null) {
            this.initialPointClick.setLocation(event.getPoint());
        } else {
            ArrayList notes = this.getDrawer().getAutomaton().getNotes();
            int k = 0;
            while (k < notes.size()) {
                ((Note)notes.get(k)).setEditable(false);
                ((Note)notes.get(k)).setEnabled(false);
                ((Note)notes.get(k)).setCaretColor(new Color(255, 255, 150));
                ++k;
            }
            Rectangle bounds = new Rectangle(0, 0, -1, -1);
            this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
            this.getView().getDrawer().setSelectionBounds(bounds);
        }
    }

    protected boolean shouldShowStatePopup() {
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        if (this.lastClickedState != null) {
            if (event.isPopupTrigger()) {
                return;
            }
            Point p = event.getPoint();
            State[] states = this.getView().getDrawer().getAutomaton().getStates();
            int k = 0;
            while (k < states.length) {
                State curState = states[k];
                if (curState.isSelected()) {
                    int x = curState.getPoint().x + p.x - this.initialPointClick.x;
                    int y = curState.getPoint().y + p.y - this.initialPointClick.y;
                    curState.getPoint().setLocation(x, y);
                    curState.setPoint(curState.getPoint());
                }
                ++k;
            }
            this.initialPointClick = p;
            this.getView().repaint();
        } else if (this.lastClickedTransition != null) {
            if (event.isPopupTrigger()) {
                return;
            }
            Point p = event.getPoint();
            int x = p.x - this.initialPointClick.x;
            int y = p.y - this.initialPointClick.y;
            State f = this.lastClickedTransition.getFromState();
            State t = this.lastClickedTransition.getToState();
            f.getPoint().translate(x, y);
            f.setPoint(f.getPoint());
            if (f != t) {
                t.getPoint().translate(x, y);
                t.setPoint(t.getPoint());
            }
            this.initialPointClick.setLocation(p);
            this.getView().repaint();
        } else {
            int nowX = event.getPoint().x;
            int nowY = event.getPoint().y;
            int leftX = this.initialPointClick.x;
            int topY = this.initialPointClick.y;
            if (nowX < this.initialPointClick.x) {
                leftX = nowX;
            }
            if (nowY < this.initialPointClick.y) {
                topY = nowY;
            }
            Rectangle bounds = new Rectangle(leftX, topY, Math.abs(nowX - this.initialPointClick.x), Math.abs(nowY - this.initialPointClick.y));
            this.getView().getDrawer().getAutomaton().selectStatesWithinBounds(bounds);
            this.getView().getDrawer().setSelectionBounds(bounds);
            this.getView().repaint();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
        State[] states = this.getView().getDrawer().getAutomaton().getStates();
        int count = 0;
        int k = 0;
        while (k < states.length) {
            if (states[k].isSelected()) {
                ++count;
            }
            ++k;
        }
        Rectangle bounds = this.getView().getDrawer().getSelectionBounds();
        if (count == 1 && bounds.isEmpty() && this.lastClickedState != null) {
            this.lastClickedState.setSelect(false);
        }
        bounds = new Rectangle(0, 0, -1, -1);
        this.getView().getDrawer().setSelectionBounds(bounds);
        this.lastClickedState = null;
        this.lastClickedTransition = null;
        this.getView().repaint();
    }

    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('a');
    }

    public boolean shouldAllowOnlyFinalStateChange() {
        return false;
    }

    protected class StateMenu
    extends JPopupMenu
    implements ActionListener {
        private State state = null;
        protected JCheckBoxMenuItem makeFinal = new JCheckBoxMenuItem("Final");
        protected JCheckBoxMenuItem makeInitial;
        private JMenuItem changeLabel;
        private JMenuItem deleteLabel;
        private JMenuItem deleteAllLabels;
        private JMenuItem editBlock;
        private JMenuItem copyBlock;
        private JMenuItem replaceSymbol;
        private JMenuItem setName;

        public StateMenu() {
            this.makeFinal.addActionListener(this);
            this.add(this.makeFinal);
            this.makeInitial = new JCheckBoxMenuItem("Initial");
            this.changeLabel = new JMenuItem("Change Label");
            this.deleteLabel = new JMenuItem("Clear Label");
            this.deleteAllLabels = new JMenuItem("Clear All Labels");
            this.editBlock = new JMenuItem("Edit Block");
            this.copyBlock = new JMenuItem("Duplicate Block");
            this.replaceSymbol = new JMenuItem("Replace Symbol");
            this.setName = new JMenuItem("Set Name");
            if (ArrowTool.this.shouldAllowOnlyFinalStateChange()) {
                return;
            }
            this.makeInitial.addActionListener(this);
            this.changeLabel.addActionListener(this);
            this.deleteLabel.addActionListener(this);
            this.deleteAllLabels.addActionListener(this);
            this.editBlock.addActionListener(this);
            this.setName.addActionListener(this);
            this.copyBlock.addActionListener(this);
            this.replaceSymbol.addActionListener(this);
            this.add(this.makeInitial);
            this.add(this.changeLabel);
            this.add(this.deleteLabel);
            this.add(this.deleteAllLabels);
            this.add(this.setName);
        }

        public void show(State state, Component comp, Point at) {
            this.remove(this.editBlock);
            this.state = state;
            if (state.getInternalName() != null) {
                this.add(this.editBlock);
                this.add(this.copyBlock);
                this.editBlock.setEnabled(true);
                this.copyBlock.setEnabled(true);
                this.add(this.replaceSymbol);
                this.replaceSymbol.setEnabled(true);
            }
            this.makeFinal.setSelected(ArrowTool.this.getAutomaton().isFinalState(state));
            this.makeInitial.setSelected(ArrowTool.this.getAutomaton().getInitialState() == state);
            this.deleteLabel.setEnabled(state.getLabel() != null);
            this.show(comp, at.x, at.y);
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            if (item == this.makeFinal) {
                if (item.isSelected()) {
                    ArrowTool.this.getAutomaton().addFinalState(this.state);
                } else {
                    ArrowTool.this.getAutomaton().removeFinalState(this.state);
                }
            } else if (item == this.makeInitial) {
                if (!item.isSelected()) {
                    this.state = null;
                }
                ArrowTool.this.getAutomaton().setInitialState(this.state);
            } else if (item == this.changeLabel) {
                String oldlabel = this.state.getLabel();
                oldlabel = oldlabel == null ? "" : oldlabel;
                String label = (String)JOptionPane.showInputDialog(this, "Input a new label, or \nset blank to remove the label", "New Label", 3, null, null, oldlabel);
                if (label == null) {
                    return;
                }
                if (label.equals("")) {
                    label = null;
                }
                this.state.setLabel(label);
            } else if (item == this.deleteLabel) {
                this.state.setLabel(null);
            } else if (item == this.deleteAllLabels) {
                State[] states = ArrowTool.this.getAutomaton().getStates();
                int i = 0;
                while (i < states.length) {
                    states[i].setLabel(null);
                    ++i;
                }
            } else if (item == this.editBlock) {
                State parent = this.state;
                while (parent.getParentBlock() != null) {
                    parent = parent.getParentBlock();
                }
                Automaton root = parent.getAutomaton();
                Automaton inside = (Automaton)this.state.getAutomaton().getBlockMap().get(this.state.getInternalName());
                EditBlockPane editor = new EditBlockPane((Automaton)inside.clone());
                EnvironmentFrame rootFrame = root.getEnvironmentFrame();
                editor.setBlock(this.state);
                Environment envir = rootFrame.getEnvironment();
                envir.add((Component)editor, "Edit Block", new CriticalTag(this){
                    final /* synthetic */ StateMenu this$1;
                    {
                        this.this$1 = stateMenu;
                    }
                });
                envir.setActive(editor);
            } else if (item == this.setName) {
                String oldName = this.state.getName();
                oldName = oldName == null ? "" : oldName;
                String name = (String)JOptionPane.showInputDialog(this, "Input a new name, or \nset blank to remove the name", "New Name", 3, null, null, oldName);
                if (name == null) {
                    return;
                }
                if (name.equals("")) {
                    name = null;
                }
                this.state.setName(name);
            } else if (item == this.copyBlock) {
                State buffer = ArrowTool.this.getAutomaton().createState((Point)this.state.getPoint().clone());
                buffer.setInternalName(this.state.getInternalName());
                buffer.setAutomaton(this.state.getAutomaton());
                buffer.setParentBlock(this.state.getParentBlock());
                buffer.setName("Copy " + this.state.getName());
            } else if (item == this.replaceSymbol) {
                String newString;
                State parent = this.state;
                while (parent.getParentBlock() != null) {
                    parent = parent.getParentBlock();
                }
                Automaton root = parent.getAutomaton();
                EnvironmentFrame rootFrame = root.getEnvironmentFrame();
                String replaceWith = null;
                String toReplace = null;
                String old = JOptionPane.showInputDialog(rootFrame.getEnvironment().getActive(), (Object)"Find");
                if (old == null) {
                    return;
                }
                if (old instanceof String) {
                    toReplace = old;
                }
                if ((newString = JOptionPane.showInputDialog(rootFrame.getEnvironment().getActive(), (Object)"Replace With")) == null) {
                    return;
                }
                if (newString instanceof String) {
                    replaceWith = newString;
                }
                this.replaceCharactersInBlock(this.state.getAutomaton(), toReplace, replaceWith);
            }
            ArrowTool.this.getView().repaint();
        }

        private void replaceCharactersInBlock(Automaton start, String toReplace, String replaceWith) {
            Iterator valueIt = start.getBlockMap().values().iterator();
            while (valueIt.hasNext()) {
                Automaton inside = (Automaton)valueIt.next();
                this.replaceCharactersInBlock(inside, toReplace, replaceWith);
                Transition[] trans = inside.getTransitions();
                int k = 0;
                while (k < trans.length) {
                    TMTransition tmTrans = (TMTransition)trans[k];
                    int i = 0;
                    while (i < tmTrans.tapes()) {
                        String read = tmTrans.getRead(i);
                        String newRead = "";
                        int m = 0;
                        while (m < read.length()) {
                            newRead = read.charAt(m) == toReplace.charAt(0) ? String.valueOf(newRead) + replaceWith : String.valueOf(newRead) + read.charAt(m);
                            ++m;
                        }
                        tmTrans.setRead(i, newRead);
                        String write = tmTrans.getWrite(i);
                        String newWrite = "";
                        int m2 = 0;
                        while (m2 < write.length()) {
                            newWrite = write.charAt(m2) == toReplace.charAt(0) ? String.valueOf(newWrite) + replaceWith : String.valueOf(newWrite) + write.charAt(m2);
                            ++m2;
                        }
                        tmTrans.setWrite(i, newWrite);
                        ++i;
                    }
                    ++k;
                }
            }
        }
    }

    private class TransitionMenu
    extends JPopupMenu {
        private TransitionMenu() {
        }
    }

    private class EmptyMenu
    extends JPopupMenu
    implements ActionListener {
        private Point myPoint;
        private JCheckBoxMenuItem stateLabels = new JCheckBoxMenuItem("Display State Labels");
        private Note curNote;
        private JMenuItem layoutGraph;
        private JMenuItem addNote;
        private JMenuItem renameStates;
        private JMenuItem adaptView;

        public EmptyMenu() {
            this.stateLabels.addActionListener(this);
            this.add(this.stateLabels);
            this.layoutGraph = new JMenuItem("Layout Graph");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.layoutGraph.addActionListener(this);
                this.add(this.layoutGraph);
            }
            this.renameStates = new JMenuItem("Rename States");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.renameStates.addActionListener(this);
                this.add(this.renameStates);
            }
            this.addNote = new JMenuItem("Add Note");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.addNote.addActionListener(this);
                this.add(this.addNote);
            }
            this.adaptView = new JCheckBoxMenuItem("Auto-Zoom");
            if (!(ArrowTool.this instanceof ArrowDisplayOnlyTool)) {
                this.adaptView.addActionListener(this);
                this.add(this.adaptView);
            }
        }

        public void show(Component comp, Point at) {
            this.stateLabels.setSelected(ArrowTool.this.getDrawer().doesDrawStateLabels());
            this.adaptView.setSelected(ArrowTool.this.getView().getAdapt());
            this.myPoint = at;
            this.show(comp, at.x, at.y);
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            if (item == this.stateLabels) {
                ArrowTool.this.getView().getDrawer().shouldDrawStateLabels(item.isSelected());
            } else if (item == this.layoutGraph) {
                AutomatonGraph g = new AutomatonGraph(ArrowTool.this.getAutomaton());
                GEMLayoutAlgorithm alg = new GEMLayoutAlgorithm();
                alg.layout(g, null);
                g.moveAutomatonStates();
                ArrowTool.this.getView().fitToBounds(30);
            } else if (item == this.renameStates) {
                StateRenamer.rename(ArrowTool.this.getAutomaton());
            } else if (item == this.adaptView) {
                ArrowTool.this.getView().setAdapt(item.isSelected());
            } else if (item == this.addNote) {
                Note newNote = new Note(this.myPoint, "insert_text");
                newNote.initializeForView(ArrowTool.this.getView());
                ArrowTool.this.getView().getDrawer().getAutomaton().addNote(newNote);
            }
            ArrowTool.this.getView().repaint();
            ArrowTool.this.emptyMenu = new EmptyMenu();
        }
    }
}

