/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import gui.editor.TMTransitionCreator;
import gui.editor.TransitionCreator;
import gui.editor.TransitionTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class BlockTransitionTool
extends TransitionTool {
    public BlockTransitionTool(AutomatonPane view, AutomatonDrawer drawer, TransitionCreator creator) {
        super(view, drawer);
        this.creator = creator;
    }

    public BlockTransitionTool(AutomatonPane view, AutomatonDrawer drawer) {
        super(view, drawer);
        this.creator = TransitionCreator.creatorForAutomaton(this.getAutomaton(), this.getView());
    }

    public void mouseReleased(MouseEvent event) {
        if (this.first == null) {
            return;
        }
        State state = this.getDrawer().stateAtPoint(event.getPoint());
        if (state != null && this.creator instanceof TMTransitionCreator) {
            TMTransitionCreator tmCreator = (TMTransitionCreator)this.creator;
            tmCreator.setBlockTransition(true);
            tmCreator.createTransition(this.first, state);
        }
        this.first = null;
        this.getView().repaint();
    }

    public String getToolTip() {
        return "BlockTransition Creator";
    }

    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/blockTransition.gif");
        return new ImageIcon(url);
    }
}

