/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import gui.editor.Tool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class DeleteTool
extends Tool {
    public DeleteTool(AutomatonPane view, AutomatonDrawer drawer) {
        super(view, drawer);
    }

    public String getToolTip() {
        return "Deleter";
    }

    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/delete.gif");
        return new ImageIcon(url);
    }

    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('d');
    }

    public void mouseClicked(MouseEvent event) {
        State state = this.getDrawer().stateAtPoint(event.getPoint());
        if (state != null) {
            this.getAutomaton().removeState(state);
            this.getView().repaint();
            return;
        }
        Transition trans = this.getDrawer().transitionAtPoint(event.getPoint());
        if (trans != null) {
            this.getAutomaton().removeTransition(trans);
            this.getView().repaint();
        }
    }
}

