/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import automata.Note;
import gui.editor.DefaultToolBox;
import gui.editor.EditCanvas;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.viewer.AutomatonDrawer;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class EditorPane
extends JComponent {
    protected Automaton automaton;
    protected AutomatonDrawer drawer;
    protected EditCanvas pane;
    protected ToolBar toolbar;

    public EditorPane(Automaton automaton) {
        this(new SelectionDrawer(automaton));
    }

    public EditorPane(Automaton automaton, ToolBox box) {
        this(new SelectionDrawer(automaton), box);
    }

    public EditorPane(AutomatonDrawer drawer) {
        this(drawer, (ToolBox)new DefaultToolBox());
    }

    public EditorPane(AutomatonDrawer drawer, ToolBox box) {
        this(drawer, box, false);
    }

    public EditorPane(AutomatonDrawer drawer, ToolBox box, boolean fit) {
        this.pane = new EditCanvas(drawer, fit);
        this.pane.setCreator(this);
        this.drawer = drawer;
        this.automaton = drawer.getAutomaton();
        this.setLayout(new BorderLayout());
        JPanel superpane = new JPanel();
        superpane.setLayout(new BorderLayout());
        superpane.add((Component)new JScrollPane(this.pane, 22, 32), "Center");
        superpane.setBorder(new BevelBorder(1));
        this.toolbar = new ToolBar(this.pane, drawer, box);
        this.pane.setToolBar(this.toolbar);
        this.add((Component)superpane, "Center");
        this.add((Component)this.toolbar, "North");
        ArrayList notes = drawer.getAutomaton().getNotes();
        int k = 0;
        while (k < notes.size()) {
            ((Note)notes.get(k)).initializeForView(this.pane);
            ++k;
        }
    }

    public ToolBar getToolBar() {
        return this.toolbar;
    }

    public AutomatonDrawer getDrawer() {
        return this.pane.getDrawer();
    }

    public EditCanvas getAutomatonPane() {
        return this.pane;
    }

    public void printComponent(Graphics g) {
        this.pane.print(g);
    }

    public void printChildren(Graphics g) {
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }
}

