/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class FSATransitionCreator
extends TableTransitionCreator {
    public FSATransitionCreator(AutomatonPane parent) {
        super(parent);
    }

    protected Transition initTransition(State from, State to) {
        return new FSATransition(from, to, "");
    }

    protected TableModel createModel(Transition transition) {
        FSATransition t = (FSATransition)transition;
        return new AbstractTableModel(t){
            String s;
            {
                this.s = fSATransition.getLabel();
            }

            public Object getValueAt(int row, int column) {
                return this.s;
            }

            public void setValueAt(Object o, int r, int c) {
                this.s = (String)o;
            }

            public boolean isCellEditable(int r, int c) {
                return true;
            }

            public int getRowCount() {
                return 1;
            }

            public int getColumnCount() {
                return 1;
            }

            public String getColumnName(int c) {
                return "Label";
            }
        };
    }

    public Transition modifyTransition(Transition t, TableModel model) {
        String s = (String)model.getValueAt(0, 0);
        try {
            return new FSATransition(t.getFromState(), t.getToState(), s);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }
}

