/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.mealy.MooreTransition;
import gui.editor.MealyTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class MooreTransitionCreator
extends MealyTransitionCreator {
    private static final String NAME = "Label";

    public MooreTransitionCreator(AutomatonPane parent) {
        super(parent);
    }

    protected Transition initTransition(State from, State to) {
        return new MooreTransition(from, to, "");
    }

    protected TableModel createModel(Transition transition) {
        MooreTransition t = (MooreTransition)transition;
        return new AbstractTableModel(t){
            String[] s;
            {
                this.s = new String[]{mooreTransition.getLabel()};
            }

            public Object getValueAt(int r, int c) {
                return this.s[c];
            }

            public void setValueAt(Object o, int r, int c) {
                this.s[c] = (String)o;
            }

            public boolean isCellEditable(int r, int c) {
                return true;
            }

            public int getRowCount() {
                return 1;
            }

            public int getColumnCount() {
                return 1;
            }

            public String getColumnName(int c) {
                return MooreTransitionCreator.NAME;
            }
        };
    }

    public Transition modifyTransition(Transition transition, TableModel model) {
        String label = (String)model.getValueAt(0, 0);
        MooreTransition t = (MooreTransition)transition;
        try {
            return new MooreTransition(t.getFromState(), t.getToState(), label);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }
}

