/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PDATransitionCreator
extends TableTransitionCreator {
    private static final String[] NAME = new String[]{"Read", "Pop", "Push"};

    public PDATransitionCreator(AutomatonPane parent) {
        super(parent);
    }

    protected Transition initTransition(State from, State to) {
        return new PDATransition(from, to, "", "", "");
    }

    protected TableModel createModel(Transition transition) {
        PDATransition t = (PDATransition)transition;
        return new AbstractTableModel(t){
            String[] s;
            {
                this.s = new String[]{pDATransition.getInputToRead(), pDATransition.getStringToPop(), pDATransition.getStringToPush()};
            }

            public Object getValueAt(int row, int column) {
                return this.s[column];
            }

            public void setValueAt(Object o, int r, int c) {
                this.s[c] = (String)o;
            }

            public boolean isCellEditable(int r, int c) {
                return true;
            }

            public int getRowCount() {
                return 1;
            }

            public int getColumnCount() {
                return 3;
            }

            public String getColumnName(int c) {
                return NAME[c];
            }
        };
    }

    public Transition modifyTransition(Transition transition, TableModel model) {
        String input = (String)model.getValueAt(0, 0);
        String pop = (String)model.getValueAt(0, 1);
        String push = (String)model.getValueAt(0, 2);
        PDATransition t = (PDATransition)transition;
        try {
            return new PDATransition(t.getFromState(), t.getToState(), input, pop, push);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }
}

