/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import gui.LambdaCellRenderer;
import gui.editor.TMTransitionCreator;
import gui.editor.TransitionCreator;
import gui.viewer.AutomatonPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class TableTransitionCreator
extends TransitionCreator {
    protected JTable editingTable = null;
    private Dimension tableDimensions;
    private Point tablePoint = new Point();
    private MouseListener viewListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            TableTransitionCreator.this.stopEditing(false);
        }
    };
    private boolean isNew;
    private Transition transition;

    public TableTransitionCreator(AutomatonPane parent) {
        super(parent);
        parent.addMouseListener(this.viewListener);
    }

    protected abstract Transition initTransition(State var1, State var2);

    protected abstract TableModel createModel(Transition var1);

    protected JTable createTable(final Transition transition) {
        TableModel model = this.createModel(transition);
        final TipLambdaCellRenderer[] renders = new TipLambdaCellRenderer[model.getColumnCount()];
        int i = 0;
        while (i < model.getColumnCount()) {
            renders[i] = transition instanceof TMTransition ? new TipLambdaCellRenderer("\u25a1", model.getColumnName(i)) : new TipLambdaCellRenderer(model.getColumnName(i));
            ++i;
        }
        JTable table = new JTable(this.createModel(transition)){

            public TableCellRenderer getCellRenderer(int r, int c) {
                return renders[c];
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (ks.getKeyCode() == 10 && !ks.isOnKeyRelease()) {
                    TableTransitionCreator.this.stopEditing(false);
                    if (e.isShiftDown()) {
                        TableTransitionCreator.this.createTransition(transition.getFromState(), transition.getToState());
                    }
                    return true;
                }
                if (ks.getKeyCode() == 27) {
                    TableTransitionCreator.this.stopEditing(true);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        table.setGridColor(Color.gray);
        table.setBorder(new EtchedBorder());
        return table;
    }

    protected abstract Transition modifyTransition(Transition var1, TableModel var2);

    private void stopEditing(boolean cancel) {
        if (this.editingTable == null) {
            return;
        }
        try {
            this.editingTable.getCellEditor().stopCellEditing();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException e) {
            System.err.println("Odd 'focusCycleRoot' exception thrown from the depths of Java again.");
        }
        if (!cancel) {
            TableModel oldModel = this.createModel(this.transition);
            Transition t = this.modifyTransition(this.transition, this.editingTable.getModel());
            if (t != null) {
                if (this.isNew) {
                    this.getParent().getDrawer().getAutomaton().addTransition(t);
                } else {
                    this.getParent().getDrawer().getAutomaton().replaceTransition(this.transition, t);
                }
            }
        }
        if (this instanceof TMTransitionCreator) {
            TMTransitionCreator stop = (TMTransitionCreator)this;
            stop.setBlockTransition(false);
        }
        this.getParent().remove(this.editingTable);
        this.getParent().validate();
        this.getParent().repaint();
        this.editingTable = null;
        this.getParent().requestFocus();
    }

    public boolean editTransition(Transition t) {
        return false;
    }

    public Transition createTransition(State from, State to) {
        Transition t = this.initTransition(from, to);
        this.editTransition(t, null);
        return null;
    }

    public void editTransition(Transition transition, Point point) {
        this.stopEditing(false);
        this.transition = transition;
        boolean bl = this.isNew = point == null;
        if (this.isNew) {
            State from = transition.getFromState();
            State to = transition.getToState();
            point = new Point((from.getPoint().x + to.getPoint().x) / 2, (from.getPoint().y + to.getPoint().y) / 2);
        }
        this.getParent().setTablePoint(this.tablePoint);
        this.editingTable = this.createTable(transition);
        this.getParent().add(this.editingTable);
        this.getParent().validate();
        this.tableDimensions = this.editingTable.getSize();
        this.tablePoint = this.getParent().transformFromAutomatonToView(point);
        this.tablePoint.translate(-this.tableDimensions.width / 2, -this.tableDimensions.height / 2);
        this.getParent().setTablePoint(this.tablePoint);
        this.editingTable.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
                e.getComponent().setLocation(TableTransitionCreator.this.tablePoint);
            }

            public void componentResized(ComponentEvent e) {
                e.getComponent().setSize(TableTransitionCreator.this.tableDimensions);
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        this.editingTable.setLocation(this.tablePoint);
        this.editingTable.setSize(this.tableDimensions);
        this.editingTable.requestFocus();
        this.getParent().repaint();
    }

    protected void editTransition(Transition transition, Point point, int tableSize) {
    }

    private static class TipLambdaCellRenderer
    extends LambdaCellRenderer {
        public TipLambdaCellRenderer(String replace, String tip) {
            super(replace);
            this.setToolTipText(tip);
        }

        public TipLambdaCellRenderer(String tip) {
            this.setToolTipText(tip);
        }
    }
}

