/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import gui.SuperMouseAdapter;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class Tool
extends SuperMouseAdapter {
    private AutomatonPane view;
    private AutomatonDrawer drawer;
    private Automaton automaton;

    public Tool(AutomatonPane view, AutomatonDrawer drawer) {
        this.view = view;
        this.drawer = drawer;
        this.automaton = drawer.getAutomaton();
    }

    public String getShortcutToolTip() {
        String tip = this.getToolTip();
        KeyStroke stroke = this.getKey();
        if (stroke == null) {
            return tip;
        }
        int index = Tool.findDominant(tip, stroke.getKeyChar());
        if (index == -1) {
            return String.valueOf(tip) + "(" + Character.toUpperCase(stroke.getKeyChar()) + ")";
        }
        return String.valueOf(tip.substring(0, index)) + "(" + tip.substring(index, index + 1) + ")" + tip.substring(index + 1, tip.length());
    }

    public String getToolTip() {
        return "Tool";
    }

    protected AutomatonPane getView() {
        return this.view;
    }

    protected AutomatonDrawer getDrawer() {
        return this.drawer;
    }

    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/default.gif");
        return new ImageIcon(url);
    }

    public void draw(Graphics g) {
    }

    protected Automaton getAutomaton() {
        return this.automaton;
    }

    public KeyStroke getKey() {
        return null;
    }

    protected static int findDominant(String string, char c) {
        int index = string.indexOf(Character.toUpperCase(c));
        if (index != -1) {
            return index;
        }
        return string.indexOf(Character.toLowerCase(c));
    }
}

