/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import gui.editor.EditCanvas;
import gui.editor.Tool;
import gui.editor.ToolAdapter;
import gui.editor.ToolBox;
import gui.viewer.AutomatonDrawer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class ToolBar
extends JToolBar
implements ActionListener {
    private Component view;
    private AutomatonDrawer drawer;
    private List tools;
    private HashMap buttonsToTools = new HashMap();
    private ToolAdapter adapter;
    private Tool currentTool = null;

    public ToolBar(EditCanvas view, AutomatonDrawer drawer, ToolBox box) {
        this.adapter = new ToolAdapter(view);
        this.view = view;
        this.drawer = drawer;
        this.tools = box.tools(view, drawer);
        this.initBar();
        view.addMouseListener(this.adapter);
        view.addMouseMotionListener(this.adapter);
    }

    protected Component getView() {
        return this.view;
    }

    protected AutomatonDrawer getDrawer() {
        return this.drawer;
    }

    private void initBar() {
        ButtonGroup group = new ButtonGroup();
        JToggleButton button = null;
        Iterator it = this.tools.iterator();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            button = new JToggleButton(tool.getIcon());
            this.buttonsToTools.put(button, tool);
            button.setToolTipText(tool.getShortcutToolTip());
            group.add(button);
            this.add(button);
            button.addActionListener(this);
            KeyStroke key = tool.getKey();
            if (key == null) continue;
            InputMap imap = button.getInputMap(2);
            ActionMap amap = button.getActionMap();
            Object o = new Object();
            imap.put(key, o);
            amap.put(o, new ButtonClicker(button));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Tool tool = (Tool)this.buttonsToTools.get(e.getSource());
        if (tool != null) {
            this.adapter.setAdapter(tool);
            this.currentTool = tool;
        }
    }

    public void drawTool(Graphics g) {
        if (this.currentTool == null) {
            return;
        }
        this.currentTool.draw(g);
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    private class ButtonClicker
    extends AbstractAction {
        AbstractButton button;

        public ButtonClicker(AbstractButton button) {
            this.button = button;
        }

        public void actionPerformed(ActionEvent e) {
            this.button.doClick();
        }
    }
}

