/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import gui.editor.Tool;
import gui.editor.TransitionCreator;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class TransitionTool
extends Tool {
    protected State first;
    protected Point hover;
    protected TransitionCreator creator;
    private static Stroke STROKE = new BasicStroke(2.4f);
    private static Color COLOR = new Color(0.5f, 0.5f, 0.5f, 0.5f);

    public TransitionTool(AutomatonPane view, AutomatonDrawer drawer, TransitionCreator creator) {
        super(view, drawer);
        this.creator = creator;
    }

    public TransitionTool(AutomatonPane view, AutomatonDrawer drawer) {
        super(view, drawer);
        this.creator = TransitionCreator.creatorForAutomaton(this.getAutomaton(), this.getView());
    }

    public String getToolTip() {
        return "Transition Creator";
    }

    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/transition.gif");
        return new ImageIcon(url);
    }

    public void mousePressed(MouseEvent event) {
        this.first = this.getDrawer().stateAtPoint(event.getPoint());
        if (this.first == null) {
            return;
        }
        this.hover = this.first.getPoint();
    }

    public void mouseDragged(MouseEvent event) {
        if (this.first == null) {
            return;
        }
        this.hover = event.getPoint();
        this.getView().repaint();
    }

    public void mouseReleased(MouseEvent event) {
        if (this.first == null) {
            return;
        }
        State state = this.getDrawer().stateAtPoint(event.getPoint());
        if (state != null) {
            this.creator.createTransition(this.first, state);
        }
        this.first = null;
        this.getView().repaint();
    }

    public void draw(Graphics g) {
        if (this.first == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke s = g2.getStroke();
        g2.setStroke(STROKE);
        g2.setColor(COLOR);
        g2.drawLine(this.first.getPoint().x, this.first.getPoint().y, this.hover.x, this.hover.y);
        g2.setStroke(s);
    }

    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('t');
    }
}

