/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.Encoder;
import gui.action.MultipleSimulateAction;
import gui.environment.FileChangeEvent;
import gui.environment.FileChangeListener;
import gui.environment.tag.CriticalTag;
import gui.environment.tag.EditorTag;
import gui.environment.tag.Satisfier;
import gui.environment.tag.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class Environment
extends JPanel {
    public ArrayList myObjects;
    public ArrayList myTestStrings;
    public ArrayList myTransducerStrings;
    private Encoder encoder = null;
    private HashMap componentTags = new HashMap();
    public JTabbedPane tabbed;
    private transient HashSet changeListeners = new HashSet();
    private Serializable theMainObject;
    private File file;
    private Set fileListeners = new HashSet();
    private int criticalObjects = 0;
    private boolean dirty = false;

    public Environment(Serializable object) {
        this.theMainObject = object;
        this.clearDirty();
        this.initView();
    }

    public Serializable getObject() {
        return this.theMainObject;
    }

    public void addFileChangeListener(FileChangeListener listener) {
        this.fileListeners.add(listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        this.fileListeners.remove(listener);
    }

    protected void distributeFileChangeEvent(FileChangeEvent event) {
        Iterator it = this.fileListeners.iterator();
        while (it.hasNext()) {
            FileChangeListener listener = (FileChangeListener)it.next();
            listener.fileChanged(event);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        this.distributeFileChangeEvent(new FileChangeEvent(this, oldFile));
    }

    public void setMultipleObjects(ArrayList objects) {
        this.myObjects = objects;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        this.tabbed = new JTabbedPane();
        super.add((Component)this.tabbed, "Center");
        this.tabbed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Environment.this.distributeChangeEvent();
            }
        });
    }

    public void add(Component component, String name, Tag tags) {
        this.componentTags.put(component, tags);
        this.tabbed.addTab(name, component);
        if (tags instanceof CriticalTag) {
            ++this.criticalObjects;
            if (this.criticalObjects == 1) {
                this.setEnabledEditorTagged(false);
            }
        }
        this.distributeChangeEvent();
    }

    public boolean contains(Component component) {
        return this.tabbed.indexOfComponent(component) != -1;
    }

    public void setEnabledEditorTagged(boolean enabled) {
        int i = 0;
        while (i < this.tabbed.getTabCount()) {
            Component c = this.tabbed.getComponentAt(i);
            if ((Tag)this.componentTags.get(c) instanceof EditorTag) {
                this.tabbed.setEnabledAt(i, enabled);
            }
            ++i;
        }
    }

    public void add(Component component, String name) {
        this.add(component, name, new Tag(){});
    }

    public void setActive(Component component) {
        this.tabbed.setSelectedComponent(component);
    }

    public Component getActive() {
        return this.tabbed.getSelectedComponent();
    }

    public boolean isEnabled(Component component) {
        return this.tabbed.isEnabledAt(this.tabbed.indexOfComponent(component));
    }

    public void setEnabled(Component component, boolean enabled) {
        this.tabbed.setEnabledAt(this.tabbed.indexOfComponent(component), enabled);
        this.distributeChangeEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void distributeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = new HashSet(this.changeListeners).iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public void remove(Component component) {
        this.tabbed.remove(component);
        Tag tag = (Tag)this.componentTags.remove(component);
        if (tag instanceof CriticalTag) {
            --this.criticalObjects;
            if (this.criticalObjects == 0) {
                this.setEnabledEditorTagged(true);
            }
        }
        this.distributeChangeEvent();
    }

    public Tag getTag(Component component) {
        return (Tag)this.componentTags.get(component);
    }

    public Component[] getComponents() {
        Component[] comps = new Component[this.tabbed.getTabCount()];
        int i = 0;
        while (i < comps.length) {
            comps[i] = this.tabbed.getComponentAt(i);
            ++i;
        }
        return comps;
    }

    public Component[] getComponents(Satisfier satisfier) {
        ArrayList<Component> list = new ArrayList<Component>();
        int i = 0;
        while (i < this.tabbed.getTabCount()) {
            Component c = this.tabbed.getComponentAt(i);
            if (satisfier.satisfies(c, (Tag)this.componentTags.get(c))) {
                list.add(c);
            }
            ++i;
        }
        return list.toArray(new Component[0]);
    }

    public boolean isPresent(Satisfier satisfier) {
        int i = 0;
        while (i < this.tabbed.getTabCount()) {
            Component c = this.tabbed.getComponentAt(i);
            if (satisfier.satisfies(c, (Tag)this.componentTags.get(c))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void setNewMainObject(Serializable obj) {
        this.theMainObject = obj;
    }

    public void resizeSplit() {
        Component cur;
        if (this.myObjects != null && this.tabbed != null && this.myObjects.size() > 0 && this.tabbed.getTabCount() == 1 && (cur = this.getActive()) instanceof MultipleSimulateAction.MultiplePane) {
            MultipleSimulateAction.MultiplePane mult = (MultipleSimulateAction.MultiplePane)cur;
            mult.mySplit.setDividerLocation(0.5);
        }
    }
}

