/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.Codec;
import file.EncodeException;
import file.ParseException;
import gui.editor.EditBlockPane;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.FileChangeEvent;
import gui.environment.FileChangeListener;
import gui.environment.Universe;
import gui.grammar.GrammarInputPane;
import gui.menu.MenuBarCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class EnvironmentFrame
extends JFrame {
    private Environment environment;
    private int myNumber = -559038737;
    private static final String DEFAULT_TITLE = "JFLAP";

    public EnvironmentFrame(Environment environment) {
        this.environment = environment;
        environment.addFileChangeListener(new FileChangeListener(){

            public void fileChanged(FileChangeEvent e) {
                EnvironmentFrame.this.refreshTitle();
            }
        });
        this.initMenuBar();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)environment, "Center");
        this.myNumber = Universe.registerFrame(this);
        this.refreshTitle();
        this.addWindowListener(new Listener());
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(0);
        this.resizeWatcher();
    }

    public String getDescription() {
        if (this.environment.getFile() == null) {
            return "<untitled" + this.myNumber + ">";
        }
        if (this.environment.myObjects != null && this.environment.getActive() != null && (this.environment.getActive() instanceof EditorPane || this.environment.getActive() instanceof GrammarInputPane)) {
            return this.environment.getActive().getName();
        }
        return "(" + this.environment.getFile().getName() + ")";
    }

    protected void refreshTitle() {
        String title = "JFLAP : " + this.getDescription();
        this.setTitle(title);
    }

    protected void initMenuBar() {
        this.setJMenuBar(MenuBarCreator.getMenuBar(this));
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public boolean save(boolean saveAs) {
        String newname;
        String filename;
        File expected;
        JComponent ep;
        File file = saveAs ? null : this.environment.getFile();
        Codec codec = (Codec)this.environment.getEncoder();
        Serializable object = this.environment.getObject();
        if (this.environment.myObjects != null && this.environment.getActive() != null && this.environment.getActive() instanceof EditorPane) {
            ep = (EditorPane)this.environment.getActive();
            expected = new File(String.valueOf(((EditorPane)ep).getAutomaton().getFilePath()) + ((EditorPane)ep).getAutomaton().getFileName());
            file = saveAs ? null : expected;
            object = ((EditorPane)ep).getAutomaton();
        } else if (this.environment.myObjects != null && this.environment.getActive() != null && this.environment.getActive() instanceof GrammarInputPane) {
            ep = (GrammarInputPane)this.environment.getActive();
            expected = new File(String.valueOf(((GrammarInputPane)ep).getGrammar().getFilePath()) + ((GrammarInputPane)ep).getGrammar().getFileName());
            file = saveAs ? null : expected;
            object = ((GrammarInputPane)ep).getGrammar();
        }
        boolean blockEdit = false;
        if (this.environment.getActive() instanceof EditBlockPane) {
            EditBlockPane newPane = (EditBlockPane)this.environment.getActive();
            object = newPane.getAutomaton();
            blockEdit = true;
        }
        boolean badname = false;
        if (!(file == null || codec != null && codec.canEncode(object))) {
            JOptionPane.showMessageDialog(this, "We cannot write this structure in the same format\nit was read as!  Use Save As to select a new format.", "IO Error", 0);
            return false;
        }
        FileFilter[] filters = Universe.CHOOSER.getChoosableFileFilters();
        int i = 0;
        while (i < filters.length) {
            Universe.CHOOSER.removeChoosableFileFilter(filters[i]);
            ++i;
        }
        List encoders = Universe.CODEC_REGISTRY.getEncoders(object);
        Iterator it = encoders.iterator();
        while (it.hasNext()) {
            Universe.CHOOSER.addChoosableFileFilter((FileFilter)it.next());
        }
        if (codec != null && codec.canEncode(object)) {
            Universe.CHOOSER.setFileFilter(codec);
        } else {
            Universe.CHOOSER.setFileFilter((FileFilter)encoders.get(0));
        }
        if (saveAs) {
            Universe.CHOOSER.setDialogTitle("Save As");
        }
        if (file != null && codec != null && !(filename = file.getName()).equals(newname = codec.proposeFilename(filename, object))) {
            int result = JOptionPane.showConfirmDialog(this, "To save as a " + codec.getDescription() + ",\n" + "JFLAP wants to save " + filename + " to a new file\n" + "named " + newname + ".  Is that OK?");
            switch (result) {
                case 2: {
                    return false;
                }
                case 1: {
                    break;
                }
                case 0: {
                    file = new File(file.getParent(), newname);
                    badname = true;
                }
            }
        }
        while (badname || file == null) {
            if (!badname) {
                int result = Universe.CHOOSER.showSaveDialog(this);
                if (result != 0) {
                    return false;
                }
                file = Universe.CHOOSER.getSelectedFile();
                if (file != null) {
                    String filename2 = file.getName();
                    codec = (Codec)Universe.CHOOSER.getFileFilter();
                    file = new File(Universe.CHOOSER.getCurrentDirectory(), codec.proposeFilename(filename2, object));
                } else {
                    JOptionPane.showMessageDialog(null, "JFLAP could not determine the selected file name.  Try again.", "Error", 0);
                    file = null;
                    continue;
                }
            }
            badname = false;
            if (!file.exists()) continue;
            int result = JOptionPane.showConfirmDialog(this, "Overwrite " + file.getName() + "?");
            switch (result) {
                case 2: {
                    return false;
                }
                case 1: {
                    file = null;
                }
            }
        }
        Universe.CHOOSER.resetChoosableFileFilters();
        try {
            codec.encode(object, file, null);
            if (!blockEdit) {
                this.environment.setFile(file);
            }
            this.environment.setEncoder(codec);
            this.environment.clearDirty();
            return true;
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Write Error", 0);
            return false;
        }
        catch (EncodeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Write Error", 0);
            return false;
        }
    }

    public boolean close() {
        if (this.environment.isDirty()) {
            File file = this.environment.getFile();
            String title = file == null ? "untitled" : file.getName();
            int result = JOptionPane.showConfirmDialog(this, "Save " + title + " before closing?");
            if (result == 2) {
                return false;
            }
            if (result == 0) {
                this.save(false);
            }
        }
        this.dispose();
        Universe.unregisterFrame(this);
        return true;
    }

    public void resizeWatcher() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                EnvironmentFrame.this.environment.resizeSplit();
            }
        });
    }

    public String toString() {
        return this.getDescription();
    }

    private class Listener
    extends WindowAdapter {
        private Listener() {
        }

        public void windowClosing(WindowEvent event) {
            EnvironmentFrame.this.close();
        }
    }
}

