/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import automata.Automaton;
import gui.environment.Environment;
import gui.environment.EnvironmentFactory;
import gui.environment.EnvironmentFrame;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.RegPumpingLemmaChooser;
import java.awt.Dimension;
import java.io.Serializable;
import pumping.ContextFreePumpingLemma;
import pumping.RegularPumpingLemma;

public class FrameFactory {
    public static EnvironmentFrame createFrame(Serializable object) {
        Environment environment = EnvironmentFactory.getEnvironment(object);
        if (environment == null) {
            return null;
        }
        EnvironmentFrame frame = new EnvironmentFrame(environment);
        if (object instanceof Automaton) {
            ((Automaton)object).setEnvironmentFrame(frame);
        }
        frame.pack();
        int width = 600;
        int height = 400;
        if (object instanceof RegPumpingLemmaChooser || object instanceof RegularPumpingLemma) {
            width = 700;
            height = 700;
        }
        if (object instanceof CFPumpingLemmaChooser || object instanceof ContextFreePumpingLemma) {
            width = 800;
            height = 780;
        }
        width = Math.max(width, frame.getSize().width);
        height = Math.max(height, frame.getSize().height);
        frame.setSize(new Dimension(width, height));
        frame.setVisible(true);
        return frame;
    }

    public static EnvironmentFrame createFrame(Serializable object, boolean multiple) {
        EnvironmentFrame frame = FrameFactory.createFrame(object);
        return frame;
    }
}

