/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.CodecRegistry;
import file.JFLAP3Codec;
import file.XMLCodec;
import gui.action.NewAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FileChangeEvent;
import gui.environment.FileChangeListener;
import gui.environment.Profile;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;

public class Universe {
    private static Map environmentToFrame = new HashMap();
    private static Map fileToFrame = new HashMap();
    public static JFileChooser CHOOSER = null;
    private static int numberRegistered = 0;
    private static FileChangeListener FILE_LISTENER = new FileChangeListener(){

        public void fileChanged(FileChangeEvent e) {
            Environment env;
            File newFile;
            File oldFile = e.getOldFile();
            EnvironmentFrame frame = Universe.frameForEnvironment((Environment)e.getSource());
            if (oldFile != null) {
                fileToFrame.remove(Universe.getPath(oldFile));
            }
            if ((newFile = (env = (Environment)e.getSource()).getFile()) == null) {
                return;
            }
            fileToFrame.put(Universe.getPath(newFile), frame);
        }
    };
    public static final CodecRegistry CODEC_REGISTRY = new CodecRegistry();
    public static Profile curProfile;

    static {
        try {
            CHOOSER = new JFileChooser();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        XMLCodec xc = new XMLCodec();
        CODEC_REGISTRY.add(xc);
        CODEC_REGISTRY.add(new JFLAP3Codec());
        curProfile = new Profile();
    }

    private Universe() {
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static int registerFrame(EnvironmentFrame frame) {
        Environment env = frame.getEnvironment();
        environmentToFrame.put(env, frame);
        File file = env.getFile();
        if (file != null) {
            fileToFrame.put(Universe.getPath(file), frame);
        }
        env.addFileChangeListener(FILE_LISTENER);
        NewAction.hideNew();
        return ++numberRegistered;
    }

    public static void unregisterFrame(EnvironmentFrame frame) {
        try {
            fileToFrame.remove(Universe.getPath(frame.getEnvironment().getFile()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        environmentToFrame.remove(frame.getEnvironment());
        if (Universe.numberOfFrames() == 0) {
            NewAction.showNew();
        }
    }

    public static EnvironmentFrame frameForFile(File file) {
        if (file == null) {
            return null;
        }
        return (EnvironmentFrame)fileToFrame.get(Universe.getPath(file));
    }

    public static EnvironmentFrame frameForEnvironment(Environment environment) {
        return (EnvironmentFrame)environmentToFrame.get(environment);
    }

    public static EnvironmentFrame[] frames() {
        return environmentToFrame.values().toArray(new EnvironmentFrame[0]);
    }

    public static int numberOfFrames() {
        return environmentToFrame.size();
    }
}

