/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.convert;

import automata.Automaton;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import grammar.Grammar;
import grammar.Production;
import gui.environment.FrameFactory;
import gui.event.SelectionEvent;
import gui.event.SelectionListener;
import gui.grammar.convert.GrammarViewer;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

class ConvertController {
    protected GrammarViewer grammarView;
    protected SelectionDrawer drawer;
    protected Grammar grammar;
    protected Automaton automaton;
    protected Map pToT;
    protected Map tToP;
    protected Set alreadyDone = new HashSet();
    protected Component parent;

    public ConvertController(GrammarViewer grammarView, SelectionDrawer drawer, Map productionsToTransitions, Component parent) {
        this.grammarView = grammarView;
        this.drawer = drawer;
        this.parent = parent;
        this.grammar = grammarView.getGrammar();
        this.automaton = drawer.getAutomaton();
        this.initListeners();
        this.pToT = productionsToTransitions;
        this.tToP = this.invert(this.pToT);
    }

    private Map invert(Map map) {
        Set entries = map.entrySet();
        Iterator it = entries.iterator();
        Map inverse = null;
        try {
            inverse = (Map)map.getClass().newInstance();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                inverse.put(entry.getValue(), entry.getKey());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return inverse;
    }

    private void initListeners() {
        this.automaton.addTransitionListener(new AutomataTransitionListener(){

            public void automataTransitionChange(AutomataTransitionEvent e) {
                if (!e.isAdd()) {
                    return;
                }
                Transition transition = e.getTransition();
                if (!ConvertController.this.tToP.containsKey(transition) || ConvertController.this.alreadyDone.contains(ConvertController.this.tToP.get(transition))) {
                    JOptionPane.showMessageDialog(ConvertController.this.parent, "That transition is not correct!");
                    ConvertController.this.automaton.removeTransition(transition);
                } else {
                    Production p = (Production)ConvertController.this.tToP.get(transition);
                    ConvertController.this.alreadyDone.add(p);
                    ConvertController.this.grammarView.setChecked(p, true);
                }
            }
        });
        this.grammarView.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Production[] p = ConvertController.this.grammarView.getSelected();
                ConvertController.this.drawer.clearSelected();
                int i = 0;
                while (i < p.length) {
                    ConvertController.this.drawer.addSelected((Transition)ConvertController.this.pToT.get(p[i]));
                    ++i;
                }
                ConvertController.this.parent.repaint();
            }
        });
    }

    public void complete() {
        HashSet productions = new HashSet(this.pToT.keySet());
        Iterator it = productions.iterator();
        while (it.hasNext()) {
            Production p = (Production)it.next();
            if (this.alreadyDone.contains(p)) continue;
            Transition t = (Transition)this.pToT.get(p);
            this.automaton.addTransition(t);
        }
    }

    public void createForSelected() {
        Production[] p = this.grammarView.getSelected();
        int i = 0;
        while (i < p.length) {
            if (!this.alreadyDone.contains(p[i])) {
                Transition t = (Transition)this.pToT.get(p[i]);
                this.automaton.addTransition(t);
            }
            ++i;
        }
    }

    public boolean isDone() {
        int toDo = this.pToT.size() - this.alreadyDone.size();
        String message = toDo == 0 ? "The conversion is finished!" : String.valueOf(toDo) + " more transition" + (toDo == 1 ? "" : "s") + " must be added.";
        JOptionPane.showMessageDialog(this.parent, message);
        return toDo == 0;
    }

    public void export() {
        boolean done;
        boolean bl = done = this.pToT.size() - this.alreadyDone.size() == 0;
        if (!done) {
            JOptionPane.showMessageDialog(this.parent, "The conversion is not completed yet!");
            return;
        }
        Automaton toExport = (Automaton)this.automaton.clone();
        FrameFactory.createFrame(toExport);
    }
}

