/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.convert;

import automata.Automaton;
import grammar.Grammar;
import gui.SplitPaneFactory;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.Environment;
import gui.grammar.convert.ConvertController;
import gui.grammar.convert.GrammarViewer;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ConvertPane
extends JPanel {
    private Grammar grammar;
    private GrammarViewer grammarViewer;
    private SelectionDrawer automatonDrawer;
    private Automaton automaton;
    private EditorPane editorPane;

    public ConvertPane(Grammar grammar, Automaton automaton, Map productionsToTransitions, Environment env) {
        this.grammar = grammar;
        this.automaton = automaton;
        this.setLayout(new BorderLayout());
        JSplitPane split = SplitPaneFactory.createSplit(env, true, 0.4, null, null);
        this.add((Component)split, "Center");
        this.grammarViewer = new GrammarViewer(grammar);
        JScrollPane scroller = new JScrollPane(this.grammarViewer);
        split.setLeftComponent(scroller);
        this.automatonDrawer = new SelectionDrawer(automaton);
        EditorPane ep = new EditorPane(this.automatonDrawer, new ToolBox(){

            public List tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowNontransitionTool(view, drawer));
                tools.add(new TransitionTool(view, drawer));
                return tools;
            }
        });
        ConvertController controller = new ConvertController(this.grammarViewer, this.automatonDrawer, productionsToTransitions, this);
        this.controlPanel(ep.getToolBar(), controller);
        split.setRightComponent(ep);
        this.editorPane = ep;
    }

    private void controlPanel(JToolBar bar, final ConvertController controller) {
        bar.addSeparator();
        bar.add(new AbstractAction("Show All"){

            public void actionPerformed(ActionEvent e) {
                controller.complete();
            }
        });
        bar.add(new AbstractAction("Create Selected"){

            public void actionPerformed(ActionEvent e) {
                controller.createForSelected();
            }
        });
        bar.add(new AbstractAction("Done?"){

            public void actionPerformed(ActionEvent e) {
                controller.isDone();
            }
        });
        bar.add(new AbstractAction("Export"){

            public void actionPerformed(ActionEvent e) {
                controller.export();
            }
        });
    }

    public EditorPane getEditorPane() {
        return this.editorPane;
    }
}

