/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.convert;

import grammar.Grammar;
import grammar.Production;
import gui.event.SelectionEvent;
import gui.event.SelectionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class GrammarViewer
extends JTable {
    private Grammar grammar;
    private ButtonGroup bgroup = new ButtonGroup();
    private Object[][] data;
    private Map productionToRow = new HashMap();
    private SelectionEvent EVENT = new SelectionEvent(this);
    private Set selectionListeners = new HashSet();
    private ListSelectionListener listSelectListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            GrammarViewer.this.distributeSelectionEvent();
        }
    };

    public GrammarViewer(Grammar grammar) {
        this.setModel(new GrammarTableModel());
        this.grammar = grammar;
        Production[] prods = grammar.getProductions();
        this.data = new Object[prods.length][2];
        Object[] columnNames = new Object[]{"Production", "Created"};
        int i = 0;
        while (i < prods.length) {
            this.data[i][0] = prods[i];
            this.data[i][1] = Boolean.FALSE;
            this.productionToRow.put(prods[i], new Integer(i));
            ++i;
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.setDataVector(this.data, columnNames);
        this.getSelectionModel().addListSelectionListener(this.listSelectListener);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void distributeSelectionEvent() {
        Iterator it = this.selectionListeners.iterator();
        while (it.hasNext()) {
            SelectionListener listener = (SelectionListener)it.next();
            listener.selectionChanged(this.EVENT);
        }
    }

    public Production[] getSelected() {
        int[] rows = this.getSelectedRows();
        Production[] selected = new Production[rows.length];
        int i = 0;
        while (i < rows.length) {
            selected[i] = (Production)this.data[rows[i]][0];
            ++i;
        }
        return selected;
    }

    public void setChecked(Production production, boolean checked) {
        Integer r = (Integer)this.productionToRow.get(production);
        if (r == null) {
            return;
        }
        int row = r;
        Boolean b = checked ? Boolean.TRUE : Boolean.FALSE;
        this.data[row][1] = b;
        ((DefaultTableModel)this.getModel()).setValueAt(b, row, 1);
    }

    private class GrammarTableModel
    extends DefaultTableModel {
        static /* synthetic */ Class class$0;

        private GrammarTableModel() {
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            return super.getColumnClass(columnIndex);
        }
    }
}

