/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.BruteParser;
import grammar.parse.BruteParserEvent;
import grammar.parse.BruteParserListener;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.ParsePane;
import gui.grammar.parse.UnrestrictedTreePanel;
import gui.sim.multiple.InputTableModel;
import gui.tree.SelectNodeDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.tree.TreeNode;

public class BruteParsePane
extends ParsePane {
    public int row = -1;
    public UnrestrictedTreePanel treePanel = new UnrestrictedTreePanel(this);
    SelectNodeDrawer nodeDrawer = new SelectNodeDrawer();
    JLabel progress = new JLabel(" ");
    public BruteParser parser = null;
    InputTableModel myModel = null;
    public Action pauseResumeAction = new AbstractAction("Pause"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            BruteParser bruteParser = BruteParsePane.this.parser;
            synchronized (bruteParser) {
                if (BruteParsePane.this.parser == null) {
                    return;
                }
                if (BruteParsePane.this.parser.isActive()) {
                    BruteParsePane.this.parser.pause();
                } else {
                    BruteParsePane.this.parser.start();
                }
            }
        }
    };

    public BruteParsePane(GrammarEnvironment environment, Grammar grammar, InputTableModel model) {
        super(environment, grammar);
        this.initView();
        this.myModel = model;
    }

    protected JTable initParseTable() {
        return null;
    }

    protected JPanel initInputPanel() {
        JPanel bigger = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Input"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        panel.add((Component)this.inputField, c);
        this.inputField.addActionListener(this.startAction);
        panel.add((Component)this.progress, c);
        bigger.add((Component)panel, "Center");
        bigger.add((Component)this.initInputToolbar(), "North");
        return bigger;
    }

    protected JToolBar initInputToolbar() {
        JToolBar tb = super.initInputToolbar();
        tb.add((Component)new JButton(this.pauseResumeAction), 1);
        this.pauseResumeAction.setEnabled(false);
        return tb;
    }

    public void parseMultiple() {
        String[][] inputs = this.myModel.getInputs();
        int size = 1;
        if (this.environment.myObjects != null) {
            size = this.environment.myObjects.size();
        }
        int uniqueInputs = inputs.length / size;
        Grammar currentGram = this.grammar;
        if (this.environment.myObjects != null) {
            currentGram = (Grammar)this.environment.myObjects.get(0);
        }
        if (this.row < inputs.length - 1) {
            ++this.row;
            if (this.row % uniqueInputs == 0 && this.environment.myObjects != null) {
                this.grammar = currentGram = (Grammar)this.environment.myObjects.get(this.row / uniqueInputs);
            }
            this.parser = BruteParser.get(this.grammar, inputs[this.row][0]);
            this.parseInput(inputs[this.row][0], this.parser);
        }
    }

    public void parseInput(String string, BruteParser newParser) {
        if (string.equals("")) {
            return;
        }
        if (newParser == null) {
            try {
                this.parser = BruteParser.get(this.grammar, string);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Bad Input", 0);
                return;
            }
        } else {
            this.parser = newParser;
        }
        final Timer timer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BruteParsePane.this.parser == null) {
                    return;
                }
                String nodeCount = "Nodes generated: " + BruteParsePane.this.parser.getTotalNodeCount() + "(" + BruteParsePane.this.parser.getConsiderationNodeCount() + ")";
                BruteParsePane.this.progress.setText("Parser running.  " + nodeCount);
            }
        });
        this.parser.addBruteParserListener(new BruteParserListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bruteParserStateChange(BruteParserEvent e) {
                BruteParser bruteParser = e.getParser();
                synchronized (bruteParser) {
                    String nodeCount = String.valueOf(e.getParser().getTotalNodeCount()) + " nodes generated.";
                    String status = null;
                    switch (e.getType()) {
                        case 0: {
                            BruteParsePane.this.pauseResumeAction.setEnabled(true);
                            BruteParsePane.this.pauseResumeAction.putValue("Name", "Pause");
                            timer.start();
                            status = "Parser started.";
                            BruteParsePane.this.statusDisplay.setText(status);
                            break;
                        }
                        case 3: {
                            BruteParsePane.this.pauseResumeAction.setEnabled(false);
                            timer.stop();
                            status = "String rejected.";
                            if (BruteParsePane.this.myModel == null) break;
                            String[][] inputs = BruteParsePane.this.myModel.getInputs();
                            int size = 1;
                            if (BruteParsePane.this.environment.myObjects != null) {
                                size = BruteParsePane.this.environment.myObjects.size();
                            }
                            int uniqueInputs = inputs.length / size;
                            BruteParsePane.this.myModel.setResult(BruteParsePane.this.row, "Reject", null, BruteParsePane.this.environment.myTransducerStrings, BruteParsePane.this.row % uniqueInputs * 2);
                            BruteParsePane.this.parseMultiple();
                            break;
                        }
                        case 1: {
                            timer.stop();
                            BruteParsePane.this.pauseResumeAction.putValue("Name", "Resume");
                            BruteParsePane.this.pauseResumeAction.setEnabled(true);
                            status = "Parser paused.";
                            BruteParsePane.this.statusDisplay.setText(status);
                            break;
                        }
                        case 2: {
                            BruteParsePane.this.pauseResumeAction.setEnabled(false);
                            BruteParsePane.this.stepAction.setEnabled(true);
                            timer.stop();
                            status = "String accepted!";
                            if (BruteParsePane.this.myModel == null) break;
                            BruteParsePane.this.myModel.setResult(BruteParsePane.this.row, "Accept", null, BruteParsePane.this.environment.myTransducerStrings, BruteParsePane.this.row);
                            BruteParsePane.this.parseMultiple();
                        }
                    }
                    BruteParsePane.this.progress.setText(String.valueOf(status) + "  " + nodeCount);
                    if (BruteParsePane.this.parser.isFinished()) {
                        if (!e.isAccept()) {
                            BruteParsePane.this.treePanel.setAnswer(null);
                            BruteParsePane.this.treePanel.repaint();
                            BruteParsePane.this.stepAction.setEnabled(false);
                            BruteParsePane.this.statusDisplay.setText("Try another string.");
                            return;
                        }
                        TreeNode node = e.getParser().getAnswer();
                        while ((node = node.getParent()) != null) {
                        }
                        BruteParsePane.this.statusDisplay.setText("Press step to show derivations.");
                        BruteParsePane.this.treePanel.setAnswer(e.getParser().getAnswer());
                        BruteParsePane.this.treePanel.repaint();
                    }
                }
            }
        });
        this.parser.start();
    }

    public void input(String string) {
        if (this.parser != null) {
            this.parser.pause();
        }
        this.parseInput(string, null);
    }

    protected String[] getViewChoices() {
        return new String[]{"Noninverted Tree", "Derivation Table"};
    }

    public boolean step() {
        boolean worked = false;
        if (this.treePanel.next()) {
            this.stepAction.setEnabled(false);
            worked = true;
        }
        this.treePanel.repaint();
        return worked;
    }

    protected JComponent initTreePanel() {
        return this.treePanel;
    }
}

