/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.environment.Universe;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class FirstFollowModel
extends AbstractTableModel {
    private String[] variables;
    private String[] terminals;
    private String[] firstSets;
    private String[] followSets;
    private boolean[] canEditColumn = new boolean[3];
    public static String LAMBDA = Universe.curProfile.getEmptyString();
    public static String[] COLUMN_NAMES = new String[]{" ", "FIRST", "FOLLOW"};

    public FirstFollowModel(Grammar grammar) {
        this.variables = grammar.getVariables();
        Arrays.sort(this.variables);
        this.terminals = grammar.getTerminals();
        this.firstSets = new String[this.variables.length];
        this.followSets = new String[this.variables.length];
        Arrays.fill(this.firstSets, "");
        Arrays.fill(this.followSets, "");
    }

    public Map getFirst() {
        return null;
    }

    public Map getFollow() {
        return null;
    }

    public void setCanEditFirst(boolean canEdit) {
        this.canEditColumn[1] = canEdit;
    }

    public void setCanEditFollow(boolean canEdit) {
        this.canEditColumn[2] = canEdit;
    }

    public int getRowCount() {
        return this.variables.length;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.variables[row];
            }
            case 1: {
                return this.firstSets[row];
            }
            case 2: {
                return this.followSets[row];
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return this.canEditColumn[column];
    }

    public Set getSet(int row, int column) {
        String s = (String)this.getValueAt(row, column);
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '!') {
                set.add("");
            } else {
                set.add(s.substring(i, i + 1));
            }
            ++i;
        }
        return set;
    }

    private String removeDuplicateCharacters(String s) {
        HashSet<Character> characters = new HashSet<Character>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            Character c = new Character(s.charAt(i));
            if (characters.add(c)) {
                sb.append(c.charValue());
            }
            ++i;
        }
        return sb.toString();
    }

    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                this.variables[row] = (String)value;
                break;
            }
            case 1: {
                this.firstSets[row] = this.removeDuplicateCharacters((String)value);
                break;
            }
            case 2: {
                this.followSets[row] = this.removeDuplicateCharacters((String)value);
            }
        }
    }

    public void setSet(Set set, int row, int column) {
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            if (element.length() == 0) {
                element = "!";
            }
            sb.append(element);
        }
        this.setValueAt(sb.toString(), row, column);
    }
}

