/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.HighlightTable;
import gui.LeftTable;
import gui.environment.Universe;
import gui.grammar.parse.FirstFollowModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FirstFollowTable
extends LeftTable {
    private FirstFollowModel model = (FirstFollowModel)this.getModel();
    private static final HighlightTable.TableHighlighterRendererGenerator THRG = new HighlightTable.TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        public TableCellRenderer getRenderer(int row, int column) {
            if (this.renderer == null) {
                this.renderer = new SetsCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private static final TableCellRenderer RENDERER = new SetsCellRenderer();

    public FirstFollowTable(Grammar grammar) {
        super(new FirstFollowModel(grammar));
        this.getColumnModel().getColumn(1).setCellRenderer(RENDERER);
        this.getColumnModel().getColumn(2).setCellRenderer(RENDERER);
        this.setCellSelectionEnabled(true);
    }

    public FirstFollowModel getFFModel() {
        return this.model;
    }

    private static String getSetString(String s) {
        if (s == null) {
            return "{ }";
        }
        StringBuffer sb = new StringBuffer("{ ");
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '!') {
                c = Universe.curProfile.getEmptyString().charAt(0);
            }
            sb.append(c);
            if (i != s.length() - 1) {
                sb.append(',');
            }
            sb.append(' ');
            ++i;
        }
        sb.append('}');
        return sb.toString();
    }

    public void highlight(int row, int column) {
        this.highlight(row, column, THRG);
    }

    private static class SetsCellRenderer
    extends DefaultTableCellRenderer {
        private SetsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (hasFocus && table.isCellEditable(row, column)) {
                return l;
            }
            l.setText(FirstFollowTable.getSetString((String)value));
            return l;
        }
    }
}

