/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.LLParseTable;
import grammar.parse.LLParseTableGenerator;
import grammar.parse.Operations;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.FirstFollowModel;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.LLParsePane;
import gui.grammar.parse.LLParseTablePane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LLParseDerivationController {
    GrammarEnvironment environment;
    FirstFollowTable firstFollow;
    private LLParseTablePane parseTable;
    JLabel directions;
    int step = -1;
    static final int FIRST_SETS = 0;
    static final int FOLLOW_SETS = 1;
    static final int PARSE_TABLE = 2;
    static final int FINISHED = 3;
    Map targetFirstSets;
    Map targetFollowSets;
    Grammar grammar;
    private LLParseTable targetParseTable;
    AbstractAction doSelectedAction = new AbstractAction("Do Selected"){

        public void actionPerformed(ActionEvent e) {
            LLParseDerivationController.this.completeSelected();
        }
    };
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        public void actionPerformed(ActionEvent e) {
            LLParseDerivationController.this.completeStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        public void actionPerformed(ActionEvent e) {
            LLParseDerivationController.this.completeAll();
        }
    };
    AbstractAction nextAction = new AbstractAction("Next"){

        public void actionPerformed(ActionEvent e) {
            LLParseDerivationController.this.nextStep();
        }
    };
    AbstractAction parseAction = new AbstractAction("Parse"){

        public void actionPerformed(ActionEvent e) {
            LLParseDerivationController.this.parse();
        }
    };

    public LLParseDerivationController(Grammar grammar, GrammarEnvironment environment, FirstFollowTable firstFollow, LLParseTablePane parseTable, JLabel directions) {
        this.environment = environment;
        this.firstFollow = firstFollow;
        this.parseTable = parseTable;
        this.directions = directions;
        this.grammar = grammar;
        this.targetFirstSets = Operations.first(grammar);
        this.targetFollowSets = Operations.follow(grammar);
        this.targetParseTable = LLParseTableGenerator.generate(grammar);
        this.nextStep();
    }

    boolean done() {
        switch (this.step) {
            case -1: {
                return true;
            }
            case 0: 
            case 1: {
                Map sets = this.step == 0 ? this.targetFirstSets : this.targetFollowSets;
                int col = this.step == 0 ? 1 : 2;
                FirstFollowModel ffm = this.firstFollow.getFFModel();
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                int highlighted = 0;
                int i22 = 0;
                while (i22 < ffm.getRowCount()) {
                    String var = (String)ffm.getValueAt(i22, 0);
                    if (!ffm.getSet(i22, col).equals(sets.get(var))) {
                        this.firstFollow.highlight(i22, col);
                        ++highlighted;
                    }
                    ++i22;
                }
                if (highlighted == 0) {
                    return true;
                }
                this.firstFollow.clearSelection();
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException i22) {
                    // empty catch block
                }
                JOptionPane.showMessageDialog(this.parseTable, "Highlighted sets are incorrect.", "Bad Sets", 0);
                this.firstFollow.dehighlight();
                return false;
            }
            case 2: {
                LLParseTable pt = this.parseTable.getParseTable();
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException var) {
                    // empty catch block
                }
                String[][] diff = pt.getDifferences(this.targetParseTable);
                if (diff.length == 0) {
                    return true;
                }
                int i = 0;
                while (i < diff.length) {
                    int row = pt.getRow(diff[i][0]);
                    int column = pt.getColumn(diff[i][1]);
                    this.parseTable.highlight(row, column);
                    ++i;
                }
                this.parseTable.clearSelection();
                JOptionPane.showMessageDialog(this.firstFollow, "Highlighted cells are incorrect.", "Bad Parse Table", 0);
                this.parseTable.dehighlight();
                return false;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
        return false;
    }

    public void completeStep() {
        switch (this.step) {
            case 0: 
            case 1: {
                Map sets = this.step == 0 ? this.targetFirstSets : this.targetFollowSets;
                int col = this.step == 0 ? 1 : 2;
                FirstFollowModel ffm = this.firstFollow.getFFModel();
                int i22 = 0;
                while (i22 < ffm.getRowCount()) {
                    String var = (String)ffm.getValueAt(i22, 0);
                    ffm.setSet((Set)sets.get(var), i22, col);
                    ++i22;
                }
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException i22) {
                    // empty catch block
                }
                this.firstFollow.repaint();
                this.nextStep();
                break;
            }
            case 2: {
                LLParseTable pt = this.parseTable.getParseTable();
                int r = 0;
                while (r < pt.getRowCount()) {
                    String var = (String)pt.getValueAt(r, 0);
                    int c = 1;
                    while (c < pt.getColumnCount()) {
                        int cv = this.parseTable.convertColumnIndexToView(c);
                        pt.setValueAt(this.targetParseTable.getValueAt(r, c), r, c);
                        ++c;
                    }
                    ++r;
                }
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.parseTable.repaint();
                this.nextStep();
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
    }

    public void completeSelected() {
        switch (this.step) {
            case 0: 
            case 1: {
                Map sets = this.step == 0 ? this.targetFirstSets : this.targetFollowSets;
                int col = this.step == 0 ? 1 : 2;
                FirstFollowModel ffm = this.firstFollow.getFFModel();
                int viewCol = this.firstFollow.convertColumnIndexToView(col);
                int i22 = 0;
                while (i22 < ffm.getColumnCount()) {
                    if (this.firstFollow.isCellSelected(i22, viewCol)) {
                        String var = (String)ffm.getValueAt(i22, 0);
                        ffm.setSet((Set)sets.get(var), i22, col);
                    }
                    ++i22;
                }
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException i22) {
                    // empty catch block
                }
                this.firstFollow.repaint();
                break;
            }
            case 2: {
                LLParseTable pt = this.parseTable.getParseTable();
                int r = 0;
                while (r < pt.getRowCount()) {
                    String var = (String)pt.getValueAt(r, 0);
                    int c = 1;
                    while (c < pt.getColumnCount()) {
                        int cv = this.parseTable.convertColumnIndexToView(c);
                        if (this.parseTable.isCellSelected(r, cv)) {
                            pt.setValueAt(this.targetParseTable.getValueAt(r, c), r, c);
                        }
                        ++c;
                    }
                    ++r;
                }
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.parseTable.repaint();
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
    }

    public void completeAll() {
        do {
            this.completeStep();
        } while (this.step != 3);
    }

    public void parse() {
        LLParsePane panel = new LLParsePane(this.environment, this.grammar, this.targetParseTable);
        this.environment.add((Component)panel, "LL(1) Parsing");
        this.environment.setActive(panel);
    }

    public boolean isLL1() {
        return Operations.isLL1(this.grammar);
    }

    public boolean nextStep() {
        if (!this.done()) {
            return false;
        }
        ++this.step;
        switch (this.step) {
            case 0: {
                this.parseAction.setEnabled(false);
                this.firstFollow.getFFModel().setCanEditFirst(true);
                this.firstFollow.getFFModel().setCanEditFollow(false);
                this.directions.setText("Define FIRST sets.  ! is the lambda character.");
                break;
            }
            case 1: {
                this.firstFollow.getFFModel().setCanEditFirst(false);
                this.firstFollow.getFFModel().setCanEditFollow(true);
                this.directions.setText("Define FOLLOW sets.  $ is the end of string character.");
                break;
            }
            case 2: {
                this.firstFollow.getFFModel().setCanEditFollow(false);
                this.directions.setText("Fill entries in parse table.  Use ! for a lambda entry.");
                break;
            }
            case 3: {
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.doSelectedAction.setEnabled(false);
                this.doStepAction.setEnabled(false);
                this.doAllAction.setEnabled(false);
                this.nextAction.setEnabled(false);
                if (this.isLL1()) {
                    this.parseAction.setEnabled(true);
                    this.directions.setText("Parse table complete.  Press \"parse\" to use it.");
                    break;
                }
                this.directions.setText("Parse table complete, but has ambiguity.");
            }
        }
        return true;
    }
}

