/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.graph.AutomatonGraph;
import automata.graph.GEMLayoutAlgorithm;
import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import grammar.parse.LRParseTableGenerator;
import grammar.parse.Operations;
import gui.editor.EditorPane;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.ItemSetChooser;
import gui.grammar.parse.LLParseDerivationController;
import gui.grammar.parse.LRParsePane;
import gui.grammar.parse.LRParseTableChooserPane;
import gui.grammar.parse.LRParseTableDerivationPane;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LRParseDerivationController
extends LLParseDerivationController {
    static final int BUILD_DFA = 2;
    static final int PARSE_TABLE = 3;
    static final int FINISHED = 4;
    private FiniteStateAutomaton dfa;
    private ItemSetChooser itemChooser;
    private Grammar augmented;
    private LRParseTableDerivationPane derivation;
    private Map stateToItems = new HashMap();
    private Map itemsToState = new HashMap();
    private LRParseTable targetParseTable;
    private LRParseTable userParseTable;
    private boolean doAll = false;
    private static final String GOTO_SYMBOL = "\u00b7";
    EditorPane editor = null;

    public LRParseDerivationController(Grammar grammar, Grammar augmented, GrammarEnvironment environment, FirstFollowTable firstFollow, JLabel directions, FiniteStateAutomaton dfa, LRParseTableDerivationPane derivation) {
        super(grammar, environment, firstFollow, null, directions);
        this.augmented = augmented;
        this.dfa = dfa;
        this.derivation = derivation;
        this.itemChooser = new ItemSetChooser(augmented, firstFollow);
    }

    private Set initialGotoSet() {
        Set<Production> initSet = new HashSet<Production>();
        Production[] ps = this.augmented.getProductions();
        Production p = ps[0];
        p = new Production(p.getLHS(), GOTO_SYMBOL + p.getRHS());
        initSet.add(p);
        initSet = Operations.closure(this.augmented, initSet);
        return initSet;
    }

    private Set variablesWithEndFollow() {
        Map closure = Operations.follow(this.grammar);
        HashSet<Object> variables = new HashSet<Object>();
        Iterator it = closure.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((Set)entry.getValue()).contains("$")) continue;
            variables.add(entry.getKey());
        }
        variables.add(String.valueOf(this.grammar.getStartVariable()) + "'");
        return variables;
    }

    private boolean isFinalSet(Set set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Production p = (Production)it.next();
            if (!p.getRHS().endsWith(GOTO_SYMBOL)) continue;
            return true;
        }
        return false;
    }

    boolean done() {
        switch (this.step) {
            case -1: 
            case 0: 
            case 1: {
                return super.done();
            }
            case 2: {
                State state;
                Set items;
                Map.Entry entry;
                Iterator it = this.itemsToState.entrySet().iterator();
                SelectionDrawer drawer = (SelectionDrawer)this.editor.getDrawer();
                int selected = 0;
                while (it.hasNext()) {
                    entry = it.next();
                    items = (Set)entry.getKey();
                    state = (State)entry.getValue();
                    Transition[] t = this.dfa.getTransitionsFromState(state);
                    String[] s = Operations.getCanGoto(items);
                    if (s.length == t.length) continue;
                    drawer.addSelected(state);
                    ++selected;
                }
                if (selected != 0) {
                    this.editor.repaint();
                    JOptionPane.showMessageDialog(this.firstFollow, "The indicated states need more transitions.", "Set Not Fully Expanded", 0);
                    drawer.clearSelected();
                    this.editor.repaint();
                    return false;
                }
                it = this.itemsToState.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    items = (Set)entry.getKey();
                    state = (State)entry.getValue();
                    boolean finalState = this.isFinalSet(items);
                    if (!(finalState ^ this.dfa.isFinalState(state))) continue;
                    drawer.addSelected(state);
                    ++selected;
                }
                if (selected != 0) {
                    this.editor.repaint();
                    JOptionPane.showMessageDialog(this.firstFollow, "The indicated states are either final and\nshouldn't be, or are nonfinal and should be.", "States in Wrong Finality", 0);
                    drawer.clearSelected();
                    this.editor.repaint();
                    return false;
                }
                return true;
            }
            case 3: {
                int rows = this.targetParseTable.getRowCount();
                int columns = this.targetParseTable.getColumnCount();
                LRParseTableChooserPane tableView = this.derivation.getParseTableView();
                try {
                    tableView.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException finalState) {
                    // empty catch block
                }
                tableView.clearSelection();
                int highlighted = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < columns) {
                        if (!this.targetParseTable.getValueAt(i, j).equals(this.userParseTable.getValueAt(i, j))) {
                            ++highlighted;
                            tableView.highlight(i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (highlighted == 0) {
                    return true;
                }
                JOptionPane.showMessageDialog(this.firstFollow, "Highlighted cells are incorrect.", "Bad Parse Table", 0);
                tableView.dehighlight();
                return false;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
        return false;
    }

    public void completeStep() {
        switch (this.step) {
            case 0: 
            case 1: {
                super.completeStep();
                break;
            }
            case 2: {
                this.completeDFA();
                this.nextStep();
                break;
            }
            case 3: {
                int rows = this.targetParseTable.getRowCount();
                int columns = this.targetParseTable.getColumnCount();
                LRParseTableChooserPane tableView = this.derivation.getParseTableView();
                tableView.clearSelection();
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < columns) {
                        this.userParseTable.setValueAt(this.targetParseTable.getValueAt(i, j), i, j);
                        ++j;
                    }
                    ++i;
                }
                this.nextStep();
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
                break;
            }
            default: {
                System.err.println("Complete step screwed up!  Step is " + this.step);
            }
        }
    }

    public void completeSelected() {
        switch (this.step) {
            case 0: 
            case 1: {
                super.completeSelected();
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this.firstFollow, "That request is invalid for this particular step.", "Nothing Selectable", 0);
                break;
            }
            case 3: {
                int rows = this.targetParseTable.getRowCount();
                int columns = this.targetParseTable.getColumnCount();
                LRParseTableChooserPane tableView = this.derivation.getParseTableView();
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < columns) {
                        int cv = tableView.convertColumnIndexToView(j);
                        if (tableView.isCellSelected(i, cv)) {
                            this.userParseTable.setValueAt(this.targetParseTable.getValueAt(i, j), i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                tableView.repaint();
            }
        }
    }

    private void completeDFA() {
        if (this.step != 2) {
            System.err.println("COMPLETE DFA CALLED AT WRONG TIME");
            return;
        }
        StatePlacer placer = new StatePlacer();
        HashSet<State> handledStates = new HashSet<State>();
        State[] states = this.dfa.getStates();
        HashSet<State> originalStates = new HashSet<State>(Arrays.asList(states));
        while (states.length != handledStates.size()) {
            int i = 0;
            while (i < states.length) {
                if (!handledStates.contains(states[i])) {
                    Set itemSet = (Set)this.stateToItems.get(states[i]);
                    if (this.isFinalSet(itemSet)) {
                        this.dfa.addFinalState(states[i]);
                    } else {
                        this.dfa.removeFinalState(states[i]);
                    }
                    Transition[] t = this.dfa.getTransitionsFromState(states[i]);
                    TreeSet<String> mayAdd = new TreeSet<String>(Arrays.asList(Operations.getCanGoto(itemSet)));
                    int j = 0;
                    while (j < t.length) {
                        mayAdd.remove(((FSATransition)t[j]).getLabel());
                        ++j;
                    }
                    Iterator it = mayAdd.iterator();
                    while (it.hasNext()) {
                        String symbol = (String)it.next();
                        Set gotoSet = Operations.goTo(this.augmented, itemSet, symbol);
                        State second = (State)this.itemsToState.get(gotoSet);
                        if (second == null) {
                            Point p = placer.getPointForState(this.dfa);
                            second = this.dfa.createState(p);
                            Production[] gotoArray = gotoSet.toArray(new Production[0]);
                            this.assignItemsToState(gotoArray, second);
                        }
                        FSATransition nt = new FSATransition(states[i], second, symbol);
                        this.dfa.addTransition(nt);
                    }
                    handledStates.add(states[i]);
                }
                ++i;
            }
            states = this.dfa.getStates();
        }
        GEMLayoutAlgorithm layout = new GEMLayoutAlgorithm();
        AutomatonGraph graph = new AutomatonGraph(this.dfa);
        layout.layout(graph, originalStates);
        graph.moveAutomatonStates();
    }

    public void completeAll() {
        this.doAll = true;
        do {
            this.completeStep();
        } while (this.step != 4);
        this.doAll = false;
    }

    public void gotoGroup(State first, Point point, State second) {
        String symbol = JOptionPane.showInputDialog(this.firstFollow, (Object)"What is the grammar symbol for the transition?");
        if (symbol == null) {
            return;
        }
        Set from = (Set)this.stateToItems.get(first);
        Set to = Operations.goTo(this.augmented, from, symbol);
        if (to.size() == 0) {
            JOptionPane.showMessageDialog(this.firstFollow, "That symbol is invalid for this state.", "Bad Symbol for Group", 0);
            return;
        }
        if (second != null) {
            Set toUser = (Set)this.stateToItems.get(second);
            if (!to.equals(toUser)) {
                JOptionPane.showMessageDialog(this.firstFollow, "The symbol " + symbol + " can't join these two states.", "Bad Progression", 0);
                return;
            }
        } else {
            Production[] items = this.itemChooser.getItemSet(to, "Goto on " + symbol);
            if (items == null) {
                return;
            }
            HashSet<Production> itemSet = new HashSet<Production>();
            int i = 0;
            while (i < items.length) {
                itemSet.add(items[i]);
                ++i;
            }
            second = (State)this.itemsToState.get(itemSet);
            if (second == null) {
                second = this.dfa.createState(point);
                this.assignItemsToState(items, second);
            }
        }
        FSATransition t = new FSATransition(first, second, symbol);
        this.dfa.addTransition(t);
    }

    public boolean nextStep() {
        if (!this.done()) {
            return false;
        }
        ++this.step;
        switch (this.step) {
            case 0: {
                this.parseAction.setEnabled(false);
                this.firstFollow.getFFModel().setCanEditFirst(true);
                this.firstFollow.getFFModel().setCanEditFollow(false);
                this.directions.setText("Define FIRST sets.  ! is the lambda character.");
                break;
            }
            case 1: {
                this.firstFollow.getFFModel().setCanEditFirst(false);
                this.firstFollow.getFFModel().setCanEditFollow(true);
                this.directions.setText("Define FOLLOW sets.  $ is the end of string character.");
                break;
            }
            case 2: {
                this.doSelectedAction.setEnabled(false);
                this.firstFollow.getFFModel().setCanEditFollow(false);
                int choice = this.doAll ? 1 : JOptionPane.showConfirmDialog(this.firstFollow, "Masterfully done hero!  Now you must\ndefine the set of items for the intial DFA state.\nDo you want to define the initial set yourself?", "Initial Set Construction", 0);
                Set initialGotoSet = this.initialGotoSet();
                Production[] initials = choice == 0 ? null : initialGotoSet.toArray(new Production[0]);
                while (initials == null) {
                    initials = this.itemChooser.getItemSet(initialGotoSet, "Initial Goto Set");
                    if (initials != null) break;
                    JOptionPane.showMessageDialog(this.firstFollow, "The initial set MUST be created now.", "Initial Set Needed", 0);
                }
                State initialState = this.dfa.createState(new Point(60, 40));
                this.dfa.setInitialState(initialState);
                this.assignItemsToState(initials, initialState);
                this.directions.setText("Build the DFA.");
                break;
            }
            case 3: {
                this.doSelectedAction.setEnabled(true);
                this.targetParseTable = LRParseTableGenerator.generate(this.augmented, this.dfa, this.stateToItems, this.itemsToState, Operations.follow(this.grammar));
                this.userParseTable = new LRParseTable(this.augmented, this.dfa);
                this.derivation.moveDFA();
                this.derivation.setParseTable(this.userParseTable);
                this.directions.setText("Fill entries in parse table.");
                break;
            }
            case 4: {
                this.doSelectedAction.setEnabled(false);
                this.doStepAction.setEnabled(false);
                this.doAllAction.setEnabled(false);
                this.nextAction.setEnabled(false);
                this.parseAction.setEnabled(true);
                this.derivation.getParseTableView().shiftMode();
                this.directions.setText("Parse table complete.  Press \"parse\" to use it.");
            }
        }
        return true;
    }

    public void parse() {
        LRParsePane panel = new LRParsePane(this.environment, this.augmented, this.userParseTable);
        this.environment.add((Component)panel, "SLR(1) Parsing");
        this.environment.setActive(panel);
    }

    private void assignItemsToState(Production[] items, State state) {
        HashSet<Production> itemSet = new HashSet<Production>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            itemSet.add(items[i]);
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(items[i].toString());
            ++i;
        }
        state.setLabel(sb.toString());
        this.stateToItems.put(state, itemSet);
        this.itemsToState.put(itemSet, state);
    }
}

