/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.parse.LRParseTable;
import grammar.parse.Operations;
import gui.SplitPaneFactory;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.GotoTransitionTool;
import gui.grammar.parse.LRParseDerivationController;
import gui.grammar.parse.LRParseTableChooserPane;
import gui.viewer.AutomatonDraggerPane;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class LRParseTableDerivationPane
extends JPanel {
    private Grammar augmentedGrammar;
    private LRParseDerivationController controller;
    private FiniteStateAutomaton dfa;
    private JSplitPane split;
    private JSplitPane split2;
    private LRParseTableChooserPane tableView;

    public LRParseTableDerivationPane(GrammarEnvironment environment) {
        super(new BorderLayout());
        EditorPane editor;
        Grammar g = environment.getGrammar();
        this.augmentedGrammar = Operations.getAugmentedGrammar(g);
        if (this.augmentedGrammar == null) {
            return;
        }
        JPanel right = new JPanel(new BorderLayout());
        JLabel description = new JLabel();
        right.add((Component)description, "North");
        FirstFollowTable fftable = new FirstFollowTable(g);
        fftable.getColumnModel().getColumn(0).setPreferredWidth(30);
        right.add(new JScrollPane(fftable));
        fftable.getFFModel().setCanEditFirst(true);
        fftable.getFFModel().setCanEditFollow(true);
        this.dfa = new FiniteStateAutomaton();
        this.controller = new LRParseDerivationController(g, this.augmentedGrammar, environment, fftable, description, this.dfa, this);
        JPanel editorHolder = new JPanel(new BorderLayout());
        this.controller.editor = editor = this.createEditor(editorHolder);
        editorHolder.add((Component)editor, "Center");
        this.split = SplitPaneFactory.createSplit(environment, false, 0.4, new JScrollPane(fftable), editorHolder);
        this.split2 = SplitPaneFactory.createSplit(environment, false, 0.7, this.split, null);
        right.add((Component)this.split2, "Center");
        GrammarTable table = new GrammarTable(new GrammarTableModel(this.augmentedGrammar){

            public boolean isCellEditable(int r, int c) {
                return false;
            }
        }){

            public String getToolTipText(MouseEvent event) {
                try {
                    int row = this.rowAtPoint(event.getPoint());
                    return String.valueOf(this.getGrammarModel().getProduction(row).toString()) + " is production " + row;
                }
                catch (Throwable e) {
                    return null;
                }
            }
        };
        JSplitPane big = SplitPaneFactory.createSplit(environment, true, 0.3, table, right);
        this.add((Component)big, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.controller.doSelectedAction);
        toolbar.add(this.controller.doStepAction);
        toolbar.add(this.controller.doAllAction);
        toolbar.addSeparator();
        toolbar.add(this.controller.nextAction);
        toolbar.addSeparator();
        toolbar.add(this.controller.parseAction);
        this.add((Component)toolbar, "North");
    }

    private EditorPane createEditor(Component panel) {
        SelectionDrawer drawer = new SelectionDrawer(this.dfa);
        EditorPane editor = new EditorPane(drawer, new ToolBox(){

            public List tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowNontransitionTool(this, view, drawer){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean shouldAllowOnlyFinalStateChange() {
                        return true;
                    }

                    public boolean shouldShowStatePopup() {
                        return true;
                    }
                });
                tools.add(new GotoTransitionTool(view, drawer, LRParseTableDerivationPane.this.controller));
                return tools;
            }
        });
        return editor;
    }

    void moveDFA() {
        AutomatonDraggerPane dp = new AutomatonDraggerPane(this.dfa);
        this.split.setRightComponent(dp);
    }

    void setParseTable(LRParseTable table) {
        if (this.tableView == null) {
            this.tableView = new LRParseTableChooserPane(table);
            this.split2.setRightComponent(new JScrollPane(this.tableView));
        } else {
            this.tableView.setModel(table);
        }
    }

    LRParseTableChooserPane getParseTableView() {
        return this.tableView;
    }

    public Grammar getAugmentedGrammar() {
        return this.augmentedGrammar;
    }
}

