/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.SplitPaneFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.tree.DefaultTreeDrawer;
import gui.tree.LeafNodePlacer;
import gui.tree.TreePanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

abstract class ParsePane
extends JPanel {
    JTextField inputDisplay = new JTextField();
    JTextField stackDisplay = new JTextField();
    JLabel statusDisplay = new JLabel("Input a string to begin.");
    public JTextField inputField = new JTextField();
    public Grammar grammar;
    GrammarTable grammarTable;
    GrammarEnvironment environment;
    public AbstractAction stepAction = new AbstractAction("Step"){

        public void actionPerformed(ActionEvent e) {
            ParsePane.this.step();
        }
    };
    AbstractAction startAction = new AbstractAction("Start"){

        public void actionPerformed(ActionEvent e) {
            ParsePane.this.input(ParsePane.this.inputField.getText());
        }
    };
    DefaultTreeDrawer treeDrawer = new DefaultTreeDrawer(new DefaultTreeModel(new DefaultMutableTreeNode())){
        private final Color INNER = new Color(100, 200, 120);
        private final Color LEAF = new Color(255, 255, 100);

        protected Color getNodeColor(TreeNode node) {
            return node.isLeaf() ? this.LEAF : this.INNER;
        }
    };
    JComponent treePanel = new TreePanel(this.treeDrawer);
    DefaultTableModel derivationModel = new DefaultTableModel(new String[]{"Production", "Derivation"}, 0){

        public boolean isCellEditable(int r, int c) {
            return false;
        }
    };
    JSplitPane mainSplit;
    JSplitPane topSplit;
    JSplitPane bottomSplit;
    CardLayout treeDerivationLayout = new CardLayout();
    public JPanel treeDerivationPane = new JPanel(this.treeDerivationLayout);
    JScrollPane derivationPane;

    public ParsePane(GrammarEnvironment environment, Grammar grammar) {
        super(new BorderLayout());
        this.grammar = grammar;
        this.environment = environment;
    }

    protected void initView() {
        this.treePanel = this.initTreePanel();
        JTable pt = this.initParseTable();
        JScrollPane parseTable = pt == null ? null : new JScrollPane(pt);
        JScrollPane grammarTable = new JScrollPane(this.initGrammarTable(this.grammar));
        this.treeDerivationPane.add((Component)this.initTreePanel(), "0");
        this.derivationPane = new JScrollPane(this.initDerivationTable());
        this.treeDerivationPane.add((Component)this.derivationPane, "1");
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, true, 0.3, grammarTable, this.treeDerivationPane);
        this.topSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, parseTable, this.initInputPanel());
        this.mainSplit = SplitPaneFactory.createSplit(this.environment, false, 0.3, this.topSplit, this.bottomSplit);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.statusDisplay, "South");
    }

    protected GrammarTable initGrammarTable(Grammar grammar) {
        this.grammarTable = new GrammarTable(new GrammarTableModel(grammar){

            public boolean isCellEditable(int r, int c) {
                return false;
            }
        }){

            public String getToolTipText(MouseEvent event) {
                try {
                    int row = this.rowAtPoint(event.getPoint());
                    return String.valueOf(this.getGrammarModel().getProduction(row).toString()) + " is production " + row;
                }
                catch (Throwable e) {
                    return null;
                }
            }
        };
        return this.grammarTable;
    }

    protected JPanel initInputPanel() {
        JPanel bigger = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Input"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        panel.add((Component)this.inputField, c);
        this.inputField.addActionListener(this.startAction);
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel("Input Remaining"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.inputDisplay.setEditable(false);
        panel.add((Component)this.inputDisplay, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel("Stack"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.stackDisplay.setEditable(false);
        panel.add((Component)this.stackDisplay, c);
        bigger.add((Component)panel, "Center");
        bigger.add((Component)this.initInputToolbar(), "North");
        return bigger;
    }

    protected String[] getViewChoices() {
        return new String[]{"Noninverted Tree", "Inverted Tree", "Derivation Table"};
    }

    protected JToolBar initInputToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.startAction);
        this.stepAction.setEnabled(false);
        toolbar.add(this.stepAction);
        toolbar.addSeparator();
        final JComboBox<String> box = new JComboBox<String>(this.getViewChoices());
        box.setSelectedIndex(0);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParsePane.this.changeView((String)box.getSelectedItem());
            }
        };
        box.addActionListener(listener);
        toolbar.add(box);
        return toolbar;
    }

    private void changeView(String name) {
        if (name.equals("Noninverted Tree")) {
            this.treeDerivationLayout.first(this.treeDerivationPane);
            this.treeDrawer.setInverted(false);
            this.treePanel.repaint();
        } else if (name.equals("Inverted Tree")) {
            this.treeDerivationLayout.first(this.treeDerivationPane);
            this.treeDrawer.setInverted(true);
            this.treePanel.repaint();
        } else if (name.equals("Derivation Table")) {
            this.treeDerivationLayout.last(this.treeDerivationPane);
        }
    }

    protected abstract JTable initParseTable();

    protected JComponent initTreePanel() {
        this.treeDrawer.hideAll();
        this.treeDrawer.setNodePlacer(new LeafNodePlacer());
        return this.treePanel;
    }

    protected JTable initDerivationTable() {
        JTable table = new JTable(this.derivationModel);
        table.setGridColor(Color.lightGray);
        return table;
    }

    protected abstract void input(String var1);

    protected abstract boolean step();

    public void printComponent(Graphics g) {
        this.treeDerivationPane.print(g);
    }

    public void printChildren(Graphics g) {
    }
}

