/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Production;
import grammar.parse.ParseNode;
import gui.environment.Universe;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.UnrestrictedTreeNode;
import gui.tree.DefaultNodeDrawer;
import gui.tree.TreePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class UnrestrictedTreePanel
extends TreePanel {
    double realWidth;
    double realHeight;
    double metaWidth = -1.0;
    double metaHeight;
    private BruteParsePane brutePane;
    private ParseNode[] solutionParseNodes;
    private UnrestrictedTreeNode[][][] top = null;
    private UnrestrictedTreeNode[][][] bottom = null;
    private Map nodeToParentWeights = new HashMap();
    private Map nodeToParentGroup = new HashMap();
    private DefaultNodeDrawer nodeDrawer = new DefaultNodeDrawer();
    private static final Color INNER = new Color(100, 200, 120);
    private static final Color LEAF = new Color(255, 255, 100);
    private static final Color BRACKET = new Color(150, 150, 255);
    private static final Color BRACKET_OUT = BRACKET.darker().darker();
    int level = 0;
    int group = 0;
    int production = -1;

    public UnrestrictedTreePanel(BruteParsePane pane) {
        super(new DefaultTreeModel(new DefaultMutableTreeNode("")));
        this.brutePane = pane;
    }

    public String getTB() {
        StringBuffer total = new StringBuffer();
        int i = 0;
        while (i < this.top.length) {
            LinkedList<List<UnrestrictedTreeNode>> t = new LinkedList<List<UnrestrictedTreeNode>>();
            LinkedList<List<UnrestrictedTreeNode>> b = new LinkedList<List<UnrestrictedTreeNode>>();
            int j = 0;
            while (j < this.top[i].length) {
                t.add(Arrays.asList(this.top[i][j]));
                ++j;
            }
            j = 0;
            while (j < this.bottom[i].length) {
                b.add(Arrays.asList(this.bottom[i][j]));
                ++j;
            }
            total.append("T." + i + ": " + t + "\n");
            total.append("B." + i + ": " + b + "\n");
            ++i;
        }
        return total.toString();
    }

    private UnrestrictedTreeNode[] levelNodes(int level) {
        ArrayList<UnrestrictedTreeNode> list = new ArrayList<UnrestrictedTreeNode>();
        if (this.top[level] != null) {
            int i = 0;
            while (i < this.top[level].length) {
                int j = 0;
                while (j < this.top[level][i].length) {
                    list.add(this.top[level][i][j]);
                    ++j;
                }
                ++i;
            }
        }
        return list.toArray(new UnrestrictedTreeNode[0]);
    }

    private void bridgeTo(int level) {
        UnrestrictedTreeNode[] prev = this.levelNodes(level - 1);
        Production[] prods = this.solutionParseNodes[level].getProductions();
        int[] prodStarts = this.solutionParseNodes[level].getSubstitutions();
        int length = 0;
        int prodNum = 0;
        LinkedList<UnrestrictedTreeNode[]> bottomList = new LinkedList<UnrestrictedTreeNode[]>();
        LinkedList<UnrestrictedTreeNode[]> topList = new LinkedList<UnrestrictedTreeNode[]>();
        UnrestrictedTreeNode[] U = new UnrestrictedTreeNode[]{};
        UnrestrictedTreeNode[][] UU = new UnrestrictedTreeNode[0][0];
        int i = 0;
        while (i < prev.length) {
            if (prodNum >= prods.length || length < prodStarts[prodNum]) {
                UnrestrictedTreeNode[] a = new UnrestrictedTreeNode[]{prev[i]};
                bottomList.add(a);
                topList.add(a);
                length += prev[i].length();
                prev[i].lowest = level;
            } else if (length == prodStarts[prodNum]) {
                LinkedList<UnrestrictedTreeNode> currentBottom = new LinkedList<UnrestrictedTreeNode>();
                LinkedList<UnrestrictedTreeNode> currentTop = new LinkedList<UnrestrictedTreeNode>();
                String rhs = prods[prodNum].getRHS();
                String lhs = prods[prodNum].getLHS();
                while (length < prodStarts[prodNum] + lhs.length()) {
                    currentBottom.add(prev[i]);
                    prev[i].lowest = level - 1;
                    length += prev[i].length();
                    ++i;
                }
                UnrestrictedTreeNode[] b = currentBottom.toArray(U);
                --i;
                int j = 0;
                while (j < rhs.length()) {
                    UnrestrictedTreeNode node = new UnrestrictedTreeNode("" + rhs.charAt(j));
                    node.highest = node.lowest = level;
                    currentTop.add(node);
                    if (j == rhs.length() - 1) {
                        this.nodeToParentGroup.put(node, b);
                    }
                    ++j;
                }
                if (rhs.length() == 0) {
                    UnrestrictedTreeNode node = new UnrestrictedTreeNode("");
                    node.highest = node.lowest = level;
                    currentTop.add(node);
                    this.nodeToParentGroup.put(node, b);
                }
                bottomList.add(b);
                topList.add(currentTop.toArray(U));
                ++prodNum;
            }
            ++i;
        }
        this.bottom[level - 1] = (UnrestrictedTreeNode[][])bottomList.toArray((T[])UU);
        this.top[level] = (UnrestrictedTreeNode[][])topList.toArray((T[])UU);
    }

    private boolean ends(int level, int group) {
        block3: {
            try {
                if (level != this.bottom.length - 1) break block3;
                return true;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Level " + level + ", group " + group + " is out of range!");
            }
        }
        return !Arrays.equals(this.bottom[level][group], this.top[level + 1][group]);
    }

    private boolean begins(int level, int group) {
        if (level == 0) {
            return true;
        }
        return this.ends(level - 1, group);
    }

    private boolean assignWeights(int level, boolean[] need) {
        if (!need[level]) {
            return false;
        }
        need[level] = false;
        boolean changed = false;
        double total = 0.0;
        int i = 0;
        while (i < this.bottom[level].length) {
            UnrestrictedTreeNode[] s = this.bottom[level][i];
            UnrestrictedTreeNode[] c = this.top[level + 1][i];
            double cSum = 0.0;
            double sSum = 0.0;
            int j = 0;
            while (j < s.length) {
                sSum += s[j].weight;
                ++j;
            }
            if (!this.ends(level, i)) {
                total += sSum;
            } else {
                int j2;
                j = 0;
                while (j < c.length) {
                    cSum += c[j].weight;
                    ++j;
                }
                Double TOTAL = new Double(total + Math.max(sSum, cSum) / 2.0);
                int j3 = 0;
                while (j3 < c.length) {
                    this.nodeToParentWeights.put(c[j3], TOTAL);
                    ++j3;
                }
                total += Math.max(sSum, cSum);
                if (cSum > sSum) {
                    double ratio = cSum / sSum;
                    j2 = 0;
                    while (j2 < s.length) {
                        s[j2].weight *= ratio;
                        ++j2;
                    }
                    if (level != 0) {
                        need[level - 1] = true;
                    }
                    changed = true;
                } else if (cSum < sSum) {
                    double ratio = sSum / cSum;
                    j2 = 0;
                    while (j2 < c.length) {
                        c[j2].weight *= ratio;
                        ++j2;
                    }
                    if (level != 0) {
                        need[level + 1] = true;
                    }
                    changed = true;
                }
            }
            ++i;
        }
        return changed;
    }

    public void setAnswer(ParseNode answer) {
        if (answer == null) {
            this.top = null;
            return;
        }
        this.metaWidth = -1.0;
        this.solutionParseNodes = new ParseNode[answer.getLevel() + 1];
        while (answer != null) {
            this.solutionParseNodes[answer.getLevel()] = answer;
            answer = (ParseNode)answer.getParent();
        }
        this.top = new UnrestrictedTreeNode[this.solutionParseNodes.length][][];
        this.bottom = new UnrestrictedTreeNode[this.solutionParseNodes.length][][];
        this.top[0] = new UnrestrictedTreeNode[1][];
        this.top[0][0] = new UnrestrictedTreeNode[1];
        this.top[0][0][0] = new UnrestrictedTreeNode(this.solutionParseNodes[0].getDerivation());
        int i = 1;
        while (i < this.top.length) {
            this.bridgeTo(i);
            ++i;
        }
        this.bottom[this.bottom.length - 1] = this.top[this.top.length - 1];
        boolean[] need = new boolean[this.top.length];
        int i2 = 0;
        while (i2 < need.length) {
            need[i2] = true;
            ++i2;
        }
        boolean changed = true;
        int max = 0;
        while (changed && max < this.top.length * 2) {
            changed = false;
            int i3 = 0;
            while (i3 < this.top.length - 1) {
                changed |= this.assignWeights(i3, need);
                ++i3;
            }
            ++max;
        }
        this.group = 0;
        this.level = 0;
        this.brutePane.derivationModel.setRowCount(0);
        this.brutePane.derivationModel.addRow(new String[]{"", this.solutionParseNodes[0].getDerivation()});
    }

    public void paintNode(Graphics2D g, UnrestrictedTreeNode node, Point2D p) {
        g.setColor(node.lowest == this.top.length - 1 ? LEAF : INNER);
        g.translate(p.getX(), p.getY());
        this.nodeDrawer.draw(g, node);
        g.translate(-p.getX(), -p.getY());
    }

    private Point2D getPoint(int row, double weight, Point2D p) {
        if (p == null) {
            p = new Point2D.Double();
        }
        p.setLocation(this.realWidth * weight / this.metaWidth, this.realHeight * ((double)row + 0.5) / this.metaHeight);
        return p;
    }

    private void setMetaWidth() {
        int i = 0;
        while (i < this.top.length) {
            UnrestrictedTreeNode[] nodes = this.levelNodes(i);
            double total = 0.0;
            if (nodes != null) {
                int j = 0;
                while (j < nodes.length) {
                    total += nodes[j].weight;
                    ++j;
                }
            }
            this.metaWidth = Math.max(total, this.metaWidth);
            ++i;
        }
    }

    private void paintTree(Graphics2D g) {
        Dimension d = this.getSize();
        this.realWidth = d.width;
        this.realHeight = d.height;
        if (this.metaWidth == -1.0) {
            this.setMetaWidth();
        }
        this.metaHeight = this.top.length;
        Point2D.Double p = new Point2D.Double();
        HashMap<UnrestrictedTreeNode, Point2D> nodeToPoint = new HashMap<UnrestrictedTreeNode, Point2D>();
        int l = 0;
        while (l <= this.level) {
            double total = 0.0;
            UnrestrictedTreeNode[][] GG = l < this.level ? this.bottom[l] : this.top[l];
            int gr = 0;
            while (gr < GG.length && (this.level != l || gr <= this.group)) {
                int ay;
                int ax;
                int radius;
                Point2D beta;
                Point2D alpha;
                UnrestrictedTreeNode[] parent;
                Double D;
                Point2D point;
                int i;
                UnrestrictedTreeNode[] G = GG[gr];
                if (l <= this.level - 2 || l == this.level - 1 && gr <= this.group) {
                    i = 0;
                    while (i < G.length) {
                        if (l == G[i].lowest) {
                            point = this.getPoint(G[i].lowest, total + G[i].weight / 2.0, null);
                            this.getPoint(G[i].highest, total + G[i].weight / 2.0, p);
                            g.drawLine((int)point.getX(), (int)point.getY(), (int)((Point2D)p).getX(), (int)((Point2D)p).getY());
                            nodeToPoint.put(G[i], point);
                        }
                        if (l == G[i].highest) {
                            point = this.getPoint(G[i].highest, total + G[i].weight / 2.0, null);
                            D = (Double)this.nodeToParentWeights.get(G[i]);
                            if (D != null) {
                                double pweight = D;
                                this.getPoint(l - 1, pweight, p);
                                g.drawLine((int)point.getX(), (int)point.getY(), (int)((Point2D)p).getX(), (int)((Point2D)p).getY());
                            }
                            if ((parent = (UnrestrictedTreeNode[])this.nodeToParentGroup.get(G[i])) != null && parent.length != 1) {
                                alpha = (Point2D)nodeToPoint.get(parent[0]);
                                beta = (Point2D)nodeToPoint.get(parent[parent.length - 1]);
                                g.setColor(BRACKET);
                                radius = 13;
                                ax = (int)(alpha.getX() - (double)radius - 3.0);
                                ay = (int)(alpha.getY() - (double)radius - 3.0);
                                g.fillRoundRect(ax, ay, (int)(beta.getX() + (double)radius + 3.0) - ax, (int)(beta.getY() + (double)radius + 3.0) - ay, 2 * radius + 6, 2 * radius + 6);
                                g.setColor(BRACKET_OUT);
                                g.drawRoundRect(ax, ay, (int)(beta.getX() + (double)radius + 3.0) - ax, (int)(beta.getY() + (double)radius + 3.0) - ay, 2 * radius + 6, 2 * radius + 6);
                                g.setColor(Color.black);
                            }
                            nodeToPoint.put(G[i], point);
                        }
                        total += G[i].weight;
                        ++i;
                    }
                } else if (l <= this.level) {
                    i = 0;
                    while (i < G.length) {
                        if (l == G[i].highest) {
                            point = this.getPoint(G[i].highest, total + G[i].weight / 2.0, null);
                            D = (Double)this.nodeToParentWeights.get(G[i]);
                            if (D != null) {
                                double pweight = D;
                                this.getPoint(l - 1, pweight, p);
                                g.drawLine((int)point.getX(), (int)point.getY(), (int)((Point2D)p).getX(), (int)((Point2D)p).getY());
                            }
                            if ((parent = (UnrestrictedTreeNode[])this.nodeToParentGroup.get(G[i])) != null && parent.length != 1) {
                                alpha = (Point2D)nodeToPoint.get(parent[0]);
                                beta = (Point2D)nodeToPoint.get(parent[parent.length - 1]);
                                g.setColor(BRACKET);
                                radius = 13;
                                ax = (int)(alpha.getX() - (double)radius - 3.0);
                                ay = (int)(alpha.getY() - (double)radius - 3.0);
                                g.fillRoundRect(ax, ay, (int)(beta.getX() + (double)radius + 3.0) - ax, (int)(beta.getY() + (double)radius + 3.0) - ay, 2 * radius + 6, 2 * radius + 6);
                                g.setColor(BRACKET_OUT);
                                g.drawRoundRect(ax, ay, (int)(beta.getX() + (double)radius + 3.0) - ax, (int)(beta.getY() + (double)radius + 3.0) - ay, 2 * radius + 6, 2 * radius + 6);
                                g.setColor(Color.black);
                            }
                            nodeToPoint.put(G[i], point);
                        }
                        total += G[i].weight;
                        ++i;
                    }
                } else {
                    System.err.println("Badness in the drawer!");
                }
                ++gr;
            }
            ++l;
        }
        Iterator it = nodeToPoint.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.paintNode(g, (UnrestrictedTreeNode)e.getKey(), (Point2D)e.getValue());
        }
    }

    private String getDerivation(int level, int num) {
        StringBuffer b = new StringBuffer(this.solutionParseNodes[level - 1].getDerivation());
        int[] subs = this.solutionParseNodes[level].getSubstitutions();
        Production[] ps = this.solutionParseNodes[level].getProductions();
        do {
            b.delete(subs[num], subs[num] + ps[num].getLHS().length());
            b.insert(subs[num], ps[num].getRHS());
        } while (--num >= 0);
        return b.toString();
    }

    public boolean next() {
        Production p = null;
        Production[] ps = this.solutionParseNodes[this.level].getProductions();
        String derivation = null;
        ++this.production;
        if (this.production >= ps.length) {
            this.production = 0;
            p = this.solutionParseNodes[this.level + 1].getProductions()[0];
            derivation = this.getDerivation(this.level + 1, 0);
        } else {
            p = ps[this.production];
            derivation = this.getDerivation(this.level, this.production);
        }
        this.brutePane.derivationModel.addRow(new String[]{"" + p, derivation});
        do {
            ++this.group;
            if (this.group >= this.top[this.level].length) {
                this.group = 0;
                ++this.level;
            }
            if (this.level < this.top.length) continue;
            this.level = this.top.length - 1;
            this.group = this.top[this.level].length - 1;
            break;
        } while ((this.level != this.top.length - 1 || this.group != this.top[this.level].length - 1) && !this.begins(this.level, this.group));
        String lhs = p.getRHS();
        if (lhs.length() == 0) {
            lhs = Universe.curProfile.getEmptyString();
        }
        String text = "Derived " + lhs + " from " + p.getLHS() + ".";
        if (this.level == this.top.length - 1 && this.production == this.solutionParseNodes[this.level].getProductions().length - 1) {
            text = String.valueOf(text) + "  Derivations complete.";
            this.brutePane.statusDisplay.setText(text);
            return true;
        }
        this.brutePane.statusDisplay.setText(text);
        return false;
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        Dimension d = this.getSize();
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        if (this.top != null) {
            this.paintTree(g);
        }
        g.dispose();
    }
}

