/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.Production;
import gui.SplitPaneFactory;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

public class ChomskyPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    CNFConverter converter;
    private int[] need = new int[0];
    GrammarTable grammarTable;
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        public boolean isCellEditable(int r, int c) {
            return false;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    JLabel mainLabel = new JLabel(" ");
    JLabel directionLabel = new JLabel(" ");
    AbstractAction convertAction = new AbstractAction("Convert Selected"){

        public void actionPerformed(ActionEvent e) {
            ChomskyPane.this.convertSelected();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        public void actionPerformed(ActionEvent e) {
            ChomskyPane.this.doAll();
        }
    };
    AbstractAction highlightAction = new AbstractAction("What's Left?"){

        public void actionPerformed(ActionEvent e) {
            ChomskyPane.this.highlightRemaining();
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        public void actionPerformed(ActionEvent e) {
            ChomskyPane.this.export();
        }
    };

    public ChomskyPane(GrammarEnvironment environment, Grammar grammar) {
        this.environment = environment;
        this.grammar = grammar;
        this.converter = new CNFConverter(grammar);
        this.mainLabel.setText("Welcome to the Chomsky converter.");
        this.mainLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 10) {
                    ChomskyPane.this.mainLabel.setText("Click on me again, and I'll kick your ass.");
                }
            }
        });
        this.initView();
        this.updateDisplay();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel rightPanel = this.initRightPanel();
        JSplitPane mainSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), rightPanel);
        this.add((Component)mainSplit, "Center");
    }

    private JPanel initRightPanel() {
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        this.initEditingGrammarTable();
        this.mainLabel.setAlignmentX(0.0f);
        this.directionLabel.setAlignmentX(0.0f);
        right.add(this.mainLabel);
        right.add(this.directionLabel);
        right.add(new JScrollPane(this.editingGrammarView));
        JPanel biggie = new JPanel(new BorderLayout());
        biggie.add((Component)right, "Center");
        JToolBar bar = new JToolBar();
        bar.add(this.convertAction);
        bar.add(this.doAllAction);
        bar.add(this.highlightAction);
        bar.addSeparator();
        bar.add(this.exportAction);
        biggie.add((Component)bar, "North");
        return biggie;
    }

    private void updateDisplay() {
        this.need = this.getWhatNeedsDone();
        boolean done = this.need.length == 0;
        this.convertAction.setEnabled(!done);
        this.doAllAction.setEnabled(!done);
        this.highlightAction.setEnabled(!done);
        this.exportAction.setEnabled(done);
        if (done) {
            this.directionLabel.setText("Conversion done.  Press \"Export\" to use.");
        } else {
            this.directionLabel.setText(String.valueOf(this.need.length) + " production(s) must be converted.");
        }
    }

    private int[] getWhatNeedsDone() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.editingGrammarModel.getRowCount() - 1) {
            if (!this.converter.isChomsky(this.editingGrammarModel.getProduction(i))) {
                list.add(new Integer(i));
            }
            ++i;
        }
        int[] ret = new int[list.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return ret;
    }

    private void doAll() {
        ListSelectionModel model = this.editingGrammarView.getSelectionModel();
        while (this.need.length != 0) {
            model.clearSelection();
            int i = 0;
            while (i < this.need.length) {
                model.addSelectionInterval(this.need[i], this.need[i]);
                ++i;
            }
            this.convertSelected();
        }
        this.mainLabel.setText("All productions completed.");
        this.editingGrammarView.dehighlight();
    }

    private void highlightRemaining() {
        this.editingGrammarView.dehighlight();
        this.mainLabel.setText("Productions to convert are selected.");
        int i = 0;
        while (i < this.need.length) {
            this.editingGrammarView.highlight(this.need[i]);
            ++i;
        }
    }

    private void export() {
        Production[] p = this.editingGrammarModel.getProductions();
        try {
            p = CNFConverter.convert(p);
        }
        catch (UnsupportedOperationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Export Error", 0);
            return;
        }
        try {
            Grammar g = (Grammar)this.grammar.getClass().newInstance();
            g.addProductions(p);
            g.setStartVariable(this.grammar.getStartVariable());
            FrameFactory.createFrame(g);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    private void convertSelected() {
        if (!this.convertAction.isEnabled()) {
            return;
        }
        int[] r = this.editingGrammarView.getSelectedRows();
        int unneeded = 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.editingGrammarView.dehighlight();
        int i = r.length - 1;
        while (i >= 0) {
            block10: {
                Production p = this.editingGrammarModel.getProduction(r[i]);
                if (p == null) {
                    return;
                }
                Production[] ps = null;
                try {
                    ps = this.converter.replacements(p);
                }
                catch (IllegalArgumentException e) {
                    ++unneeded;
                    break block10;
                }
                this.editingGrammarModel.deleteRow(r[i]);
                int j = ps.length - 1;
                while (j >= 0) {
                    this.editingGrammarModel.addProduction(ps[j], r[i]);
                    Integer integer = new Integer(r[i]);
                    list.add(0, integer);
                    --j;
                }
            }
            --i;
        }
        if (unneeded > 0) {
            JOptionPane.showMessageDialog(this, "Conversion unneeded on " + unneeded + " production(s).\n" + (r.length - unneeded) + " production(s) converted.", "Conversion Unneeded", 0);
        }
        int last = -1;
        int adjust = 0;
        int i2 = 0;
        while (i2 < list.size()) {
            int toHighlight = (Integer)list.get(i2) + i2;
            if (last != -1 && last != toHighlight - 1) {
                ++adjust;
            }
            last = toHighlight;
            this.editingGrammarView.highlight(toHighlight -= adjust);
            ++i2;
        }
        if (list.size() != 0) {
            this.editingGrammarView.repaint();
            this.mainLabel.setText("Replacement production(s) highlighted.");
        }
        this.updateDisplay();
    }

    private void initEditingGrammarTable() {
        this.editingGrammarView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChomskyPane.this.convertSelected();
                }
            }
        });
        Production[] ps = this.grammar.getProductions();
        int i = 0;
        while (i < ps.length) {
            this.editingGrammarModel.addProduction(ps[i]);
            ++i;
        }
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            public boolean isCellEditable(int r, int c) {
                return false;
            }
        });
        return this.grammarTable;
    }
}

