/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import automata.State;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.UnitProductionRemover;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.UnitPane;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;

class UnitController {
    UnitPane pane;
    Grammar grammar;
    UnitProductionRemover remover = new UnitProductionRemover();
    VariableDependencyGraph vdg;
    Set vdgTransitions = new HashSet();
    Set desiredProductions = new HashSet();
    Set currentProductions = new HashSet();
    Set unitProductions = new HashSet();
    int step = 0;
    static final int VARAIBLE_GRAPH = 1;
    static final int PRODUCTION_MODIFY = 2;
    static final int FINISHED = 3;

    public UnitController(UnitPane pane, Grammar grammar) {
        this.pane = pane;
        this.grammar = grammar;
        this.nextStep();
    }

    private void nextStep() {
        if (this.step != 3) {
            ++this.step;
        }
        switch (this.step) {
            case 1: {
                this.pane.mainLabel.setText("Complete unit production visualization.");
                this.pane.detailLabel.setText("For every unit production, connect start and end.");
                this.vdg = new VariableDependencyGraph();
                this.remover.initializeDependencyGraph(this.vdg, this.grammar);
                Production[] p = this.grammar.getProductions();
                int i = 0;
                while (i < p.length) {
                    if (ProductionChecker.isUnitProduction(p[i])) {
                        this.vdgTransitions.add(this.remover.getTransitionForUnitProduction(p[i], this.vdg));
                    }
                    ++i;
                }
                this.vdg.addTransitionListener(new AutomataTransitionListener(){

                    public void automataTransitionChange(AutomataTransitionEvent e) {
                        if (!e.isAdd()) {
                            return;
                        }
                        if (UnitController.this.vdgTransitions.contains(e.getTransition())) {
                            UnitController.this.vdgTransitions.remove(e.getTransition());
                            UnitController.this.updateDisplay();
                            return;
                        }
                        JOptionPane.showMessageDialog(UnitController.this.pane, "Transition is not part of VDG.", "Bad Transition", 0);
                        UnitController.this.vdg.removeTransition(e.getTransition());
                    }
                });
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.doStepAction.setEnabled(true);
                this.pane.doAllAction.setEnabled(true);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
                this.updateDisplay();
                break;
            }
            case 2: {
                this.pane.updateDeleteEnabledness();
                this.pane.updateCompleteSelectedEnabledness();
                this.pane.mainLabel.setText("Modify the grammar to remove unit productions.");
                Production[] p = this.grammar.getProductions();
                int i = 0;
                while (i < p.length) {
                    this.pane.editingGrammarModel.addProduction(p[i]);
                    this.currentProductions.add(p[i]);
                    if (ProductionChecker.isUnitProduction(p[i])) {
                        this.unitProductions.add(p[i]);
                    }
                    ++i;
                }
                Grammar desiredGrammar = this.remover.getUnitProductionlessGrammar(this.grammar, this.vdg);
                p = desiredGrammar.getProductions();
                int i2 = 0;
                while (i2 < p.length) {
                    this.desiredProductions.add(p[i2]);
                    ++i2;
                }
                this.updateDisplay();
                this.pane.editingActive = true;
                break;
            }
            case 3: {
                this.pane.editingActive = false;
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.mainLabel.setText("Unit removal complete.");
                this.pane.detailLabel.setText("\"Proceed\" or \"Export\" available.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(true);
                this.pane.exportAction.setEnabled(true);
            }
        }
    }

    void doSelected() {
        this.pane.editingActive = false;
        int[] selectedRows = this.pane.editingGrammarView.getSelectedRows();
        GrammarTableModel model = this.pane.editingGrammarModel;
        HashSet<Production> selectedUnitProductions = new HashSet<Production>();
        int i = selectedRows.length - 1;
        while (i >= 0) {
            Production p = model.getProduction(selectedRows[i]);
            if (ProductionChecker.isUnitProduction(p)) {
                selectedUnitProductions.add(p);
                this.pane.editingGrammarModel.deleteRow(selectedRows[i]);
                this.unitProductions.remove(p);
                this.currentProductions.remove(p);
            }
            --i;
        }
        HashSet<Production> toAdd = new HashSet<Production>();
        Iterator it = selectedUnitProductions.iterator();
        while (it.hasNext()) {
            Production unit = (Production)it.next();
            Iterator dit = this.desiredProductions.iterator();
            while (dit.hasNext()) {
                Production p = (Production)dit.next();
                if (!p.getLHS().equals(unit.getRHS())) continue;
                toAdd.add(new Production(unit.getLHS(), p.getRHS()));
            }
        }
        it = toAdd.iterator();
        while (it.hasNext()) {
            Production p = (Production)it.next();
            if (!this.currentProductions.add(p)) continue;
            this.pane.editingGrammarModel.addProduction(p);
        }
        this.pane.editingActive = true;
        if (this.currentProductions.equals(this.desiredProductions)) {
            this.nextStep();
        } else {
            this.updateDisplay();
        }
    }

    void doStep() {
        switch (this.step) {
            case 1: {
                Transition[] t = this.vdgTransitions.toArray(new Transition[0]);
                int i = 0;
                while (i < t.length) {
                    this.vdg.addTransition(t[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = this.pane.editingGrammarModel.getRowCount() - 2;
                while (i >= 0) {
                    Production p = this.pane.editingGrammarModel.getProduction(i);
                    if (this.unitProductions.contains(p)) {
                        this.pane.editingGrammarModel.deleteRow(i);
                        this.unitProductions.remove(p);
                    }
                    --i;
                }
                this.pane.editingActive = false;
                Production[] p = this.desiredProductions.toArray(new Production[0]);
                int i2 = 0;
                while (i2 < p.length) {
                    if (this.currentProductions.add(p[i2])) {
                        this.pane.editingGrammarModel.addProduction(p[i2]);
                    }
                    ++i2;
                }
                this.nextStep();
                break;
            }
        }
    }

    void doAll() {
        while (this.step != 3) {
            this.doStep();
        }
    }

    void updateDisplay() {
        switch (this.step) {
            case 1: {
                int toAdd = this.vdgTransitions.size();
                this.pane.detailLabel.setText(String.valueOf(toAdd) + " more transition(s) needed.");
                if (toAdd != 0) break;
                this.nextStep();
                break;
            }
            case 2: {
                int toRemove = this.unitProductions.size();
                int toAdd = this.desiredProductions.size() - this.currentProductions.size() + toRemove;
                this.pane.detailLabel.setText(String.valueOf(toRemove) + " more remove" + (toRemove == 1 ? "" : "s") + ", and " + toAdd + " more addition" + (toAdd == 1 ? "" : "s") + " needed.");
                if (toAdd != 0 || toRemove != 0) break;
                this.nextStep();
            }
        }
    }

    boolean productionAdded(Production production, int row) {
        if (this.currentProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is already in the grammar.", "Production Already Here", 0);
            return false;
        }
        if (!this.desiredProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is not part of the reformed grammar.", "Production Not Desired", 0);
            return false;
        }
        this.currentProductions.add(production);
        this.updateDisplay();
        return true;
    }

    void stateClicked(State state, MouseEvent event) {
        if (event.isShiftDown()) {
            if (state == null) {
                return;
            }
            if (this.pane.vdgDrawer.isSelected(state)) {
                this.pane.vdgDrawer.removeSelected(state);
            } else {
                this.pane.vdgDrawer.addSelected(state);
            }
        } else if (state == null) {
            this.pane.vdgDrawer.clearSelected();
        } else if (!this.pane.vdgDrawer.isSelected(state)) {
            this.pane.vdgDrawer.clearSelected();
            this.pane.vdgDrawer.addSelected(state);
        }
        this.pane.vdgEditor.repaint();
        this.pane.completeSelectedAction.setEnabled(this.pane.vdgDrawer.numberSelected() > 0);
    }

    boolean productionDeleted(Production production, int row) {
        if (!ProductionChecker.isUnitProduction(production)) {
            return false;
        }
        this.unitProductions.remove(production);
        this.currentProductions.remove(production);
        return true;
    }
}

