/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import automata.State;
import grammar.Grammar;
import grammar.Production;
import gui.SplitPaneFactory;
import gui.action.GrammarTransformAction;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.UnitController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class UnitPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    UnitController controller;
    GrammarTable grammarTable;
    JLabel mainLabel = new JLabel(" ");
    JLabel detailLabel = new JLabel(" ");
    EditorPane vdgEditor;
    SelectionDrawer vdgDrawer;
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        public void actionPerformed(ActionEvent e) {
            UnitPane.this.controller.doStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        public void actionPerformed(ActionEvent e) {
            UnitPane.this.controller.doAll();
        }
    };
    AbstractAction proceedAction = new AbstractAction("Proceed"){

        public void actionPerformed(ActionEvent e) {
            GrammarTransformAction.hypothesizeUseless(UnitPane.this.environment, UnitPane.this.getGrammar());
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        public void actionPerformed(ActionEvent e) {
            FrameFactory.createFrame(UnitPane.this.getGrammar());
        }
    };
    boolean editingActive = false;
    private int editingRow = -1;
    private boolean[] editingColumn = new boolean[2];
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        public boolean isCellEditable(int r, int c) {
            if (!UnitPane.this.editingActive) {
                return false;
            }
            if (UnitPane.this.controller.step != 2) {
                return false;
            }
            if (c == 1) {
                return false;
            }
            if (UnitPane.this.editingRow == -1) {
                if (r == this.getRowCount() - 1) {
                    UnitPane.this.editingRow = r;
                    ((UnitPane)UnitPane.this).editingColumn[1] = false;
                    ((UnitPane)UnitPane.this).editingColumn[0] = false;
                    return true;
                }
                return false;
            }
            return UnitPane.this.editingRow == r;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    AbstractAction deleteAction = new AbstractAction("Delete"){

        public void actionPerformed(ActionEvent e) {
            UnitPane.this.deleteActivated();
        }
    };
    AbstractAction completeSelectedAction = new AbstractAction("Complete Selected"){

        public void actionPerformed(ActionEvent e) {
            UnitPane.this.cancelEditing();
            UnitPane.this.controller.doSelected();
        }
    };

    public UnitPane(GrammarEnvironment environment, Grammar grammar) {
        this.environment = environment;
        this.grammar = grammar;
        this.controller = new UnitController(this, grammar);
        this.initView();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel rightPanel = this.initRightPanel();
        JSplitPane mainSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), rightPanel);
        this.add((Component)mainSplit, "Center");
    }

    private JPanel initRightPanel() {
        JPanel right = new JPanel(new BorderLayout());
        this.mainLabel.setAlignmentX(0.0f);
        this.detailLabel.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.mainLabel);
        panel.add(this.detailLabel);
        this.initEditingGrammarTable();
        this.vdgDrawer = new SelectionDrawer(this.controller.vdg);
        this.vdgEditor = new EditorPane(this.vdgDrawer, new ToolBox(){

            public List tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> t = new LinkedList<Tool>();
                t.add(new ArrowNontransitionTool(this, view, drawer){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void mouseClicked(MouseEvent e) {
                        super.mouseClicked(e);
                        State s = 8.access$0(this.this$1).vdgDrawer.stateAtPoint(e.getPoint());
                        if (8.access$0(this.this$1).controller.step == 2) {
                            8.access$0(this.this$1).controller.stateClicked(s, e);
                        }
                    }
                });
                t.add(new TransitionTool(view, drawer));
                return t;
            }

            static /* synthetic */ UnitPane access$0(8 var0) {
                return var0.UnitPane.this;
            }
        }, true);
        JPanel grammarEditor = new JPanel(new BorderLayout());
        JToolBar editingBar = new JToolBar();
        editingBar.setAlignmentX(0.0f);
        editingBar.setFloatable(false);
        editingBar.add(this.deleteAction);
        editingBar.add(this.completeSelectedAction);
        grammarEditor.add((Component)editingBar, "North");
        grammarEditor.add((Component)new JScrollPane(this.editingGrammarView), "Center");
        JSplitPane rightSplit = SplitPaneFactory.createSplit(this.environment, false, 0.5, this.vdgEditor, grammarEditor);
        panel.add(rightSplit);
        JToolBar toolbar = new JToolBar();
        toolbar.setAlignmentX(0.0f);
        toolbar.add(this.doStepAction);
        toolbar.add(this.doAllAction);
        toolbar.addSeparator();
        toolbar.add(this.proceedAction);
        toolbar.add(this.exportAction);
        right.add((Component)toolbar, "North");
        right.add((Component)panel, "Center");
        return right;
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            public boolean isCellEditable(int r, int c) {
                return false;
            }
        });
        return this.grammarTable;
    }

    void updateDeleteEnabledness() {
        if (this.controller.step != 2) {
            this.deleteAction.setEnabled(false);
            return;
        }
        int min = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (min == -1 || min >= this.editingGrammarModel.getRowCount() - 1) {
            this.deleteAction.setEnabled(false);
            return;
        }
        this.deleteAction.setEnabled(true);
    }

    void updateCompleteSelectedEnabledness() {
        if (this.controller.step != 2) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        int min = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (min == -1 || min >= this.editingGrammarModel.getRowCount() - 1) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        this.completeSelectedAction.setEnabled(true);
    }

    private void initEditingGrammarTable() {
        this.editingGrammarModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent event) {
                if (!UnitPane.this.editingActive) {
                    return;
                }
                int r = event.getFirstRow();
                if (event.getType() != 0) {
                    return;
                }
                ((UnitPane)UnitPane.this).editingColumn[event.getColumn() >> 1] = true;
                if (UnitPane.this.editingColumn[0] && UnitPane.this.editingColumn[1]) {
                    Production p = UnitPane.this.editingGrammarModel.getProduction(r);
                    if (p == null) {
                        return;
                    }
                    if (!UnitPane.this.controller.productionAdded(p, r)) {
                        UnitPane.this.editingGrammarModel.deleteRow(r);
                    }
                    UnitPane.this.editingRow = -1;
                }
            }
        });
        this.editingGrammarView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                UnitPane.this.updateDeleteEnabledness();
                UnitPane.this.updateCompleteSelectedEnabledness();
            }
        });
        Object o = new Object();
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(8, 0), o);
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), o);
        this.editingGrammarView.getActionMap().put(o, this.deleteAction);
    }

    void cancelEditing() {
        if (this.editingGrammarView.getCellEditor() != null) {
            this.editingGrammarView.getCellEditor().stopCellEditing();
        }
        if (this.editingRow != -1) {
            this.editingGrammarModel.deleteRow(this.editingRow);
            this.editingRow = -1;
        }
    }

    private Grammar getGrammar() {
        Grammar g = this.editingGrammarView.getGrammar(this.grammar.getClass());
        Production[] p = g.getProductions();
        final String S = this.grammar.getStartVariable();
        Arrays.sort(p, new Comparator(){

            public int compare(Object o1, Object o2) {
                Production p1 = (Production)o1;
                Production p2 = (Production)o2;
                if (S.equals(p1.getLHS())) {
                    if (p1.getLHS().equals(p2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if (S.equals(p2.getLHS())) {
                    return 1;
                }
                return p1.getLHS().compareTo(p2.getRHS());
            }
        });
        Grammar g2 = null;
        try {
            g2 = (Grammar)g.getClass().newInstance();
            g2.addProductions(p);
            g2.setStartVariable(S);
        }
        catch (Throwable e) {
            System.err.println("BADNESS!");
            System.err.println(e);
            return g2;
        }
        return g2;
    }

    private void deleteActivated() {
        if (this.controller.step != 2) {
            return;
        }
        this.cancelEditing();
        int deleted = 0;
        int kept = 0;
        int i = this.editingGrammarModel.getRowCount() - 2;
        while (i >= 0) {
            if (this.editingGrammarView.isRowSelected(i)) {
                Production p = this.editingGrammarModel.getProduction(i);
                if (this.controller.productionDeleted(p, i)) {
                    this.editingGrammarModel.deleteRow(i);
                    ++deleted;
                } else {
                    ++kept;
                }
            }
            --i;
        }
        if (kept != 0) {
            JOptionPane.showMessageDialog(this, String.valueOf(kept) + " production(s) selected should not be removed.\n" + deleted + " production(s) were removed.", "Bad Selection", 0);
        }
        if (deleted != 0) {
            this.controller.updateDisplay();
        }
    }
}

