/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionComparator;
import gui.SplitPaneFactory;
import gui.action.GrammarTransformAction;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.UselessController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UselessPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    UselessController controller;
    GrammarTable grammarTable;
    JLabel mainLabel = new JLabel(" ");
    JLabel detailLabel = new JLabel(" ");
    JLabel terminalLabel = new JLabel(" ");
    EditorPane vdgEditor;
    SelectionDrawer vdgDrawer;
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        public void actionPerformed(ActionEvent e) {
            UselessPane.this.controller.doStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        public void actionPerformed(ActionEvent e) {
            UselessPane.this.controller.doAll();
        }
    };
    AbstractAction proceedAction = new AbstractAction("Proceed"){

        public void actionPerformed(ActionEvent e) {
            Grammar g = UselessPane.this.getGrammar();
            if (g == null) {
                JOptionPane.showMessageDialog(UselessPane.this.environment, "The grammar is empty.  Cannot proceed.", "Bad Grammar", 0);
                return;
            }
            GrammarTransformAction.hypothesizeChomsky(UselessPane.this.environment, UselessPane.this.getGrammar());
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        public void actionPerformed(ActionEvent e) {
            Grammar g = UselessPane.this.getGrammar();
            if (g == null) {
                JOptionPane.showMessageDialog(UselessPane.this.environment, "The grammar is empty.  Cannot proceed.", "Bad Grammar", 0);
                return;
            }
            FrameFactory.createFrame(UselessPane.this.getGrammar());
        }
    };
    boolean editingActive = false;
    private int editingRow = -1;
    private boolean[] editingColumn = new boolean[2];
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        public boolean isCellEditable(int r, int c) {
            return false;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    AbstractAction deleteAction = new AbstractAction("Delete"){

        public void actionPerformed(ActionEvent e) {
            UselessPane.this.deleteActivated();
        }
    };

    public UselessPane(GrammarEnvironment environment, Grammar grammar) {
        this.environment = environment;
        this.grammar = grammar;
        this.controller = new UselessController(this, grammar);
        this.initView();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel rightPanel = this.initRightPanel();
        JSplitPane mainSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), rightPanel);
        this.add((Component)mainSplit, "Center");
    }

    private JPanel initRightPanel() {
        JPanel right = new JPanel(new BorderLayout());
        this.mainLabel.setAlignmentX(0.0f);
        this.detailLabel.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.mainLabel);
        panel.add(this.detailLabel);
        panel.add(this.terminalLabel);
        this.initEditingGrammarTable();
        this.vdgDrawer = new SelectionDrawer(this.controller.vdg);
        this.vdgEditor = new EditorPane(this.vdgDrawer, new ToolBox(){

            public List tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> t = new LinkedList<Tool>();
                t.add(new ArrowNontransitionTool(view, drawer));
                t.add(new TransitionTool(view, drawer));
                return t;
            }
        }, true);
        JPanel grammarEditor = new JPanel(new BorderLayout());
        JToolBar editingBar = new JToolBar();
        editingBar.setAlignmentX(0.0f);
        editingBar.setFloatable(false);
        editingBar.add(this.deleteAction);
        grammarEditor.add((Component)editingBar, "North");
        grammarEditor.add((Component)new JScrollPane(this.editingGrammarView), "Center");
        JSplitPane rightSplit = SplitPaneFactory.createSplit(this.environment, false, 0.5, this.vdgEditor, grammarEditor);
        panel.add(rightSplit);
        JToolBar toolbar = new JToolBar();
        toolbar.setAlignmentX(0.0f);
        toolbar.add(this.doStepAction);
        toolbar.add(this.doAllAction);
        toolbar.addSeparator();
        toolbar.add(this.proceedAction);
        toolbar.add(this.exportAction);
        right.add((Component)toolbar, "North");
        right.add((Component)panel, "Center");
        return right;
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            public boolean isCellEditable(int r, int c) {
                return false;
            }
        });
        this.grammarTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                Point at;
                GrammarTable gt = (GrammarTable)event.getSource();
                int row = gt.rowAtPoint(at = event.getPoint());
                if (row == -1) {
                    return;
                }
                if (row == gt.getGrammarModel().getRowCount() - 1) {
                    return;
                }
                Production p = gt.getGrammarModel().getProduction(row);
                UselessPane.this.controller.productionClicked(p, event);
            }
        });
        return this.grammarTable;
    }

    void updateDeleteEnabledness() {
        if (this.controller.step != 3) {
            this.deleteAction.setEnabled(false);
            return;
        }
        int min = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (min == -1 || min >= this.editingGrammarModel.getRowCount() - 1) {
            this.deleteAction.setEnabled(false);
            return;
        }
        this.deleteAction.setEnabled(true);
    }

    private void initEditingGrammarTable() {
        this.editingGrammarView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                UselessPane.this.updateDeleteEnabledness();
            }
        });
        Object o = new Object();
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(8, 0), o);
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), o);
        this.editingGrammarView.getActionMap().put(o, this.deleteAction);
    }

    private void deleteActivated() {
        if (this.controller.step != 3) {
            return;
        }
        int deleted = 0;
        int kept = 0;
        int i = this.editingGrammarModel.getRowCount() - 2;
        while (i >= 0) {
            if (this.editingGrammarView.isRowSelected(i)) {
                Production p = this.editingGrammarModel.getProduction(i);
                if (this.controller.productionDeleted(p, i)) {
                    this.editingGrammarModel.deleteRow(i);
                    ++deleted;
                } else {
                    ++kept;
                }
            }
            --i;
        }
        if (kept != 0) {
            JOptionPane.showMessageDialog(this, String.valueOf(kept) + " production(s) selected should not be removed.\n" + deleted + " production(s) were removed.", "Bad Selection", 0);
        }
        if (deleted != 0) {
            this.controller.updateDisplay();
        }
    }

    private Grammar getGrammar() {
        Grammar g = this.editingGrammarView.getGrammar(this.grammar.getClass());
        Production[] p = g.getProductions();
        Arrays.sort(p, new ProductionComparator(this.grammar));
        if (p.length == 0 || !p[0].getLHS().equals(this.grammar.getStartVariable())) {
            return null;
        }
        Grammar g2 = null;
        try {
            g2 = (Grammar)g.getClass().newInstance();
            g2.addProductions(p);
            g2.setStartVariable(this.grammar.getStartVariable());
        }
        catch (Throwable e) {
            System.err.println("BADNESS!");
            System.err.println(e);
            return g2;
        }
        return g2;
    }
}

