/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import grammar.lsystem.Expander;
import grammar.lsystem.LSystem;
import gui.ImageDisplayComponent;
import gui.lsystem.LSystemInputPane;
import gui.lsystem.Renderer;
import gui.transform.Matrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayPane
extends JPanel {
    private LSystem lsystem;
    private Expander expander = null;
    private Renderer renderer = new Renderer();
    private ImageDisplayComponent imageDisplay = new ImageDisplayComponent();
    private SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, 200, 1);
    private JTextField expansionDisplay = new JTextField();
    private JProgressBar progressBar = new JProgressBar(0, 1);
    private Action displayAction = new AbstractAction("Redisplay"){

        public void actionPerformed(ActionEvent e) {
            DisplayPane.this.updateDisplay();
            DisplayPane.this.displayAction.setEnabled(false);
        }
    };
    private SpinnerNumberModel pitchModel = new SpinnerNumberModel(0, 0, 359, 15);
    private SpinnerNumberModel rollModel = new SpinnerNumberModel(0, 0, 359, 15);
    private SpinnerNumberModel yawModel = new SpinnerNumberModel(0, 0, 359, 15);

    public DisplayPane(LSystem lsystem) {
        super(new BorderLayout());
        this.lsystem = lsystem;
        this.expander = new Expander(lsystem);
        this.expansionDisplay.setEditable(false);
        JSpinner spinner = new JSpinner(this.spinnerModel);
        this.spinnerModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DisplayPane.this.updateDisplay();
            }
        });
        JSpinner s1 = new JSpinner(this.pitchModel);
        JSpinner s2 = new JSpinner(this.rollModel);
        JSpinner s3 = new JSpinner(this.yawModel);
        ChangeListener c = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DisplayPane.this.updateDisplay();
            }
        };
        this.pitchModel.addChangeListener(c);
        this.rollModel.addChangeListener(c);
        this.yawModel.addChangeListener(c);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)spinner, "East");
        topPanel.add((Component)this.expansionDisplay, "Center");
        topPanel.add((Component)this.progressBar, "West");
        this.add((Component)topPanel, "North");
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JLabel("Pitch"));
        bottomPanel.add(s1);
        bottomPanel.add(new JLabel("Roll"));
        bottomPanel.add(s2);
        bottomPanel.add(new JLabel("Yaw"));
        bottomPanel.add(s3);
        JScrollPane scroller = new JScrollPane(this.imageDisplay);
        this.add((Component)scroller, "Center");
        this.add((Component)bottomPanel, "South");
        this.updateDisplay();
    }

    private void updateDisplay() {
        int recursionDepth = this.spinnerModel.getNumber().intValue();
        final List expansion = this.expander.expansionForLevel(recursionDepth);
        this.progressBar.setMaximum(expansion.size() * 2);
        this.imageDisplay.setImage(null);
        Object renderImage = null;
        final Timer t = new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = DisplayPane.this.renderer.getDoneSymbols() - 1;
                DisplayPane.this.progressBar.setValue(i);
                DisplayPane.this.progressBar.repaint();
            }
        });
        Thread drawThread = new Thread(){

            public void run() {
                if (expansion.size() < 70) {
                    String expansionString = LSystemInputPane.listAsString(expansion);
                    DisplayPane.this.expansionDisplay.setText(expansionString);
                } else {
                    DisplayPane.this.expansionDisplay.setText("Suffice to say, quite long.");
                }
                Map parameters = DisplayPane.this.lsystem.getValues();
                t.start();
                Matrix m = new Matrix();
                double pitch = DisplayPane.this.pitchModel.getNumber().doubleValue();
                double roll = DisplayPane.this.rollModel.getNumber().doubleValue();
                double yaw = DisplayPane.this.yawModel.getNumber().doubleValue();
                m.pitch(pitch);
                m.roll(roll);
                m.yaw(yaw);
                Point origin = new Point();
                Image image = DisplayPane.this.renderer.render(expansion, parameters, m, null, origin);
                DisplayPane.this.imageDisplay.setImage(image);
                t.stop();
                DisplayPane.this.imageDisplay.repaint();
                DisplayPane.this.imageDisplay.revalidate();
                DisplayPane.this.progressBar.setValue(DisplayPane.this.progressBar.getMaximum());
            }
        };
        drawThread.start();
    }

    public void printComponent(Graphics g) {
        int recursionDepth = this.spinnerModel.getNumber().intValue();
        List expansion = this.expander.expansionForLevel(recursionDepth);
        Map parameters = this.lsystem.getValues();
        Matrix m = new Matrix();
        double pitch = this.pitchModel.getNumber().doubleValue();
        double roll = this.rollModel.getNumber().doubleValue();
        double yaw = this.yawModel.getNumber().doubleValue();
        m.pitch(pitch);
        m.roll(roll);
        m.yaw(yaw);
        this.renderer.render(expansion, parameters, m, (Graphics2D)g, new Point());
    }

    public void printChildren(Graphics g) {
    }
}

