/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import gui.lsystem.Turtle;
import gui.transform.Matrix;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class Renderer {
    private Map handlers = new HashMap();
    private boolean areDrawing = false;
    private boolean isActive = false;
    private Stack turtleStack = new Stack();
    private Turtle currentTurtle;
    private Graphics2D g;
    private GeneralPath polygon = null;
    private GeneralPath linePath = new GeneralPath();
    private int drawnSofar;
    private int completedSymbols;
    private int totalSymbols;
    public static Set ASSIGN_WORDS;
    public static Set NONASSIGN_WORDS;

    static {
        TreeSet<String> s = new TreeSet<String>();
        s.add("color");
        s.add("polygonColor");
        NONASSIGN_WORDS = Collections.unmodifiableSet(new HashSet(s));
        s.add("angle");
        s.add("lineWidth");
        s.add("lineIncrement");
        s.add("distance");
        s.add("hueChange");
        ASSIGN_WORDS = Collections.unmodifiableSet(s);
    }

    public Renderer() {
        this.handlers.put("g", new MoveHandler(true, true));
        this.handlers.put("f", new MoveHandler(false, true));
        this.handlers.put("+", new TurnHandler(true));
        this.handlers.put("-", new TurnHandler(false));
        this.handlers.put("&", new PitchHandler(true));
        this.handlers.put("^", new PitchHandler(false));
        this.handlers.put("/", new RollHandler(true));
        this.handlers.put("*", new RollHandler(false));
        this.handlers.put("[", new PushTurtleHandler());
        this.handlers.put("]", new PopTurtleHandler());
        this.handlers.put("!", new WidthChangeHandler(true));
        this.handlers.put("~", new WidthChangeHandler(false));
        this.handlers.put("{", new BeginPolygonHandler());
        this.handlers.put("}", new ClosePolygonHandler());
        this.handlers.put("%", new ReverseHandler());
        this.handlers.put("#", new HueChangeHandler(false, true));
        this.handlers.put("@", new HueChangeHandler(false, false));
        this.handlers.put("##", new HueChangeHandler(true, true));
        this.handlers.put("@@", new HueChangeHandler(true, false));
        this.handlers.put("color", new DrawColorHandler());
        this.handlers.put("polygonColor", new PolygonColorHandler());
        AngleIncrementHandler angleIncrement = new AngleIncrementHandler();
        this.handlers.put("angle", angleIncrement);
        this.handlers.put("angleIncrement", angleIncrement);
        this.handlers.put("lineWidth", new LineWidthHandler());
        this.handlers.put("lineIncrement", new LineWidthIncrementHandler());
        this.handlers.put("distance", new DistanceHandler());
        this.handlers.put("hueChange", new HueAngleIncrementHandler());
    }

    public CommandHandler getHandler(String symbol) {
        if (this.handlers.containsKey(symbol)) {
            return (CommandHandler)this.handlers.get(symbol);
        }
        return null;
    }

    public int getDoneSymbols() {
        return this.completedSymbols;
    }

    public void assign(String key, String value) {
        try {
            try {
                if (!NONASSIGN_WORDS.contains(key)) {
                    this.currentTurtle.assign(key, value);
                    value = this.currentTurtle.get(key).toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CommandHandler handler = this.getHandler(key);
            handler.handle(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Image render(List symbols, Map parameters, Matrix matrix, Graphics2D graphics, Point2D origin) {
        BufferedImage image = null;
        Rectangle2D bounds = new Rectangle2D.Double();
        if (graphics != null && graphics.getClip() == null) {
            throw new IllegalArgumentException("Graphics needs a non-null clip!");
        }
        if (matrix == null) {
            matrix = new Matrix();
        }
        this.totalSymbols = symbols.size() * 2;
        this.completedSymbols = 0;
        this.isActive = true;
        int i = 0;
        while (i < 2) {
            this.areDrawing = i == 1;
            this.drawnSofar = 0;
            this.turtleStack.clear();
            this.currentTurtle = new Turtle();
            this.currentTurtle.matrix = matrix;
            this.currentTurtle = new Turtle(this.currentTurtle);
            if (!this.areDrawing || graphics == null) {
                image = new BufferedImage((int)((RectangularShape)bounds).getWidth() + 10, (int)((RectangularShape)bounds).getHeight() + 10, 2);
                this.g = image.createGraphics();
                if (this.areDrawing) {
                    this.g.translate(-((RectangularShape)bounds).getX() + 5.0, -((RectangularShape)bounds).getY() + 5.0);
                    origin.setLocation(5.0 - ((RectangularShape)bounds).getX(), 5.0 - ((RectangularShape)bounds).getY());
                    this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            } else {
                double vRatio;
                image = null;
                this.g = (Graphics2D)graphics.create();
                Rectangle2D.Double newBounds = new Rectangle2D.Double(((RectangularShape)bounds).getX() - 5.0, ((RectangularShape)bounds).getY() - 5.0, ((RectangularShape)bounds).getWidth() + 10.0, ((RectangularShape)bounds).getHeight() + 10.0);
                Rectangle ourBounds = this.g.getClipBounds();
                double aRatio = ((RectangularShape)newBounds).getWidth() / ((RectangularShape)newBounds).getHeight();
                if (aRatio > (vRatio = ((RectangularShape)ourBounds).getWidth() / ((RectangularShape)ourBounds).getHeight())) {
                    double targetHeight = ((RectangularShape)newBounds).getWidth() / vRatio;
                    ((Rectangle2D)newBounds).setRect(((RectangularShape)newBounds).getX(), ((RectangularShape)newBounds).getY() - (targetHeight -= ((RectangularShape)newBounds).getHeight()) / 2.0, ((RectangularShape)newBounds).getWidth(), ((RectangularShape)newBounds).getHeight() + targetHeight);
                } else {
                    double targetWidth = ((RectangularShape)newBounds).getHeight() * vRatio;
                    ((Rectangle2D)newBounds).setRect(((RectangularShape)newBounds).getX() - (targetWidth -= ((RectangularShape)newBounds).getWidth()) / 2.0, ((RectangularShape)newBounds).getY(), ((RectangularShape)newBounds).getWidth() + targetWidth, ((RectangularShape)newBounds).getHeight());
                }
                double scale = ((RectangularShape)ourBounds).getWidth() / ((RectangularShape)newBounds).getWidth();
                this.g.scale(scale, scale);
                this.g.translate(((RectangularShape)ourBounds).getX() - ((RectangularShape)newBounds).getX(), ((RectangularShape)ourBounds).getY() - ((RectangularShape)newBounds).getY());
                origin.setLocation(((RectangularShape)ourBounds).getX() - ((RectangularShape)newBounds).getX(), ((RectangularShape)ourBounds).getY() - ((RectangularShape)newBounds).getY());
            }
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                try {
                    this.assign((String)entry.getKey(), (String)entry.getValue());
                }
                catch (Throwable aRatio) {
                    // empty catch block
                }
            }
            this.g.setColor(this.currentTurtle.getColor());
            this.capLinePath();
            it = symbols.iterator();
            while (it.hasNext()) {
                ++this.completedSymbols;
                String symbol = (String)((Object)it.next());
                CommandHandler handler = this.getHandler(symbol);
                if (handler != null) {
                    try {
                        handler.handle(null);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                int equalsPosition = symbol.indexOf(61);
                if (equalsPosition != -1) {
                    String key = symbol.substring(0, equalsPosition);
                    String value = symbol.substring(equalsPosition + 1);
                    this.assign(key, value);
                }
                int leftParenPosition = symbol.indexOf(40);
                int rightParenPosition = symbol.lastIndexOf(41);
                if (leftParenPosition == -1 || rightParenPosition == -1 || leftParenPosition >= rightParenPosition) continue;
                String key = symbol.substring(0, leftParenPosition);
                String value = symbol.substring(leftParenPosition + 1, rightParenPosition);
                handler = this.getHandler(key);
                try {
                    handler.handle(value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.capLinePath();
            this.g.dispose();
            while (!this.turtleStack.isEmpty()) {
                this.popTurtleStack();
            }
            bounds = this.currentTurtle.getBounds();
            ++i;
        }
        this.isActive = false;
        this.areDrawing = false;
        return image;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void popTurtleStack() {
        try {
            Turtle lt = (Turtle)this.turtleStack.pop();
            lt.updateBounds(this.currentTurtle);
            this.currentTurtle = lt;
            this.g.setColor(this.currentTurtle.getColor());
            this.g.setStroke(this.currentTurtle.getStroke());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private final void capLinePath() {
        this.g.draw(this.linePath);
        this.linePath.reset();
        this.linePath.moveTo((float)this.currentTurtle.position.getX(), (float)this.currentTurtle.position.getY());
    }

    protected class CommandHandler {
        protected CommandHandler() {
        }

        public void handle(String symbol) {
        }
    }

    private class MoveHandler
    extends CommandHandler {
        private boolean pendown;
        private boolean forward;
        private Line2D line = new Line2D.Double();

        public MoveHandler(boolean pendown, boolean forward) {
            this.pendown = pendown;
            this.forward = forward;
        }

        public final void handle(String symbol) {
            if (symbol == null) {
                Renderer.this.currentTurtle.go(this.forward);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(symbol).doubleValue();
                Renderer.this.currentTurtle.go(this.forward ? d : -d);
            }
            if (!Renderer.this.areDrawing) {
                return;
            }
            if (this.pendown) {
                if (Renderer.this.polygon == null) {
                    Renderer.this.linePath.lineTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
                } else {
                    Renderer.this.polygon.lineTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
                }
            } else {
                Renderer.this.linePath.moveTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
            }
        }
    }

    private class TurnHandler
    extends CommandHandler {
        private boolean clockwise;

        public TurnHandler(boolean clockwise) {
            this.clockwise = clockwise;
        }

        public final void handle(String symbol) {
            if (symbol == null) {
                Renderer.this.currentTurtle.turn(this.clockwise);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(symbol).doubleValue();
                Renderer.this.currentTurtle.turn(this.clockwise ? -d : d);
            }
        }
    }

    private class PitchHandler
    extends CommandHandler {
        private boolean down;

        public PitchHandler(boolean down) {
            this.down = down;
        }

        public final void handle(String symbol) {
            if (symbol == null) {
                Renderer.this.currentTurtle.pitch(this.down);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(symbol).doubleValue();
                Renderer.this.currentTurtle.pitch(this.down ? d : -d);
            }
        }
    }

    private class RollHandler
    extends CommandHandler {
        private boolean right;

        public RollHandler(boolean right) {
            this.right = right;
        }

        public final void handle(String symbol) {
            if (symbol == null) {
                Renderer.this.currentTurtle.roll(this.right);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(symbol).doubleValue();
                Renderer.this.currentTurtle.roll(this.right ? -d : d);
            }
        }
    }

    private class PushTurtleHandler
    extends CommandHandler {
        private PushTurtleHandler() {
        }

        public final void handle(String symbol) {
            Renderer.this.turtleStack.push(Renderer.this.currentTurtle.clone());
        }
    }

    private class PopTurtleHandler
    extends CommandHandler {
        private PopTurtleHandler() {
        }

        public final void handle(String symbol) {
            Renderer.this.capLinePath();
            Renderer.this.popTurtleStack();
            Renderer.this.capLinePath();
        }
    }

    private class WidthChangeHandler
    extends CommandHandler {
        private boolean increment;

        public WidthChangeHandler(boolean increment) {
            this.increment = increment;
        }

        public final void handle(String symbol) {
            Renderer.this.capLinePath();
            if (symbol == null) {
                Renderer.this.currentTurtle.changeLineWidth(this.increment);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(symbol).doubleValue();
                Renderer.this.currentTurtle.changeLineWidth(this.increment ? d : -d);
            }
            Renderer.this.g.setStroke(Renderer.this.currentTurtle.getStroke());
        }
    }

    private class DrawColorHandler
    extends CommandHandler {
        private DrawColorHandler() {
        }

        public final void handle(String symbol) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.currentTurtle.setColor(symbol);
            Renderer.this.g.setColor(Renderer.this.currentTurtle.getColor());
        }
    }

    private class PolygonColorHandler
    extends CommandHandler {
        private PolygonColorHandler() {
        }

        public final void handle(String symbol) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.currentTurtle.setPolygonColor(symbol);
        }
    }

    private class AngleIncrementHandler
    extends CommandHandler {
        private AngleIncrementHandler() {
        }

        public final void handle(String symbol) {
            Renderer.this.currentTurtle.setAngleChange(Double.parseDouble(symbol));
        }
    }

    private class LineWidthHandler
    extends CommandHandler {
        private LineWidthHandler() {
        }

        public final void handle(String symbol) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.currentTurtle.setLineWidth(Double.parseDouble(symbol));
            Renderer.this.g.setStroke(Renderer.this.currentTurtle.getStroke());
        }
    }

    private class LineWidthIncrementHandler
    extends CommandHandler {
        private LineWidthIncrementHandler() {
        }

        public final void handle(String symbol) {
            Renderer.this.currentTurtle.setLineIncrement(Double.parseDouble(symbol));
        }
    }

    private class DistanceHandler
    extends CommandHandler {
        private DistanceHandler() {
        }

        public final void handle(String symbol) {
            ((Renderer)Renderer.this).currentTurtle.distance = Double.parseDouble(symbol);
        }
    }

    private class BeginPolygonHandler
    extends CommandHandler {
        private BeginPolygonHandler() {
        }

        public final void handle(String symbol) {
            if (!Renderer.this.areDrawing || Renderer.this.polygon != null) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.polygon = new GeneralPath();
            Renderer.this.polygon.moveTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
        }
    }

    private class ClosePolygonHandler
    extends CommandHandler {
        private ClosePolygonHandler() {
        }

        public final void handle(String symbol) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.polygon.closePath();
            Renderer.this.g.setColor(((Renderer)Renderer.this).currentTurtle.polygonColor);
            Renderer.this.g.fill(Renderer.this.polygon);
            Renderer.this.polygon = null;
            Renderer.this.g.setColor(((Renderer)Renderer.this).currentTurtle.color);
            Renderer renderer = Renderer.this;
            renderer.drawnSofar = renderer.drawnSofar + 1;
        }
    }

    private class ReverseHandler
    extends CommandHandler {
        private ReverseHandler() {
        }

        public final void handle(String symbol) {
            Renderer.this.currentTurtle.turn(180.0);
        }
    }

    private class HueAngleIncrementHandler
    extends CommandHandler {
        private HueAngleIncrementHandler() {
        }

        public final void handle(String symbol) {
            Renderer.this.currentTurtle.setHueChange(Double.parseDouble(symbol));
        }
    }

    private class HueChangeHandler
    extends CommandHandler {
        private boolean add;
        private boolean polygon;

        public HueChangeHandler(boolean polygon, boolean add) {
            this.polygon = polygon;
            this.add = add;
        }

        public final void handle(String symbol) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            if (symbol == null) {
                if (this.polygon) {
                    Renderer.this.currentTurtle.changePolygonHue(this.add);
                } else {
                    Renderer.this.currentTurtle.changeHue(this.add);
                }
            } else {
                double d = Renderer.this.currentTurtle.valueOf(symbol).doubleValue();
                double d2 = d = this.add ? d : -d;
                if (this.polygon) {
                    Renderer.this.currentTurtle.changePolygonHue(d);
                } else {
                    Renderer.this.currentTurtle.changeHue(d);
                }
            }
            Renderer.this.g.setColor(Renderer.this.currentTurtle.getColor());
        }
    }
}

