/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import gui.transform.Matrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

class Turtle
implements Cloneable,
Serializable {
    public double distance = 15.0;
    public final Point2D position = new Point2D.Double(0.0, 0.0){

        public void setLocation(double x, double y) {
            Turtle.this.oldPosition.setLocation(this);
            super.setLocation(x, y);
            Turtle.this.updateBounds();
        }
    };
    public final Point2D oldPosition = new Point2D.Double();
    public Rectangle2D bounds = null;
    public double lineWidth = 1.0;
    public double incrementWidth = 1.0;
    private Stroke stroke = null;
    public Color color = Color.black;
    public Color polygonColor = Color.red;
    public double hueChange = 10.0;
    public double angleChange = 15.0;
    public Map parametersToNumbers;
    public Matrix matrix = new Matrix();
    public static Map COLORS;
    static /* synthetic */ Class class$0;

    static {
        HashMap<String, Color> m = new HashMap<String, Color>();
        m.put("dukeBlue", new Color(0, 0, 156));
        m.put("brown", new Color(129, 0, 0));
        m.put("oliveDrab", new Color(114, 93, 0));
        m.put("darkOliveGreen", new Color(109, 111, 0));
        m.put("orangeRed", new Color(252, 118, 0));
        m.put("maroon", new Color(190, 0, 0));
        m.put("forestGreen", new Color(0, 127, 0));
        m.put("purple", new Color(209, 0, 255));
        m.put("springGreen", new Color(193, 255, 157));
        m.put("violetRed", new Color(210, 0, 205));
        m.put("goldenrod", new Color(255, 214, 0));
        m.put("darkOliveGreen2", new Color(10, 127, 0));
        COLORS = Collections.unmodifiableMap(m);
    }

    public Turtle() {
        this.parametersToNumbers = new HashMap();
        this.setDistance(15.0);
        this.setAngleChange(15.0);
        this.setHueChange(10.0);
        this.setLineWidth(1.0);
        this.setLineIncrement(1.0);
        this.updateBounds();
    }

    public Turtle(Turtle turtle) {
        this.matrix = new Matrix(turtle.matrix);
        this.distance = turtle.distance;
        this.bounds = null;
        this.matrix.origin(this.position);
        this.lineWidth = turtle.lineWidth;
        this.incrementWidth = turtle.incrementWidth;
        this.color = turtle.color;
        this.polygonColor = turtle.polygonColor;
        this.hueChange = turtle.hueChange;
        this.angleChange = turtle.angleChange;
        this.parametersToNumbers = new HashMap(turtle.parametersToNumbers);
    }

    private final void updateBounds() {
        try {
            this.bounds.add(this.position);
        }
        catch (NullPointerException e) {
            this.bounds = new Rectangle2D.Double(this.position.getX(), this.position.getY(), 0.0, 0.0);
        }
    }

    public final Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.updateBounds();
        }
        return this.bounds;
    }

    public final void updateBounds(Turtle turtle) {
        this.bounds.add(turtle.bounds);
    }

    public Object clone() {
        return new Turtle(this);
    }

    public final void turn(boolean clockwise) {
        this.turn(clockwise ? -this.angleChange : this.angleChange);
    }

    public final void turn(double degrees) {
        this.matrix.yaw(degrees);
    }

    public final void pitch(boolean down) {
        this.pitch(down ? this.angleChange : -this.angleChange);
    }

    public final void pitch(double degrees) {
        this.matrix.pitch(degrees);
    }

    public final void roll(boolean right) {
        this.roll(right ? -this.angleChange : this.angleChange);
    }

    public final void roll(double degrees) {
        this.matrix.roll(degrees);
    }

    public final double getAngleChange() {
        return this.angleChange;
    }

    public final void setAngleChange(double change) {
        this.angleChange = Math.IEEEremainder(change, 360.0);
        this.parametersToNumbers.put("angle", new Double(change));
    }

    public final void setDistance(double distance) {
        this.distance = distance;
        this.parametersToNumbers.put("distance", new Double(distance));
    }

    public final void go(double distance) {
        this.matrix.translate(0.0, -distance, 0.0);
        this.matrix.origin(this.position);
    }

    public final void go(boolean forward) {
        this.go(forward ? this.distance : -this.distance);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Color colorForString(String colorName) {
        try {
            Class<?> clazz;
            Class<?> clazz2 = class$0;
            Class<?> clazz3 = clazz2;
            if (clazz2 != null) return (Color)clazz3.getField(colorName).get(null);
            try {
                clazz = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$0 = clazz;
            return (Color)clazz3.getField(colorName).get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Color c = (Color)COLORS.get(colorName);
        if (c != null) {
            return c;
        }
        try {
            StringTokenizer st = new StringTokenizer(colorName, ",");
            float c1 = Float.parseFloat(st.nextToken());
            float c2 = Float.parseFloat(st.nextToken());
            float c3 = Float.parseFloat(st.nextToken());
            if (c1 < 0.0f) return null;
            if (c1 > 255.0f) return null;
            if (c2 < 0.0f) return null;
            if (c2 > 255.0f) return null;
            if (c3 < 0.0f) return null;
            if (c3 > 255.0f) {
                return null;
            }
            if (!(c1 <= 1.0f)) return new Color((int)c1, (int)c2, (int)c3);
            if (!(c2 <= 1.0f)) return new Color((int)c1, (int)c2, (int)c3);
            if (!(c3 <= 1.0f)) return new Color((int)c1, (int)c2, (int)c3);
            return Color.getHSBColor(c1, c2, c3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final void setColor(String colorName) {
        Color c = Turtle.colorForString(colorName);
        if (c == null) {
            throw new IllegalArgumentException("No color named " + colorName + " found!");
        }
        this.setColor(c);
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setPolygonColor(String colorName) {
        Color c = Turtle.colorForString(colorName);
        if (c == null) {
            throw new IllegalArgumentException("No color named " + colorName + " found!");
        }
        this.setPolygonColor(c);
    }

    public final void setPolygonColor(Color color) {
        this.polygonColor = color;
    }

    public final Color getPolygonColor() {
        return this.polygonColor;
    }

    public void setHueChange(double change) {
        this.hueChange = Math.IEEEremainder(change, 360.0);
        this.parametersToNumbers.put("hueChange", new Double(change));
    }

    public void changeHue(boolean increment) {
        this.changeHue(increment ? this.hueChange : -this.hueChange);
    }

    public void changeHue(double change) {
        float[] hsbvals = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        hsbvals[0] = hsbvals[0] + (float)change / 360.0f;
        this.setColor(Color.getHSBColor(hsbvals[0], hsbvals[1], hsbvals[2]));
    }

    public void changePolygonHue(boolean increment) {
        this.changePolygonHue(increment ? this.hueChange : -this.hueChange);
    }

    public void changePolygonHue(double change) {
        float[] hsbvals = Color.RGBtoHSB(this.polygonColor.getRed(), this.polygonColor.getGreen(), this.polygonColor.getBlue(), null);
        hsbvals[0] = hsbvals[0] + (float)change / 360.0f;
        this.setPolygonColor(Color.getHSBColor(hsbvals[0], hsbvals[1], hsbvals[2]));
    }

    public final void setLineIncrement(double increment) {
        this.incrementWidth = increment;
        this.parametersToNumbers.put("lineIncrement", new Double(increment));
    }

    public final void changeLineWidth(boolean broaden) {
        this.changeLineWidth(broaden ? this.incrementWidth : -this.incrementWidth);
    }

    public final void changeLineWidth(double increment) {
        this.setLineWidth(this.lineWidth + increment);
        this.stroke = null;
    }

    public final void setLineWidth(double width) {
        this.lineWidth = width;
        this.parametersToNumbers.put("lineWidth", new Double(width));
        this.stroke = null;
    }

    public final double getLineWidth() {
        return this.lineWidth;
    }

    public final Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke((float)Math.max(0.0, this.getLineWidth()));
        }
        return this.stroke;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ " + super.toString());
        sb.append(", distance=" + this.distance);
        sb.append(", position=(" + this.position.getX() + "," + this.position.getY() + ")");
        sb.append(", lineWidth=" + this.lineWidth);
        sb.append(", incrementWidth=" + this.incrementWidth);
        sb.append(", angleChange=" + this.angleChange);
        sb.append(", color=" + this.color);
        sb.append(", polygonColor=" + this.polygonColor);
        sb.append(" }");
        return sb.toString();
    }

    public Number valueOf(String string) {
        return Turtle.valueOf(string, this.parametersToNumbers);
    }

    private static Number valueOf(String string, Map values) {
        string = string.replaceAll("-", " -");
        StringReader reader = new StringReader(string);
        StreamTokenizer st = new StreamTokenizer(reader);
        st.ordinaryChar(47);
        ArrayList<Comparable<Character>> list = new ArrayList<Comparable<Character>>();
        Integer zero = new Integer(0);
        boolean number = false;
        Character plus = new Character('+');
        try {
            while (st.nextToken() != -1) {
                switch (st.ttype) {
                    case -3: {
                        Number n = (Number)values.get(st.sval);
                        if (number) {
                            list.add(plus);
                        }
                        number = true;
                        list.add((Comparable<Character>)((Object)(n == null ? (Number)zero : (Number)n)));
                        break;
                    }
                    case -2: {
                        if (number) {
                            list.add(plus);
                        }
                        number = true;
                        list.add(new Double(st.nval));
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        number = false;
                        list.add(new Character((char)st.ttype));
                    }
                }
            }
        }
        catch (IOException e) {
            return new Double(Double.NaN);
        }
        Iterator it = list.iterator();
        return Turtle.valueOf(it);
    }

    /*
     * Unable to fully structure code
     */
    private static Number valueOf(Iterator it) {
        values = new Stack<Number>();
        operators = new Stack<Character>();
        values.push(new Double(0.0));
        while (it.hasNext()) {
            o = it.next();
            if (o instanceof Number) {
                values.push((Number)o);
                continue;
            }
            character = (Character)o;
            c = character.charValue();
            if (c == ')') break;
            if (c != '(') ** GOTO lbl55
            values.push(Turtle.valueOf(it));
            continue;
lbl-1000:
            // 1 sources

            {
                toCollapse = false;
                last = ((Character)operators.peek()).charValue();
                switch (c) {
                    case '+': 
                    case '-': {
                        if (last == '-' || last == '+') {
                            toCollapse = true;
                        }
                    }
                    case '*': 
                    case '/': {
                        if (last == '*' || last == '/') {
                            toCollapse = true;
                        }
                    }
                    case '^': {
                        if (last != '^') break;
                        toCollapse = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad operator " + c);
                    }
                }
                if (!toCollapse) break;
                b = ((Number)values.pop()).doubleValue();
                a = ((Number)values.pop()).doubleValue();
                operators.pop();
                switch (last) {
                    case '^': {
                        a = Math.pow(a, b);
                        break;
                    }
                    case '*': {
                        a *= b;
                        break;
                    }
                    case '/': {
                        a /= b;
                        break;
                    }
                    case '+': {
                        a += b;
                        break;
                    }
                    case '-': {
                        a -= b;
                    }
                }
                values.push(new Double(a));
lbl55:
                // 2 sources

                ** while (!operators.isEmpty())
            }
lbl56:
            // 2 sources

            operators.push(character);
        }
        while (!operators.isEmpty()) {
            last = ((Character)operators.pop()).charValue();
            b = ((Number)values.pop()).doubleValue();
            a = ((Number)values.pop()).doubleValue();
            switch (last) {
                case '^': {
                    a = Math.pow(a, b);
                    break;
                }
                case '*': {
                    a *= b;
                    break;
                }
                case '/': {
                    a /= b;
                    break;
                }
                case '+': {
                    a += b;
                    break;
                }
                case '-': {
                    a -= b;
                }
            }
            values.push(new Double(a));
        }
        return (Number)values.pop();
    }

    public void assign(String parameter, String expression) {
        this.parametersToNumbers.put(parameter, this.valueOf(expression));
    }

    public Number get(String parameter) {
        return (Number)this.parametersToNumbers.get(parameter);
    }
}

