/*
 * Decompiled with CFR 0.152.
 */
package gui.menu;

import automata.Automaton;
import automata.fsa.FiniteStateAutomaton;
import gui.action.AboutAction;
import gui.action.BruteParseAction;
import gui.action.BuildingBlockSimulateAction;
import gui.action.CloseAction;
import gui.action.CloseButton;
import gui.action.CloseWindowAction;
import gui.action.CombineAutomaton;
import gui.action.ConvertCFGLL;
import gui.action.ConvertCFGLR;
import gui.action.ConvertFSAToGrammarAction;
import gui.action.ConvertFSAToREAction;
import gui.action.ConvertPDAToGrammarAction;
import gui.action.ConvertRegularGrammarToFSA;
import gui.action.DFAEqualityAction;
import gui.action.EnvironmentHelpAction;
import gui.action.GrammarTransformAction;
import gui.action.LLParseTableAction;
import gui.action.LRParseTableAction;
import gui.action.LSystemDisplay;
import gui.action.LambdaHighlightAction;
import gui.action.MinimizeTreeAction;
import gui.action.MultipleBruteParseAction;
import gui.action.MultipleOutputSimulateAction;
import gui.action.MultipleSimulateAction;
import gui.action.NFAToDFAAction;
import gui.action.NewAction;
import gui.action.NoInteractionSimulateAction;
import gui.action.NondeterminismAction;
import gui.action.OpenAction;
import gui.action.OpenURLAction;
import gui.action.PrintAction;
import gui.action.QuitAction;
import gui.action.REToFSAAction;
import gui.action.SaveAction;
import gui.action.SaveAsAction;
import gui.action.SimulateAction;
import gui.action.SimulateNoClosureAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.LSystemEnvironment;
import gui.environment.RegularEnvironment;
import gui.environment.Universe;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBarCreator {
    public static JMenuBar getMenuBar(EnvironmentFrame frame) {
        JMenuBar bar = new JMenuBar();
        JMenu menu = MenuBarCreator.getFileMenu(frame);
        if (menu.getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getInputMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getTestMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getConvertMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getHelpMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        CloseButton dismiss = new CloseButton(frame.getEnvironment());
        bar.add(Box.createGlue());
        bar.add(dismiss);
        return bar;
    }

    public static void addItem(JMenu menu, Action a) {
        JMenuItem item = new JMenuItem(a);
        item.setAccelerator((KeyStroke)a.getValue("AcceleratorKey"));
        menu.add(item);
    }

    private static JMenu getFileMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("File");
        MenuBarCreator.addItem(menu, new NewAction());
        SecurityManager sm = System.getSecurityManager();
        if (Universe.CHOOSER != null) {
            MenuBarCreator.addItem(menu, new OpenAction());
            MenuBarCreator.addItem(menu, new SaveAction(environment));
            MenuBarCreator.addItem(menu, new SaveAsAction(environment));
        } else {
            MenuBarCreator.addItem(menu, new OpenURLAction());
        }
        MenuBarCreator.addItem(menu, new CloseAction(environment));
        MenuBarCreator.addItem(menu, new CloseWindowAction(frame));
        try {
            if (sm != null) {
                sm.checkPrintJobAccess();
            }
            MenuBarCreator.addItem(menu, new PrintAction(environment));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (sm != null) {
                sm.checkExit(0);
            }
            MenuBarCreator.addItem(menu, new QuitAction());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return menu;
    }

    private static JMenu getInputMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Input");
        Serializable object = environment.getObject();
        if (SimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new SimulateAction((Automaton)object, environment));
        }
        if (BuildingBlockSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new BuildingBlockSimulateAction((Automaton)object, environment));
        }
        if (SimulateNoClosureAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new SimulateNoClosureAction((Automaton)object, environment));
        }
        if (NoInteractionSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new NoInteractionSimulateAction((Automaton)object, environment));
        }
        if (MultipleSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleSimulateAction((Automaton)object, environment));
        }
        if (MultipleOutputSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleOutputSimulateAction((Automaton)object, environment));
        }
        if (LLParseTableAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LLParseTableAction((GrammarEnvironment)environment));
        }
        if (LRParseTableAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LRParseTableAction((GrammarEnvironment)environment));
        }
        if (BruteParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new BruteParseAction((GrammarEnvironment)environment));
        }
        if (MultipleBruteParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleBruteParseAction((GrammarEnvironment)environment));
        }
        if (LSystemDisplay.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LSystemDisplay((LSystemEnvironment)environment));
        }
        return menu;
    }

    private static JMenu getTestMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Test");
        Serializable object = environment.getObject();
        if (DFAEqualityAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new DFAEqualityAction((FiniteStateAutomaton)object, environment));
        }
        if (NondeterminismAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new NondeterminismAction((Automaton)object, environment));
        }
        if (LambdaHighlightAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LambdaHighlightAction((Automaton)object, environment));
        }
        return menu;
    }

    private static JMenu getConvertMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Convert");
        Serializable object = environment.getObject();
        if (NFAToDFAAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new NFAToDFAAction((FiniteStateAutomaton)object, environment));
        }
        if (MinimizeTreeAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MinimizeTreeAction((FiniteStateAutomaton)object, environment));
        }
        if (ConvertFSAToGrammarAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertFSAToGrammarAction((AutomatonEnvironment)environment));
        }
        if (ConvertPDAToGrammarAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertPDAToGrammarAction((AutomatonEnvironment)environment));
        }
        if (ConvertFSAToREAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertFSAToREAction((AutomatonEnvironment)environment));
        }
        if (ConvertCFGLL.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertCFGLL((GrammarEnvironment)environment));
        }
        if (ConvertCFGLR.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertCFGLR((GrammarEnvironment)environment));
        }
        if (ConvertRegularGrammarToFSA.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertRegularGrammarToFSA((GrammarEnvironment)environment));
        }
        if (GrammarTransformAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new GrammarTransformAction((GrammarEnvironment)environment));
        }
        if (REToFSAAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new REToFSAAction((RegularEnvironment)environment));
        }
        if (CombineAutomaton.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new CombineAutomaton((AutomatonEnvironment)environment));
        }
        return menu;
    }

    private static JMenu getHelpMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Help");
        Serializable object = environment.getObject();
        MenuBarCreator.addItem(menu, new EnvironmentHelpAction(environment));
        MenuBarCreator.addItem(menu, new AboutAction());
        return menu;
    }
}

