/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.fsa.MinimizeTreeNode;
import gui.tree.DefaultNodeDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.tree.TreeNode;

public class MinimizeNodeDrawer
extends DefaultNodeDrawer {
    private HashMap labels = new HashMap();

    public void draw(Graphics2D g, TreeNode node) {
        g.fill(NODE_SHAPE);
        Color c = g.getColor();
        g.setColor(Color.black);
        g.draw(NODE_SHAPE);
        MinimizeTreeNode m = (MinimizeTreeNode)node;
        g.setColor(c);
        this.drawBox(g, MinimizeNodeDrawer.getStateString(m), new Point2D.Float(0.0f, 0.0f));
        g.setColor(c);
        this.drawBox(g, m.getTerminal(), new Point2D.Float(0.0f, 20.0f));
        g.setColor(c);
        String label = this.getLabel(node);
        if (label == null) {
            return;
        }
        this.drawBox(g, label, new Point2D.Float(0.0f, -20.0f));
        g.setColor(c);
    }

    private static String getStateString(MinimizeTreeNode node) {
        State[] states = (State[])node.getUserObject();
        int[] ids = new int[states.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = states[i].getID();
            ++i;
        }
        Arrays.sort(ids);
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < ids.length) {
            if (i2 != 0) {
                buffer.append(", ");
            }
            buffer.append(ids[i2]);
            ++i2;
        }
        return buffer.toString();
    }

    public void setLabel(TreeNode node, String label) {
        if (label == null) {
            this.labels.remove(node);
        } else {
            this.labels.put(node, label);
        }
    }

    public String getLabel(TreeNode node) {
        return (String)this.labels.get(node);
    }

    private void drawBox(Graphics2D g, String string, Point2D point) {
        if (string.equals("")) {
            return;
        }
        Rectangle2D rect = g.getFontMetrics().getStringBounds(string, g);
        double x = point.getX() - rect.getWidth() / 2.0;
        double y = point.getY() - rect.getY() - rect.getHeight() / 2.0;
        g.fillRect((int)x - 2, (int)(y + rect.getY()) - 2, (int)rect.getWidth() + 4, (int)rect.getHeight() + 4);
        g.setColor(Color.black);
        g.drawRect((int)x - 2, (int)(y + rect.getY()) - 2, (int)rect.getWidth() + 4, (int)rect.getHeight() + 4);
        g.drawString(string, (float)x, (float)y);
    }
}

