/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.SliderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import pumping.ContextFreePumpingLemma;

public class CFPumpingLemmaInputPane
extends PumpingLemmaInputPane {
    private static String I_WIN = "I WIN. Do you want to play again or concede that the language is not context-free?";
    private static String YOU_WIN = "YOU WIN. Does this mean the language is context-free?";
    private SliderPanel myUPanel;
    private SliderPanel myVPanel;
    private SliderPanel myXPanel;
    private SliderPanel myYPanel;
    private JButton myButton;
    private JTextArea myZDisplay;
    private JTextArea myZLength;

    public CFPumpingLemmaInputPane(ContextFreePumpingLemma l) {
        super(l, "<i>L</i> = {" + l.getHTMLTitle() + "} Context-Free Pumping Lemma");
    }

    public void setDecomposition(int[] decomposition) {
        int u = decomposition[0];
        int v = decomposition[1];
        int x = decomposition[2];
        int y = decomposition[3];
        this.myUPanel.setVal(u);
        this.myVPanel.setVal(u + v);
        this.myXPanel.setVal(u + v + x);
        this.myYPanel.setVal(u + v + x + y);
        this.myLemma.chooseDecomposition(decomposition);
    }

    public void setDecomposition(int[] decomposition, int num) {
        this.setDecomposition(decomposition);
        this.myLemma.chooseDecomposition(decomposition, num);
    }

    protected JPanel initChooser() {
        JPanel n = new JPanel(new BorderLayout());
        JPanel o = new JPanel();
        o.setLayout(new BoxLayout(o, 0));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.myUPanel = new SliderPanel("u", this);
        p.add(this.myUPanel);
        this.myVPanel = new SliderPanel("v", this);
        p.add(this.myVPanel);
        this.myXPanel = new SliderPanel("x", this);
        p.add(this.myXPanel);
        this.myYPanel = new SliderPanel("y", this);
        p.add(this.myYPanel);
        JPanel m = new JPanel();
        m.setLayout(new BoxLayout(m, 0));
        m.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 7));
        m.add(new JLabel("z: "));
        this.myZDisplay = new JTextArea(1, 30);
        this.myZDisplay.setEditable(false);
        m.add(this.myZDisplay);
        m.add(new JLabel("    |z|: "));
        this.myZLength = new JTextArea(1, 5);
        this.myZLength.setEditable(false);
        m.add(this.myZLength);
        p.add(m);
        this.myXYZPanel = new JPanel(new BorderLayout());
        this.myXYZDisplay = new JTable(1, 1);
        this.myXYZDisplay.setEnabled(false);
        this.myXYZPanel.add(this.myXYZDisplay);
        this.myXYZPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 7));
        p.add((Component)this.myXYZPanel, "South");
        o.add(p);
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 1));
        this.myButton = new JButton("Set uvxyz");
        this.myButton.setEnabled(false);
        this.myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CFPumpingLemmaInputPane.this.setI();
                CFPumpingLemmaInputPane.this.displayI();
                CFPumpingLemmaInputPane.this.setCanvas();
                CFPumpingLemmaInputPane.this.myCanvas.stop();
                CFPumpingLemmaInputPane.this.setDescription(DESCRIBE_I);
                if (CFPumpingLemmaInputPane.this.myCases != null) {
                    CFPumpingLemmaInputPane.this.myCases.setAddButtonEnabled(true);
                    CFPumpingLemmaInputPane.this.setInstruction(PROMPT_CASE);
                } else {
                    CFPumpingLemmaInputPane.this.setInstruction(PROMPT_ANIM);
                }
                CFPumpingLemmaInputPane.this.promptWinner();
            }
        });
        q.add(this.myButton);
        o.add(q);
        n.add((Component)o, "North");
        n.setBorder(BorderFactory.createTitledBorder("3. Select decomposition of w into uvxyz"));
        n.setMaximumSize(new Dimension(640, 480));
        return n;
    }

    protected void mEnteredReset() {
        String s = this.myLemma.getW();
        this.myWDisplay.setText(s);
        this.myUPanel.setSliderMax(s.length());
        this.myUPanel.setText(s);
        this.myUPanel.setVal(0);
        this.myVPanel.setSliderMax(s.length());
        this.myVPanel.setText(s);
        this.myVPanel.setVal(0);
        this.myXPanel.setSliderMax(s.length());
        this.myXPanel.setText(s);
        this.myXPanel.setVal(0);
        this.myYPanel.setSliderMax(s.length());
        this.myYPanel.setText(s);
        this.myYPanel.setVal(0);
        this.refresh();
        this.updateTable();
    }

    protected void refresh() {
        try {
            this.myUPanel.setRange(0, this.myVPanel.getVal());
            this.myVPanel.setRange(this.myUPanel.getVal(), this.myXPanel.getVal());
            this.myXPanel.setRange(this.myVPanel.getVal(), this.myYPanel.getVal());
            this.myYPanel.setRange(this.myXPanel.getVal(), this.myLemma.getW().length());
            this.myZDisplay.setText(this.myLemma.getW().substring(this.myYPanel.getVal()));
            this.myZLength.setText(Integer.toString(this.myZDisplay.getText().length()));
            this.myIDisplay.setText("");
            this.myPumpedStringDisplay.setText("");
            this.myLastWord.setText("");
            this.myCanvas.reset();
            if (this.myUPanel.getVal() > this.myVPanel.getVal()) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |v| >= 0");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else if (this.myVPanel.getVal() > this.myXPanel.getVal()) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |x| >= 0");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else if (this.myXPanel.getVal() > this.myYPanel.getVal()) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |y| >= 0");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else if (this.myYPanel.getVal() - this.myUPanel.getVal() > this.myLemma.getM()) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |vxy| <= m");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else if (this.myVPanel.getVal() - this.myUPanel.getVal() + (this.myYPanel.getVal() - this.myXPanel.getVal()) < 1) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |vy| >= 1");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else {
                this.setDescription("Click \"Set uvxyz\" to set decomposition.");
                this.myButton.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void setI() {
        int[] d = new int[]{this.myUPanel.getVal(), this.myVPanel.getVal() - this.myUPanel.getVal(), this.myXPanel.getVal() - this.myVPanel.getVal(), this.myYPanel.getVal() - this.myXPanel.getVal(), this.myLemma.getW().length() - this.myYPanel.getVal()};
        this.myLemma.chooseDecomposition(d);
        if (this.myCases != null) {
            this.myCases.setDecomposition(d);
            this.myCases.setI(this.myLemma.getI());
        }
    }

    protected void setCanvas() {
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getU(), "u");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getV(), "v");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getZ(), "z");
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = this.myLemma.getI();
        nArray[3] = 1;
        nArray[4] = this.myLemma.getI();
        nArray[5] = 1;
        this.myCanvas.moveText(nArray);
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    protected String createXYZ() {
        return "<i>uv</i><sup>" + this.myLemma.getI() + "</sup><i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    protected void resetSliders() {
        this.myUPanel.reset();
        this.myVPanel.reset();
        this.myXPanel.reset();
        this.myYPanel.reset();
        this.myZDisplay.setText("");
        this.myZLength.setText("");
        this.updateTable();
    }

    protected void promptWinner() {
        if (this.myLemma.isInLang()) {
            this.setWinner(YOU_WIN);
            this.setDescription(DESCRIBE_YOU_WIN);
        } else {
            this.setWinner(I_WIN);
        }
    }

    public void update() {
        this.setInstruction("");
        this.setDescription("");
        ContextFreePumpingLemma pl = (ContextFreePumpingLemma)this.myLemma;
        if (pl.getM() == -1) {
            this.setDescription("File loaded.");
            return;
        }
        this.myCases.setListButtonEnabled(true);
        this.myMInput.setText("" + pl.getM());
        this.myWDisplay.setText(pl.getW());
        int[] decomposition = new int[]{pl.getU().length(), pl.getV().length(), pl.getX().length(), pl.getY().length()};
        this.myUPanel.setText(pl.getW());
        this.myUPanel.setSliderMax(pl.getW().length());
        this.myVPanel.setText(pl.getW());
        this.myVPanel.setSliderMax(pl.getW().length());
        this.myXPanel.setText(pl.getW());
        this.myXPanel.setSliderMax(pl.getW().length());
        this.myYPanel.setText(pl.getW());
        this.myYPanel.setSliderMax(pl.getW().length());
        this.setDecomposition(decomposition, pl.getI());
        this.myCases.setDecomposition(decomposition);
        this.updateTable();
        this.setDescription("File loaded.");
        if (pl.getU().length() == 0 && pl.getV().length() == 0 && pl.getX().length() == 0 && pl.getY().length() == 0) {
            this.myButton.setEnabled(false);
            this.setInstruction(PROMPT_DECOMPOSITION);
        } else {
            this.myCases.setAddButtonEnabled(true);
            this.myIDisplay.setText("" + pl.getI());
            this.displayI();
            this.myCanvas.setRestartEnabled(true);
            this.setInstruction("Click \"Restart\" to restart animation.");
        }
    }
}

