/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.MovingText;
import gui.pumping.Text;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Canvas
extends JPanel {
    private ArrayList myLabelText = new ArrayList();
    private ArrayList myInitialText = new ArrayList();
    private ArrayList myMovingText = new ArrayList();
    private ArrayList myFinalText = new ArrayList();
    private static final Point2D.Double FIRST_ROW = new Point2D.Double(40.0, 40.0);
    private static final Point2D.Double SECOND_ROW = new Point2D.Double(80.0, 80.0);
    private static final Dimension MIN_SIZE = new Dimension(300, 80);
    private JButton myStepButton;
    private JButton myRestartButton;
    private boolean wait = true;

    public Canvas() {
        super(new BorderLayout());
        this.setMinimumSize(MIN_SIZE);
        this.setPreferredSize(MIN_SIZE);
    }

    public void setRestartEnabled(boolean b) {
        this.myRestartButton.setEnabled(b);
    }

    public void start() {
        this.wait = false;
        this.getRootPane().repaint();
    }

    public void stop() {
        this.wait = true;
    }

    public void setStepButton(JButton b) {
        this.myStepButton = b;
    }

    public void setRestartButton(JButton b) {
        this.myRestartButton = b;
    }

    public void reset() {
        this.stop();
        this.myLabelText.clear();
        this.myInitialText.clear();
        this.myMovingText.clear();
        this.myFinalText.clear();
        this.myStepButton.setEnabled(false);
        this.myRestartButton.setEnabled(false);
    }

    public Text addText(String s, String label) {
        Text u = this.addText(s);
        this.myLabelText.add(Text.getLabel(this.getGraphics(), u, label));
        return u;
    }

    public Text addText(String s) {
        Point2D.Double p;
        if (this.myInitialText.isEmpty()) {
            p = FIRST_ROW;
        } else {
            Text t = (Text)this.myInitialText.get(this.myInitialText.size() - 1);
            Point2D.Double q = t.getPos();
            p = new Point2D.Double(((Point2D)q).getX() + t.getWidth(this.getGraphics()) + Text.SPACE.getWidth(this.getGraphics()), ((Point2D)q).getY());
        }
        Text u = new Text(s, p);
        if (u.toString().length() == 0) {
            u = new Text(Text.SPACE.toString(), p);
        }
        this.myInitialText.add(u);
        return u;
    }

    public void moveText(int[] n) {
        double distance = 0.0;
        int i = 0;
        while (i < this.myInitialText.size()) {
            Text s = (Text)this.myInitialText.get(i);
            int j = 0;
            while (j < n[i]) {
                if (s.toString().length() != 0 && !s.toString().equals(Text.SPACE.toString())) {
                    Point2D.Double p = this.myMovingText.isEmpty() ? SECOND_ROW : new Point2D.Double(Canvas.SECOND_ROW.x + distance, Canvas.SECOND_ROW.y);
                    distance += s.getWidth(this.getGraphics()) + 2.0;
                    MovingText t = new MovingText(s, (Point2D)p);
                    this.myMovingText.add(t);
                }
                ++j;
            }
            ++i;
        }
    }

    public void paintComponent(Graphics pen) {
        Text t;
        int i = 0;
        while (i < this.myLabelText.size()) {
            Text l = (Text)this.myLabelText.get(i);
            l.paint(pen);
            ++i;
        }
        i = 0;
        while (i < this.myInitialText.size()) {
            t = (Text)this.myInitialText.get(i);
            t.paint(pen);
            ++i;
        }
        i = 0;
        while (i < this.myFinalText.size()) {
            t = (Text)this.myFinalText.get(i);
            t.paint(pen);
            ++i;
        }
        if (this.wait) {
            return;
        }
        this.myRestartButton.setEnabled(true);
        if (!this.myMovingText.isEmpty()) {
            MovingText m = (MovingText)this.myMovingText.get(0);
            if (m.move()) {
                this.myFinalText.add(m.finalText());
                int i2 = 0;
                while (i2 < this.myFinalText.size()) {
                    Text t2 = (Text)this.myFinalText.get(i2);
                    t2.paint(pen);
                    ++i2;
                }
                this.myMovingText.remove(0);
                if (this.myMovingText.isEmpty()) {
                    this.myStepButton.setEnabled(false);
                }
                return;
            }
            m.paint(pen);
        }
        this.getRootPane().repaint();
    }
}

