/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.pumping.CFPumpingLemmaInputPane;
import gui.pumping.PumpingLemmaChooser;
import gui.pumping.PumpingLemmaChooserPane;
import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.RegPumpingLemmaInputPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import pumping.ContextFreePumpingLemma;
import pumping.PumpingLemma;
import pumping.RegularPumpingLemma;

public class PumpingLemmaChooserPane
extends JPanel {
    PumpingLemmaChooser myChooser;
    Environment myEnvironment;

    public PumpingLemmaChooserPane(PumpingLemmaChooser plc, Environment env) {
        super.setLayout(new BoxLayout(this, 1));
        this.myChooser = plc;
        this.myEnvironment = env;
        this.init();
    }

    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    private void init() {
        int i = 0;
        while (i < this.myChooser.size()) {
            this.add(this.addPumpingLemma(i));
            ++i;
        }
    }

    private JPanel addPumpingLemma(int i) {
        PumpingLemma lemma = this.myChooser.get(i);
        JPanel pane = new JPanel(new BorderLayout());
        JEditorPane ep = new JEditorPane("text/html", "<html><body align=center><b><i>L</i> = {" + lemma.getHTMLTitle() + "}</b></body></html>");
        ep.setBackground(this.getBackground());
        ep.setDisabledTextColor(Color.BLACK);
        ep.setEnabled(false);
        pane.add((Component)ep, "Center");
        PumpingLemmaChooseButton button = new PumpingLemmaChooseButton(this.myChooser.get(i), this.myEnvironment, i);
        pane.add((Component)button, "East");
        pane.setBorder(BorderFactory.createEtchedBorder());
        return pane;
    }

    private class PumpingLemmaChooseButton
    extends JButton {
        private Environment myEnvironment;
        private PumpingLemma myLemma;
        private int myIndex;

        public PumpingLemmaChooseButton(PumpingLemma pl, Environment env, int index) {
            super("Select");
            this.myEnvironment = env;
            this.myLemma = pl;
            this.myIndex = index;
            this.addActionListener(new ActionListener(this){
                final /* synthetic */ PumpingLemmaChooseButton this$1;
                {
                    this.this$1 = pumpingLemmaChooseButton;
                }

                public void actionPerformed(ActionEvent e) {
                    PumpingLemmaChooseButton.access$0(this.this$1).clearDoneCases();
                    PumpingLemmaChooseButton.access$3((PumpingLemmaChooseButton)this.this$1).myChooser.setCurrent(PumpingLemmaChooseButton.access$1(this.this$1));
                    PumpingLemmaInputPane pane = PumpingLemmaChooseButton.access$0(this.this$1) instanceof RegularPumpingLemma ? new RegPumpingLemmaInputPane((RegularPumpingLemma)PumpingLemmaChooseButton.access$0(this.this$1)) : (PumpingLemmaChooseButton.access$0(this.this$1) instanceof ContextFreePumpingLemma ? new CFPumpingLemmaInputPane((ContextFreePumpingLemma)PumpingLemmaChooseButton.access$0(this.this$1)) : null);
                    PumpingLemmaChooseButton.access$2(this.this$1).add((Component)pane, "Pumping Lemma", new CriticalTag(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }
                    });
                    PumpingLemmaChooseButton.access$2(this.this$1).setActive(pane);
                }
            });
        }

        static /* synthetic */ PumpingLemma access$0(PumpingLemmaChooseButton pumpingLemmaChooseButton) {
            return pumpingLemmaChooseButton.myLemma;
        }

        static /* synthetic */ int access$1(PumpingLemmaChooseButton pumpingLemmaChooseButton) {
            return pumpingLemmaChooseButton.myIndex;
        }

        static /* synthetic */ Environment access$2(PumpingLemmaChooseButton pumpingLemmaChooseButton) {
            return pumpingLemmaChooseButton.myEnvironment;
        }

        static /* synthetic */ PumpingLemmaChooserPane access$3(PumpingLemmaChooseButton pumpingLemmaChooseButton) {
            return pumpingLemmaChooseButton.PumpingLemmaChooserPane.this;
        }
    }
}

