/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.Canvas;
import gui.pumping.CasePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import pumping.ContextFreePumpingLemma;
import pumping.PumpingLemma;

public abstract class PumpingLemmaInputPane
extends JPanel {
    protected static Dimension MAX_SIZE = new Dimension(640, 480);
    protected static int DELAY = 3000;
    protected static Color INITIAL_COLOR = Color.BLUE;
    protected static Color FINAL_COLOR = Color.BLACK;
    protected static String PROMPT_M = "Please select a value for m in Box 1 and press \"Enter\".";
    protected static String DESCRIBE_W = "I have selected w such that |w| >= m. It is displayed in Box 2.";
    protected static String PROMPT_DECOMPOSITION = "Please select the decomposition of w in Box 3 using the sliders.";
    protected static String DESCRIBE_I = "I have selected i to give a contradition. It is displayed in Box 4.";
    protected static String PROMPT_ANIM = "Click \"Step\" in Box 5 to step the animation.";
    protected static String PROMPT_CASE = "Click \"Step\" in Box 5 to step the animation or \"Add\" in the right panel to add this case.";
    protected static String DESCRIBE_YOU_WIN = "No i gives a contradiction. One i is shown below.";
    protected PumpingLemma myLemma;
    private JLabel myInstruction;
    private Timer myInstructionTimer;
    private JLabel myDescription;
    private Timer myDescriptionTimer;
    private JLabel myWinner;
    private Timer myWinnerTimer;
    protected JTextField myMInput;
    protected JTextArea myWDisplay;
    protected JTextArea myIDisplay;
    protected JTextArea myPumpedStringDisplay;
    protected Canvas myCanvas;
    protected JButton myStartAnimation;
    protected JButton myStepAnimation;
    protected JEditorPane myLastWord;
    protected CasePanel myCases;
    protected JTable myXYZDisplay;
    protected JPanel myXYZPanel;

    public PumpingLemmaInputPane(PumpingLemma l, String title) {
        this.setLayout(new BorderLayout());
        this.myLemma = l;
        JPanel p = new JPanel(new BorderLayout());
        JEditorPane ep = new JEditorPane("text/html", "<html><body align=center><b>" + title + "</b></body></html>");
        ep.setBackground(this.getBackground());
        ep.setDisabledTextColor(Color.BLACK);
        ep.setEnabled(false);
        p.add((Component)ep, "North");
        if (this.myLemma.numCasesTotal() <= 1) {
            JPanel leftPanel = this.initLeftPanel();
            leftPanel.setPreferredSize(MAX_SIZE);
            leftPanel.setMaximumSize(MAX_SIZE);
            p.add((Component)leftPanel, "Center");
        } else {
            JSplitPane splitPane = new JSplitPane(1);
            JPanel leftPanel = this.initLeftPanel();
            leftPanel.setPreferredSize(new Dimension(400, 300));
            leftPanel.setMaximumSize(MAX_SIZE);
            splitPane.setLeftComponent(leftPanel);
            JComponent rightPanel = this.initRightPanel();
            rightPanel.setPreferredSize(new Dimension(400, 300));
            rightPanel.setMaximumSize(MAX_SIZE);
            splitPane.setRightComponent(rightPanel);
            p.add((Component)splitPane, "Center");
        }
        JScrollPane scrollPane = new JScrollPane(p);
        this.add((Component)scrollPane, "Center");
        this.setMaximumSize(MAX_SIZE);
        this.setPreferredSize(MAX_SIZE);
    }

    protected void setLabel(Timer timer, JLabel label, String s) {
        label.setForeground(INITIAL_COLOR);
        label.setText(s);
        timer.restart();
    }

    protected void setInstruction(String s) {
        if (!s.equals(this.myInstruction.getText())) {
            this.setLabel(this.myInstructionTimer, this.myInstruction, s);
        }
    }

    protected void setDescription(String s) {
        if (!s.equals(this.myDescription.getText())) {
            this.setLabel(this.myDescriptionTimer, this.myDescription, s);
        }
    }

    protected void setWinner(String s) {
        this.myWinner.setForeground(INITIAL_COLOR);
        this.myWinner.setText(s);
    }

    protected abstract void promptWinner();

    protected void initTimer() {
        ActionListener fadeInstruction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.myInstruction.setForeground(FINAL_COLOR);
            }
        };
        this.myInstructionTimer = new Timer(DELAY, fadeInstruction);
        ActionListener fadeDescription = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.myDescription.setForeground(FINAL_COLOR);
            }
        };
        this.myDescriptionTimer = new Timer(DELAY, fadeDescription);
        ActionListener fadeWinner = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.myWinner.setForeground(FINAL_COLOR);
            }
        };
        this.myWinnerTimer = new Timer(DELAY, fadeWinner);
    }

    protected JPanel initInstructions() {
        JPanel p = new JPanel(new BorderLayout());
        Dimension d = new Dimension(640, 80);
        p.setPreferredSize(d);
        p.setMaximumSize(d);
        this.myInstruction = new JLabel();
        this.myDescription = new JLabel();
        this.myWinner = new JLabel();
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 1));
        q.add(this.myWinner);
        q.add(this.myDescription);
        q.add(this.myInstruction);
        q.setBorder(BorderFactory.createTitledBorder("Messages"));
        p.add((Component)q, "Center");
        this.initTimer();
        this.setInstruction(PROMPT_M);
        return p;
    }

    protected void reset() {
        this.myLemma.reset();
        this.myWDisplay.setText("");
        this.resetSliders();
        this.myXYZPanel.remove(this.myXYZDisplay);
        this.myXYZDisplay = new JTable(1, 1);
        this.myXYZDisplay.setEnabled(false);
        this.myXYZPanel.add(this.myXYZDisplay);
        this.myDescription.setText("");
        this.myWinner.setText("");
        this.myInstruction.setText(PROMPT_M);
        if (this.myCases != null) {
            this.myCases.clearAll();
            this.myCases.setMessage("");
            this.myCases.setListButtonEnabled(false);
            this.myCases.setAddButtonEnabled(false);
        }
    }

    protected abstract void resetSliders();

    protected JPanel initLeftPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.initInstructions());
        p.add(this.initM());
        p.add(this.initW());
        p.add(this.initChooser());
        p.add(this.initI());
        p.add(this.initCanvas());
        return p;
    }

    protected JComponent initRightPanel() {
        this.myCases = new CasePanel((ContextFreePumpingLemma)this.myLemma, this);
        return new JScrollPane(this.myCases);
    }

    protected JPanel initM() {
        JPanel p = new JPanel(new BorderLayout());
        this.myMInput = new JTextField(10);
        this.myMInput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PumpingLemmaInputPane.this.reset();
                    int m = Integer.parseInt(ev.getActionCommand());
                    if (m < PumpingLemmaInputPane.this.myLemma.getRange()[0] || m > PumpingLemmaInputPane.this.myLemma.getRange()[1]) {
                        throw new NumberFormatException();
                    }
                    PumpingLemmaInputPane.this.myLemma.chooseM(m);
                    PumpingLemmaInputPane.this.mEnteredReset();
                    PumpingLemmaInputPane.this.setDescription(DESCRIBE_W);
                    PumpingLemmaInputPane.this.setInstruction(PROMPT_DECOMPOSITION);
                    if (PumpingLemmaInputPane.this.myCases != null) {
                        PumpingLemmaInputPane.this.myCases.setListButtonEnabled(true);
                    }
                }
                catch (NumberFormatException e) {
                    String error = "Please enter a positive integer in range [" + PumpingLemmaInputPane.this.myLemma.getRange()[0] + ", " + PumpingLemmaInputPane.this.myLemma.getRange()[1] + "] for best results.";
                    PumpingLemmaInputPane.this.myMInput.selectAll();
                    PumpingLemmaInputPane.this.setDescription(error);
                }
            }
        });
        JPanel q = new JPanel(new BorderLayout());
        q.add((Component)this.myMInput, "North");
        q.setBorder(BorderFactory.createTitledBorder("1. Select integer m"));
        p.add((Component)q, "Center");
        JPanel s = new JPanel();
        s.setLayout(new BoxLayout(s, 0));
        JPanel r = new JPanel();
        r.setLayout(new BoxLayout(r, 1));
        JButton b = new JButton("Start over");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.myMInput.setText("");
                PumpingLemmaInputPane.this.reset();
            }
        });
        r.add(b);
        s.add(r);
        p.add((Component)s, "East");
        p.setMaximumSize(MAX_SIZE);
        return p;
    }

    protected JPanel initW() {
        JPanel p = new JPanel(new BorderLayout());
        this.myWDisplay = new JTextArea(1, 20);
        this.myWDisplay.setEditable(false);
        p.setBorder(BorderFactory.createTitledBorder("2. Given integer m, here's string w such that |w| >= m"));
        p.add((Component)this.myWDisplay, "North");
        p.setMaximumSize(MAX_SIZE);
        return p;
    }

    protected JPanel initI() {
        JPanel o = new JPanel(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("i: "));
        this.myIDisplay = new JTextArea(1, 5);
        this.myIDisplay.setEditable(false);
        p.add(this.myIDisplay);
        p.add(new JLabel("    pumped string: "));
        this.myPumpedStringDisplay = new JTextArea(1, 30);
        this.myPumpedStringDisplay.setEditable(false);
        p.add(this.myPumpedStringDisplay);
        o.setBorder(BorderFactory.createTitledBorder("4. A choice of i to give contradiction"));
        o.add((Component)p, "North");
        o.setMaximumSize(MAX_SIZE);
        return o;
    }

    protected abstract JPanel initChooser();

    protected abstract void refresh();

    protected abstract void mEnteredReset();

    protected abstract void setCanvas();

    protected abstract String createXYZ();

    protected void displayI() {
        this.myIDisplay.setText(Integer.toString(this.myLemma.getI()));
        String s = this.myLemma.createPumpedString();
        this.myPumpedStringDisplay.setText(s);
        if (this.myLemma.isInLang()) {
            this.myLastWord.setText(String.valueOf(this.createXYZ()) + " = " + PumpingLemmaInputPane.toHTMLString(s) + " = " + s + " is in the language. I lose.");
        } else {
            this.myLastWord.setText(String.valueOf(this.createXYZ()) + " = " + PumpingLemmaInputPane.toHTMLString(s) + " = " + s + " is NOT in the language: CONTRADICTION.");
        }
    }

    protected void stepAnimation() {
        this.repaint();
    }

    protected JPanel initCanvas() {
        JPanel p = new JPanel(new BorderLayout());
        this.myCanvas = new Canvas();
        p.add((Component)this.myCanvas, "Center");
        this.myLastWord = new JEditorPane("text/html", "");
        this.myLastWord.setBackground(this.getBackground());
        this.myLastWord.setDisabledTextColor(Color.BLACK);
        this.myLastWord.setEnabled(false);
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 0));
        q.add(this.myLastWord);
        this.myStepAnimation = new JButton("Step");
        this.myStepAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.stepAnimation();
                PumpingLemmaInputPane.this.myCanvas.start();
            }
        });
        this.myStepAnimation.setEnabled(false);
        q.add(this.myStepAnimation);
        this.myCanvas.setStepButton(this.myStepAnimation);
        this.myStartAnimation = new JButton("Restart");
        this.myStartAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.setCanvas();
                PumpingLemmaInputPane.this.myCanvas.stop();
                PumpingLemmaInputPane.this.repaint();
            }
        });
        this.myStartAnimation.setEnabled(false);
        q.add(this.myStartAnimation);
        this.myCanvas.setRestartButton(this.myStartAnimation);
        p.add((Component)q, "South");
        p.setBorder(BorderFactory.createTitledBorder("5. Animation"));
        p.setMaximumSize(MAX_SIZE);
        return p;
    }

    public static String toHTMLString(String s) {
        if (s.length() == 0) {
            return "";
        }
        int count = 1;
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int j = i + 1;
            while (j < s.length()) {
                if (s.substring(j, j + 1).equals(s.substring(i, i + 1))) {
                    ++count;
                } else {
                    ret.append("<i>");
                    ret.append(s.substring(i, i + 1));
                    ret.append("</i>");
                    if (count > 1) {
                        ret.append("<sup>");
                        ret.append("" + count);
                        ret.append("</sup>");
                    }
                    i = j;
                    count = 1;
                }
                if (j == s.length() - 1) {
                    ret.append("<i>");
                    ret.append(s.substring(s.length() - 1));
                    ret.append("</i>");
                    if (count > 1) {
                        ret.append("<sup>");
                        ret.append("" + count);
                        ret.append("</sup>");
                    }
                    return ret.toString();
                }
                ++j;
            }
            ++i;
        }
        System.err.println("BUG FOUND: PumpingLemmaInputPane.toHTMLString(String)");
        return ret.toString();
    }

    public abstract void setDecomposition(int[] var1);

    public abstract void setDecomposition(int[] var1, int var2);

    public void updateTable() {
        this.myXYZPanel.remove(this.myXYZDisplay);
        this.myXYZDisplay = new JTable(1, this.myLemma.getW().length());
        this.myXYZDisplay.setEnabled(false);
        String s = this.myLemma.getW();
        int i = 0;
        while (i < s.length()) {
            this.myXYZDisplay.setValueAt(s.substring(i, i + 1), 0, i);
            ++i;
        }
        this.myXYZPanel.add((Component)this.myXYZDisplay, "Center");
    }

    public abstract void update();
}

