/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.SliderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import pumping.RegularPumpingLemma;

public class RegPumpingLemmaInputPane
extends PumpingLemmaInputPane {
    private static String I_WIN = "I WIN. Do you want to play again or concede that the language is not regular?";
    private static String YOU_WIN = "YOU WIN. Does this mean the language is regular?";
    private SliderPanel myXPanel;
    private SliderPanel myYPanel;
    private JButton myButton;
    private JTextArea myZDisplay;
    private JTextArea myZLength;

    public RegPumpingLemmaInputPane(RegularPumpingLemma l) {
        super(l, "<i>L</i> = {" + l.getHTMLTitle() + "} Regular Pumping Lemma");
    }

    protected JPanel initChooser() {
        JPanel n = new JPanel(new BorderLayout());
        JPanel o = new JPanel();
        o.setLayout(new BoxLayout(o, 0));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.myXPanel = new SliderPanel("x", this);
        p.add(this.myXPanel);
        this.myYPanel = new SliderPanel("y", this);
        p.add(this.myYPanel);
        JPanel m = new JPanel();
        m.setLayout(new BoxLayout(m, 0));
        m.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 7));
        m.add(new JLabel("z: "));
        this.myZDisplay = new JTextArea(1, 30);
        this.myZDisplay.setEditable(false);
        m.add(this.myZDisplay);
        m.add(new JLabel("    |z|: "));
        this.myZLength = new JTextArea(1, 5);
        this.myZLength.setEditable(false);
        m.add(this.myZLength);
        p.add(m);
        this.myXYZPanel = new JPanel(new BorderLayout());
        this.myXYZDisplay = new JTable(1, 1);
        this.myXYZDisplay.setEnabled(false);
        this.myXYZPanel.add(this.myXYZDisplay);
        this.myXYZPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 7));
        p.add((Component)this.myXYZPanel, "South");
        o.add(p);
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 1));
        this.myButton = new JButton("Set xyz");
        this.myButton.setEnabled(false);
        this.myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                RegPumpingLemmaInputPane.this.setI();
                RegPumpingLemmaInputPane.this.displayI();
                RegPumpingLemmaInputPane.this.setCanvas();
                RegPumpingLemmaInputPane.this.myCanvas.stop();
                RegPumpingLemmaInputPane.this.setDescription(DESCRIBE_I);
                if (RegPumpingLemmaInputPane.this.myCases != null) {
                    RegPumpingLemmaInputPane.this.myCases.setAddButtonEnabled(true);
                    RegPumpingLemmaInputPane.this.setInstruction(PROMPT_CASE);
                } else {
                    RegPumpingLemmaInputPane.this.setInstruction(PROMPT_ANIM);
                }
                RegPumpingLemmaInputPane.this.promptWinner();
            }
        });
        q.add(this.myButton);
        o.add(q);
        n.add((Component)o, "North");
        n.setBorder(BorderFactory.createTitledBorder("3. Select decomposition of w into xyz"));
        n.setMaximumSize(new Dimension(640, 480));
        return n;
    }

    protected void setCanvas() {
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getZ(), "z");
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = this.myLemma.getI();
        nArray[3] = 1;
        this.myCanvas.moveText(nArray);
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    protected void mEnteredReset() {
        String s = this.myLemma.getW();
        this.myWDisplay.setText(s);
        this.myXPanel.setSliderMax(s.length());
        this.myXPanel.setVal(0);
        this.myXPanel.setText(this.myLemma.getW());
        this.myYPanel.setSliderMax(s.length());
        this.myYPanel.setVal(0);
        this.myYPanel.setText(this.myLemma.getW());
        this.refresh();
        this.updateTable();
    }

    protected void refresh() {
        try {
            this.myXPanel.setRange(0, this.myYPanel.getVal() - 1);
            this.myYPanel.setRange(this.myXPanel.getVal(), this.myLemma.getM());
            this.myZDisplay.setText(this.myLemma.getW().substring(this.myYPanel.getVal()));
            this.myZLength.setText(Integer.toString(this.myZDisplay.getText().length()));
            this.myIDisplay.setText("");
            this.myPumpedStringDisplay.setText("");
            this.myLastWord.setText("");
            this.myCanvas.reset();
            if (this.myXPanel.getVal() >= this.myYPanel.getVal()) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |y| > 0");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else if (this.myYPanel.getVal() > this.myLemma.getM()) {
                this.myZDisplay.setText("");
                this.setDescription("Condition violated: |xy| <= m");
                this.myZLength.setText("");
                this.myButton.setEnabled(false);
            } else {
                this.setDescription("Click \"Set xyz\" to set decomposition.");
                this.myButton.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void setI() {
        int[] d = new int[]{this.myXPanel.getVal(), this.myYPanel.getVal() - this.myXPanel.getVal()};
        this.myLemma.chooseDecomposition(d);
        if (this.myCases != null) {
            this.myCases.setDecomposition(d);
            this.myCases.setI(this.myLemma.getI());
        }
    }

    protected String createXYZ() {
        return "<i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    public void setDecomposition(int[] decomposition) {
        this.myXPanel.setVal(decomposition[0]);
        this.myYPanel.setVal(decomposition[0] + decomposition[1]);
    }

    public void setDecomposition(int[] decomposition, int num) {
        this.setDecomposition(decomposition);
        this.myLemma.chooseDecomposition(decomposition, num);
    }

    protected void resetSliders() {
        this.myXPanel.reset();
        this.myYPanel.reset();
        this.myZDisplay.setText("");
        this.myZLength.setText("");
        this.updateTable();
    }

    protected void promptWinner() {
        if (this.myLemma.isInLang()) {
            this.setWinner(YOU_WIN);
            this.setDescription(DESCRIBE_YOU_WIN);
        } else {
            this.setWinner(I_WIN);
        }
    }

    public void update() {
        this.setInstruction("");
        this.setDescription("");
        RegularPumpingLemma pl = (RegularPumpingLemma)this.myLemma;
        if (pl.getM() == -1) {
            this.setDescription("File loaded.");
            return;
        }
        this.myMInput.setText("" + pl.getM());
        this.myWDisplay.setText(pl.getW());
        this.myXPanel.setText(pl.getW());
        this.myXPanel.setSliderMax(pl.getW().length());
        this.myYPanel.setText(pl.getW());
        this.myYPanel.setSliderMax(pl.getW().length());
        this.setDecomposition(new int[]{pl.getX().length(), pl.getY().length()}, pl.getI());
        this.updateTable();
        this.setDescription("File loaded");
        if (pl.getX().length() == 0 && pl.getY().length() == 0) {
            this.myButton.setEnabled(false);
            this.setInstruction(PROMPT_DECOMPOSITION);
        } else {
            this.myIDisplay.setText("" + pl.getI());
            this.displayI();
            this.myCanvas.setRestartEnabled(true);
            this.setInstruction("Click \"Restart\" to restart animation.");
        }
    }
}

