/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel {
    private static int START_MAX = 10;
    private PumpingLemmaInputPane myPane;
    private JTextArea myDisplay;
    private JTextArea myLengthDisplay;
    private JSlider mySlider;
    private int myMin;
    private int myMax;
    private String myText;

    public SliderPanel(String s, PumpingLemmaInputPane p) {
        super(new BorderLayout());
        this.myPane = p;
        this.myDisplay = new JTextArea(1, 30);
        this.myDisplay.setEditable(false);
        this.myLengthDisplay = new JTextArea(1, 5);
        this.myLengthDisplay.setEditable(false);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 0));
        displayPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 7));
        displayPanel.add(new JLabel(String.valueOf(s) + ": "));
        displayPanel.add(this.myDisplay);
        displayPanel.add(new JLabel("    |" + s + "|: "));
        displayPanel.add(this.myLengthDisplay);
        this.add((Component)displayPanel, "Center");
        this.mySlider = new JSlider(0, START_MAX);
        this.mySlider.setValue(0);
        this.mySlider.setPaintTicks(true);
        this.mySlider.setMinorTickSpacing(1);
        this.mySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SliderPanel.this.refresh();
                SliderPanel.this.myPane.refresh();
            }
        });
        this.add((Component)this.mySlider, "South");
        this.myMin = 0;
        this.myMax = 0;
        this.myText = "";
    }

    public void setRange(int min, int max) {
        this.myMax = max;
        this.setMin(min);
    }

    public void setMin(int min) {
        this.myMin = min;
        this.refresh();
    }

    public void setSliderMax(int i) {
        this.mySlider.setMaximum(i);
    }

    public void setVal(int i) {
        this.mySlider.setValue(i);
        this.refresh();
    }

    public void setText(String s) {
        this.myText = s;
        this.refresh();
    }

    public void refresh() {
        try {
            int i = this.mySlider.getValue();
            if (i > this.myMax) {
                i = this.myMax;
            }
            if (this.mySlider.getValue() < this.myMin) {
                this.mySlider.setValue(this.myMin);
            }
            this.myDisplay.setText(this.myText.substring(this.myMin, i));
            this.myLengthDisplay.setText("" + (this.mySlider.getValue() - this.myMin));
            this.repaint();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getVal() {
        return this.mySlider.getValue();
    }

    public void reset() {
        this.mySlider.setMaximum(START_MAX);
        this.setVal(0);
        this.setText("");
        this.myLengthDisplay.setText("");
    }
}

