/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import regular.ExpressionChangeEvent;
import regular.ExpressionChangeListener;
import regular.RegularExpression;

public class EditorPane
extends JPanel {
    private RegularExpression expression;
    private JTextField field = new JTextField("");
    private ExpressionChangeListener listener = new ExpressionChangeListener(){

        public void expressionChanged(ExpressionChangeEvent e) {
            EditorPane.this.field.setText(e.getExpression().asString());
        }
    };
    private Reference ref = new WeakReference((Object)null){

        public Object get() {
            return EditorPane.this.field.getText();
        }
    };

    public EditorPane(RegularExpression expression) {
        this.expression = expression;
        this.field.setText(expression.asString());
        this.field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditorPane.this.updateExpression();
            }
        });
        this.field.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                EditorPane.this.updateExpression();
            }

            public void removeUpdate(DocumentEvent e) {
                EditorPane.this.updateExpression();
            }

            public void changedUpdate(DocumentEvent e) {
                EditorPane.this.updateExpression();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)new JLabel("Edit the regular expression below:"), c);
        this.add((Component)this.field, c);
    }

    private void updateExpression() {
        this.expression.change(this.ref);
    }
}

