/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import automata.Transition;
import automata.fsa.FSAToRegularExpressionConverter;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.regular.TransitionWindow;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import regular.RegularExpression;

public class FSAToREController {
    private int currentStep = -1;
    private FiniteStateAutomaton automaton;
    private SelectionDrawer drawer;
    private JLabel mainStep;
    private JLabel detailStep;
    private JFrame frame;
    private int remaining = 0;
    private TransitionWindow transitionWindow = null;
    private State collapseState = null;
    private String computedRE = null;
    private static final FSAToRegularExpressionConverter convert = new FSAToRegularExpressionConverter();
    private static final int CREATE_SINGLE_FINAL = 0;
    private static final int TRANSITIONS_TO_SINGLE_FINAL = 1;
    private static final int CONVERT_TRANSITIONS = 2;
    private static final int CREATE_EMPTY_TRANSITIONS = 3;
    private static final int COLLAPSE_STATES = 4;
    private static final int FINISHED = 200;

    public FSAToREController(FiniteStateAutomaton automaton, SelectionDrawer drawer, JLabel mainStep, JLabel detailStep, JFrame frame) {
        this.automaton = automaton;
        this.drawer = drawer;
        this.mainStep = mainStep;
        this.detailStep = detailStep;
        this.frame = frame;
        this.nextStep();
    }

    protected void outOfOrder() {
        JOptionPane.showMessageDialog(this.frame, "That action is inappropriate for this step!", "Out of Order", 0);
    }

    protected void nextStep() {
        switch (this.currentStep) {
            case -1: 
            case 0: {
                this.currentStep = 0;
                this.mainStep.setText("Make Single Noninitial Final State");
                this.detailStep.setText("Create a new state to make a single final state.");
                if (this.automaton.getFinalStates().length != 1 || this.automaton.getFinalStates()[0] == this.automaton.getInitialState()) {
                    return;
                }
                this.currentStep = 1;
            }
            case 1: {
                this.detailStep.setText("Put " + Universe.curProfile.getEmptyString() + "-transitions from old final states to new.");
                if (this.drawer.numberSelected() != 0) {
                    return;
                }
                this.currentStep = 2;
                this.remaining = this.collapsesNeeded();
            }
            case 2: {
                this.mainStep.setText("Reform Transitions");
                this.detailStep.setText("Use the collapse tool to turn multiple transitions to one. " + this.remaining + " more collapses needed.");
                if (this.remaining != 0) {
                    return;
                }
                this.currentStep = 3;
                this.remaining = this.emptyNeeded();
            }
            case 3: {
                this.detailStep.setText("Put empty transitions between states with no transitions. " + this.remaining + " more empty transitions needed.");
                if (this.remaining != 0) {
                    return;
                }
                this.remaining = this.automaton.getStates().length - 2;
                this.currentStep = 4;
            }
            case 4: {
                this.mainStep.setText("Remove States");
                this.detailStep.setText("Use the collapse state tool to remove nonfinal, noninitial states. " + this.remaining + " more removals needed.");
                if (this.remaining != 0) {
                    return;
                }
                if (this.transitionWindow != null) {
                    this.transitionWindow.setVisible(false);
                    this.transitionWindow.dispose();
                }
                this.drawer.clearSelected();
                this.drawer.clearSelectedTransitions();
                this.currentStep = 200;
            }
            case 200: {
                this.mainStep.setText("Generalized Transition Graph Finished!");
                this.computedRE = convert.getExpressionFromGTG(this.automaton);
                this.detailStep.setText(this.computedRE);
            }
        }
    }

    protected int collapsesNeeded() {
        State[] states = this.automaton.getStates();
        int needed = 0;
        int i = 0;
        while (i < states.length) {
            int j = 0;
            while (j < states.length) {
                if (this.automaton.getTransitionsFromStateToState(states[i], states[j]).length > 1) {
                    ++needed;
                }
                ++j;
            }
            ++i;
        }
        return needed;
    }

    protected int emptyNeeded() {
        State[] states = this.automaton.getStates();
        int needed = 0;
        int i = 0;
        while (i < states.length) {
            int j = 0;
            while (j < states.length) {
                if (this.automaton.getTransitionsFromStateToState(states[i], states[j]).length == 0) {
                    ++needed;
                }
                ++j;
            }
            ++i;
        }
        return needed;
    }

    public State stateCreate(Point point) {
        if (this.currentStep != 0) {
            this.outOfOrder();
            return null;
        }
        State[] finals = this.automaton.getFinalStates();
        this.drawer.clearSelected();
        int i = 0;
        while (i < finals.length) {
            this.automaton.removeFinalState(finals[i]);
            this.drawer.addSelected(finals[i]);
            ++i;
        }
        State newState = this.automaton.createState(point);
        this.automaton.addFinalState(newState);
        this.frame.repaint();
        this.nextStep();
        return newState;
    }

    public Transition transitionCreate(State from, State to) {
        if (this.currentStep == 1) {
            if (this.automaton.getFinalStates()[0] != to) {
                JOptionPane.showMessageDialog(this.frame, "Transitions must go to the new final state!", "Bad Destination", 0);
                return null;
            }
            if (!this.drawer.isSelected(from)) {
                JOptionPane.showMessageDialog(this.frame, "Transitions must come from an old final state!", "Bad Source", 0);
                return null;
            }
            FSATransition t = new FSATransition(from, to, "");
            this.drawer.removeSelected(from);
            this.automaton.addTransition(t);
            this.frame.repaint();
            if (this.drawer.numberSelected() == 0) {
                this.nextStep();
            }
            return t;
        }
        if (this.currentStep == 3) {
            if (this.automaton.getTransitionsFromStateToState(from, to).length != 0) {
                JOptionPane.showMessageDialog(this.frame, "Transitions must go betweenstates with no transitions!", "Transition Already Exists", 0);
                return null;
            }
            FSATransition t = convert.addTransitionOnEmptySet(from, to, this.automaton);
            --this.remaining;
            this.nextStep();
            this.frame.repaint();
            return t;
        }
        this.outOfOrder();
        return null;
    }

    public Transition transitionCollapse(State from, State to) {
        if (this.currentStep != 2) {
            this.outOfOrder();
            return null;
        }
        Transition[] ts = this.automaton.getTransitionsFromStateToState(from, to);
        if (ts.length <= 1) {
            JOptionPane.showMessageDialog(this.frame, "Collapse requires 2 or more transitions!", "Too Few Transitions", 0);
            return null;
        }
        FSATransition t = convert.combineToSingleTransition(from, to, ts, this.automaton);
        --this.remaining;
        this.frame.repaint();
        this.nextStep();
        return t;
    }

    public boolean stateCollapse(State state) {
        if (this.currentStep != 4) {
            this.outOfOrder();
            return false;
        }
        if (this.automaton.getInitialState() == state) {
            JOptionPane.showMessageDialog(this.frame, "The initial state cannot be removed!", "Initial State Selected", 0);
            return false;
        }
        if (this.automaton.getFinalStates()[0] == state) {
            JOptionPane.showMessageDialog(this.frame, "The final state cannot be removed!", "Final State Selected", 0);
            return false;
        }
        this.collapseState = state;
        this.drawer.clearSelected();
        this.drawer.addSelected(this.collapseState);
        this.transitionWindow = new TransitionWindow(this);
        this.transitionWindow.setTransitions(convert.getTransitionsForRemoveState(state, this.automaton));
        this.transitionWindow.setVisible(true);
        return true;
    }

    public void finalizeStateRemove() {
        if (this.collapseState == null) {
            JOptionPane.showMessageDialog(this.frame, "A valid state has not been selected yet!", "No State Selected", 0);
            return;
        }
        convert.removeState(this.collapseState, this.transitionWindow.getTransitions(), this.automaton);
        --this.remaining;
        this.nextStep();
        this.collapseState = null;
        this.drawer.clearSelected();
        this.drawer.clearSelectedTransitions();
        this.transitionWindow.setVisible(false);
        this.transitionWindow.dispose();
    }

    public void tableTransitionSelected(Transition transition) {
        this.drawer.clearSelectedTransitions();
        if (transition == null || this.collapseState == null) {
            return;
        }
        State from = transition.getFromState();
        State to = transition.getToState();
        Transition a = this.automaton.getTransitionsFromStateToState(from, this.collapseState)[0];
        Transition b = this.automaton.getTransitionsFromStateToState(from, to)[0];
        Transition c = this.automaton.getTransitionsFromStateToState(this.collapseState, this.collapseState)[0];
        Transition d = this.automaton.getTransitionsFromStateToState(this.collapseState, to)[0];
        this.drawer.addSelected(a);
        this.drawer.addSelected(b);
        this.drawer.addSelected(c);
        this.drawer.addSelected(d);
        this.frame.repaint();
    }

    public void moveNextStep() {
        switch (this.currentStep) {
            case 0: {
                JOptionPane.showMessageDialog(this.frame, "Just create a state.\nIt's not too difficult.", "Create the State", 0);
                return;
            }
            case 1: {
                State[] states = this.drawer.getSelected();
                State finalState = this.automaton.getFinalStates()[0];
                int i = 0;
                while (i < states.length) {
                    this.transitionCreate(states[i], finalState);
                    ++i;
                }
                break;
            }
            case 2: {
                State[] s = this.automaton.getStates();
                int i = 0;
                while (i < s.length) {
                    int j = 0;
                    while (j < s.length) {
                        if (this.automaton.getTransitionsFromStateToState(s[i], s[j]).length > 1) {
                            this.transitionCollapse(s[i], s[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                State[] s = this.automaton.getStates();
                int i = 0;
                while (i < s.length) {
                    int j = 0;
                    while (j < s.length) {
                        if (this.automaton.getTransitionsFromStateToState(s[i], s[j]).length == 0) {
                            this.transitionCreate(s[i], s[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                State[] s = this.automaton.getStates();
                int i = 0;
                while (i < s.length) {
                    if (this.automaton.getFinalStates()[0] != s[i] && this.automaton.getInitialState() != s[i]) {
                        Transition[] t = convert.getTransitionsForRemoveState(s[i], this.automaton);
                        convert.removeState(s[i], t, this.automaton);
                    }
                    ++i;
                }
                this.remaining = 0;
                this.nextStep();
                break;
            }
            case 200: {
                JOptionPane.showMessageDialog(this.frame, "You're done.  Go away.", "You're Done!", 0);
                return;
            }
            default: {
                JOptionPane.showMessageDialog(this.frame, "This shouldn't happen!  Notify Thomas.", "Uh Oh, I'm Stupid!", 0);
            }
        }
    }

    public void export() {
        if (this.computedRE == null) {
            JOptionPane.showMessageDialog(this.frame, "The conversion has not yet finished.", "Not Finished", 0);
            return;
        }
        FrameFactory.createFrame(new RegularExpression(this.computedRE));
    }

    void exportAutomaton() {
        Environment e = ((EnvironmentFrame)this.frame).getEnvironment();
        AutomatonPane a = new AutomatonPane(this.drawer);
        e.add((Component)a, "Current FA");
        e.setActive(a);
    }
}

